/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class ChunkLoadStorage {
    private static final String TAG_COLONIES_TO_ADD = "coloniesToAdd";
    private static final String TAG_COLONIES_TO_REMOVE = "coloniesToRemove";
    private int colonyId;
    private final List<Integer> coloniesToRemove = new ArrayList<Integer>();
    private final List<Integer> coloniesToAdd = new ArrayList<Integer>();
    private final long xz;
    private final int dimension;
    private final List<Tuple<Integer, BlockPos>> claimingBuilding = new ArrayList<Tuple<Integer, BlockPos>>();
    private final List<Tuple<Integer, BlockPos>> unClaimingBuilding = new ArrayList<Tuple<Integer, BlockPos>>();

    public ChunkLoadStorage(NBTTagCompound compound) {
        this.colonyId = compound.func_74762_e("id");
        this.xz = compound.func_74763_f("pos");
        this.dimension = compound.func_74762_e("dimension");
        this.coloniesToAdd.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_COLONIES_TO_ADD, 10)).map(tempCompound -> tempCompound.func_74762_e("colony")).collect(Collectors.toList()));
        this.coloniesToRemove.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_COLONIES_TO_REMOVE, 10)).map(tempCompound -> tempCompound.func_74762_e("colony")).collect(Collectors.toList()));
        this.claimingBuilding.addAll(NBTUtils.streamCompound(compound.func_150295_c("buildingsClaim", 10)).map(ChunkLoadStorage::readTupleFromNbt).collect(Collectors.toList()));
        this.unClaimingBuilding.addAll(NBTUtils.streamCompound(compound.func_150295_c("buildingUnclaim", 10)).map(ChunkLoadStorage::readTupleFromNbt).collect(Collectors.toList()));
    }

    public ChunkLoadStorage(int colonyId, long xz, boolean add, int dimension, boolean owning) {
        this.colonyId = owning ? colonyId : 0;
        this.xz = xz;
        this.dimension = dimension;
        if (add) {
            this.coloniesToAdd.add(colonyId);
        } else {
            this.coloniesToRemove.add(colonyId);
        }
    }

    public ChunkLoadStorage(int colonyId, long xz, int dimension, BlockPos building) {
        this.xz = xz;
        this.dimension = dimension;
        this.claimingBuilding.add(new Tuple<Integer, BlockPos>(colonyId, building));
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("id", this.colonyId);
        compound.func_74772_a("pos", this.xz);
        compound.func_74768_a("dimension", this.dimension);
        compound.func_74782_a(TAG_COLONIES_TO_ADD, (NBTBase)this.coloniesToAdd.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a(TAG_COLONIES_TO_REMOVE, (NBTBase)this.coloniesToRemove.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a("buildings", (NBTBase)this.claimingBuilding.stream().map(ChunkLoadStorage::writeTupleToNBT).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a("buildings", (NBTBase)this.unClaimingBuilding.stream().map(ChunkLoadStorage::writeTupleToNBT).collect(NBTUtils.toNBTTagList()));
        return compound;
    }

    private static NBTTagCompound getCompoundOfColonyId(int id) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("colony", id);
        return compound;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public int getDimension() {
        return this.dimension;
    }

    public long getXz() {
        return this.xz;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkLoadStorage storage = (ChunkLoadStorage)o;
        return this.colonyId == storage.colonyId && this.xz == storage.xz && this.dimension == storage.dimension && Objects.equals(this.coloniesToRemove, storage.coloniesToRemove) && Objects.equals(this.coloniesToAdd, storage.coloniesToAdd) && Objects.equals(this.claimingBuilding, storage.claimingBuilding) && Objects.equals(this.unClaimingBuilding, storage.unClaimingBuilding);
    }

    public int hashCode() {
        return Objects.hash(this.colonyId, this.coloniesToRemove, this.coloniesToAdd, this.xz, this.dimension, this.claimingBuilding, this.unClaimingBuilding);
    }

    public void applyToCap(IColonyTagCapability cap) {
        if (this.claimingBuilding.isEmpty() && this.unClaimingBuilding.isEmpty()) {
            if (this.getColonyId() > 0) {
                cap.setOwningColony(this.colonyId);
            }
            for (int tempColonyId : this.coloniesToAdd) {
                cap.addColony(tempColonyId);
            }
            for (int tempColonyId : this.coloniesToRemove) {
                cap.removeColony(tempColonyId);
            }
        } else {
            for (Tuple<Integer, BlockPos> tuple : this.unClaimingBuilding) {
                cap.removeBuildingClaim((Integer)tuple.func_76341_a(), (BlockPos)tuple.func_76340_b());
            }
            for (Tuple<Integer, BlockPos> tuple : this.claimingBuilding) {
                cap.addBuildingClaim((Integer)tuple.func_76341_a(), (BlockPos)tuple.func_76340_b());
            }
        }
    }

    public boolean isEmpty() {
        return this.coloniesToAdd.isEmpty() && this.coloniesToRemove.isEmpty();
    }

    public void merge(ChunkLoadStorage newStorage) {
        if (this.claimingBuilding.isEmpty() && this.unClaimingBuilding.isEmpty()) {
            for (int tempColonyId : newStorage.coloniesToAdd) {
                if (this.coloniesToRemove.contains(tempColonyId)) {
                    this.coloniesToRemove.remove(new Integer(tempColonyId));
                    continue;
                }
                if (this.coloniesToAdd.contains(tempColonyId)) continue;
                this.coloniesToAdd.add(tempColonyId);
            }
            for (int tempColonyId : newStorage.coloniesToRemove) {
                if (this.colonyId == tempColonyId) {
                    this.colonyId = 0;
                }
                if (this.coloniesToAdd.contains(tempColonyId)) {
                    this.coloniesToAdd.remove(new Integer(tempColonyId));
                    continue;
                }
                if (this.coloniesToRemove.contains(tempColonyId)) continue;
                this.coloniesToRemove.add(tempColonyId);
            }
            if (newStorage.getColonyId() > 0 || !newStorage.coloniesToRemove.isEmpty()) {
                this.colonyId = newStorage.getColonyId();
            }
        } else {
            this.claimingBuilding.removeIf(newStorage.unClaimingBuilding::contains);
            this.unClaimingBuilding.removeIf(newStorage.claimingBuilding::contains);
            for (Tuple<Integer, BlockPos> tuple : newStorage.unClaimingBuilding) {
                if (this.unClaimingBuilding.contains(tuple)) continue;
                this.unClaimingBuilding.add(tuple);
            }
            for (Tuple<Integer, BlockPos> tuple : newStorage.claimingBuilding) {
                if (this.claimingBuilding.contains(tuple)) continue;
                this.claimingBuilding.add(tuple);
            }
        }
    }

    private static NBTTagCompound writeTupleToNBT(Tuple<Integer, BlockPos> tuple) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("colony", ((Integer)tuple.func_76341_a()).intValue());
        BlockPosUtil.writeToNBT(compound, "building", (BlockPos)tuple.func_76340_b());
        return compound;
    }

    private static Tuple<Integer, BlockPos> readTupleFromNbt(NBTTagCompound compound) {
        return new Tuple<Integer, BlockPos>(compound.func_74762_e("colony"), BlockPosUtil.readFromNBT(compound, "building"));
    }
}

