/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.factory.standard;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.ITypeOverrideHandler;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class TypeTokenFactory
implements IFactory<Class, TypeToken> {
    @Override
    @NotNull
    public TypeToken<? extends TypeToken> getFactoryOutputType() {
        return TypeConstants.TYPETOKEN;
    }

    @Override
    @NotNull
    public TypeToken<? extends Class> getFactoryInputType() {
        return TypeConstants.CLASS;
    }

    @Override
    @NotNull
    public TypeToken getNewInstance(@NotNull IFactoryController factoryController, @NotNull Class aClass, Object ... context) throws IllegalArgumentException {
        return TypeToken.of((Class)aClass);
    }

    @Override
    @NotNull
    public NBTTagCompound serialize(@NotNull IFactoryController controller, @NotNull TypeToken typeToken) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Value", typeToken.getRawType().getName());
        return compound;
    }

    @Override
    @NotNull
    public TypeToken deserialize(@NotNull IFactoryController controller, @NotNull NBTTagCompound nbt) throws Throwable {
        try {
            return TypeToken.of(Class.forName(nbt.func_74779_i("Value")));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create TypeToken", e);
        }
    }

    public static class TypeTokenSubTypeOverrideHandler
    implements ITypeOverrideHandler<TypeToken> {
        @Override
        public boolean matches(TypeToken<?> inputType) {
            return ReflectionUtils.getSuperClasses(inputType).contains(TypeConstants.TYPETOKEN);
        }

        @Override
        public TypeToken<TypeToken> getOutputType() {
            return TypeConstants.TYPETOKEN;
        }
    }
}

