/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.util;

import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TeleportUtil {
    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        int sourceDim = entity.field_70170_p.field_73011_w.getDimension();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportUtil.handleEntityTeleport(entity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.func_184208_bv();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            return entity;
        }
        passengerHelper.teleport(server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, int dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtil.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, (int)targetDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof EntityPlayerMP) {
                return TeleportUtil.teleportPlayerInterdimentional((EntityPlayerMP)entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportUtil.teleportEntityInterdimentional(entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
        return entity;
    }

    private static Entity teleportEntityInterdimentional(Entity entity, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity.field_70128_L) {
            return null;
        }
        WorldServer sourceWorld = server.func_71218_a(sourceDim);
        WorldServer targetWorld = server.func_71218_a(targetDim);
        if (!entity.field_70128_L && entity instanceof EntityMinecart) {
            entity.field_70128_L = true;
            entity.func_184204_a(targetDim);
            entity.field_70128_L = false;
        }
        entity.field_71093_bK = targetDim;
        sourceWorld.func_72900_e(entity);
        entity.field_70128_L = false;
        entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        sourceWorld.func_72866_a(entity, false);
        Entity newEntity = EntityList.func_191304_a(entity.getClass(), (World)targetWorld);
        if (newEntity != null) {
            newEntity.func_180432_n(entity);
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            boolean flag = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            targetWorld.func_72838_d(newEntity);
            newEntity.field_98038_p = flag;
            targetWorld.func_72866_a(newEntity, false);
        }
        entity.field_70128_L = true;
        sourceWorld.func_82742_i();
        targetWorld.func_82742_i();
        return newEntity;
    }

    private static EntityPlayer teleportPlayerInterdimentional(EntityPlayerMP player, MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        WorldServer sourceWorld = server.func_71218_a(sourceDim);
        WorldServer targetWorld = server.func_71218_a(targetDim);
        PlayerList playerList = server.func_184103_al();
        player.field_71093_bK = targetDim;
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, targetWorld.func_175659_aa(), targetWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        playerList.func_187243_f(player);
        sourceWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        targetWorld.func_72838_d((Entity)player);
        targetWorld.func_72866_a((Entity)player, false);
        player.func_70029_a((World)targetWorld);
        playerList.func_72375_a(player, sourceWorld);
        player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71134_c.func_73080_a(targetWorld);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        playerList.func_72354_b(player, targetWorld);
        playerList.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, sourceDim, targetDim);
        player.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.func_184188_bt().size() > 0) {
            entity = (Entity)entity.func_184188_bt().get(0);
        }
        return entity;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.field_70165_t - entity.func_184187_bx().field_70165_t;
                this.offsetY = entity.field_70163_u - entity.func_184187_bx().field_70163_u;
                this.offsetZ = entity.field_70161_v - entity.func_184187_bx().field_70161_v;
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, int sourceDim, int targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            this.entity = TeleportUtil.handleEntityTeleport(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        public void remountRiders() {
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.field_70165_t + this.offsetX, this.entity.field_70163_u + this.offsetY, this.entity.field_70161_v + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof EntityPlayerMP) {
                this.updateClient((EntityPlayerMP)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(EntityPlayerMP playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

