/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import net.minecraft.item.ItemStack;

public class ManaStorageUtils {
    private static final int maxCount = 1000000000;

    public static void setManaSize(ItemStack stack, int count) {
        NBTUtils.setInt(stack, "manaCount", Math.max(0, count));
    }

    public static void addManaToFolder(ItemStack stack, int count) {
        int current = ManaStorageUtils.getManaSize(stack);
        ManaStorageUtils.setManaSize(stack, current + count);
    }

    public static int takeManaFromFolder(ItemStack stack, int count) {
        int current = ManaStorageUtils.getManaSize(stack);
        int remainder = current - count;
        ManaStorageUtils.setManaSize(stack, Math.max(current - count, 0));
        return remainder > 0 ? 0 : remainder;
    }

    public static int getManaSize(ItemStack stack) {
        return NBTUtils.getInt(stack, "manaCount", 0);
    }

    public static boolean isManaFolderFull(ItemStack stack) {
        return ManaStorageUtils.getManaSize(stack) >= 1000000000;
    }

    public static int getMaxManaFolder() {
        return 1000000000;
    }
}

