/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers.enums;

import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.FluidUtils;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import com.bafomdad.realfilingcabinet.utils.MobUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;

public enum FolderType {
    NORMAL{

        public ItemStack insert(CapabilityFolder cap, Object toInsert, boolean sim, boolean oreDict) {
            if (!(toInsert instanceof ItemStack) || !cap.isItemStack()) {
                return null;
            }
            if (!ItemStack.func_179545_c((ItemStack)((ItemStack)toInsert), (ItemStack)cap.getItemStack()) && !oreDict) {
                return null;
            }
            ItemStack stack = (ItemStack)toInsert;
            if (!sim) {
                cap.setCount(cap.getCount() + (long)stack.func_190916_E());
                stack.func_190920_e(0);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extract(CapabilityFolder cap, long amount, boolean sim, boolean creative) {
            ItemStack items = cap.getItemStack().func_77946_l();
            items.func_190920_e((int)Math.min(cap.getCount(), amount));
            if (!sim && !creative) {
                cap.setCount(cap.getCount() - (long)items.func_190916_E());
            }
            return items;
        }

        @Override
        public EnumActionResult placeObject(ItemStack folder, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
            long count;
            Object obj = FolderUtils.get(folder).getObject();
            if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof ItemBlock && (count = FolderUtils.get(folder).getFileSize()) > 0L) {
                ItemStack stackToPlace = new ItemStack(((ItemStack)obj).func_77973_b(), 1, ((ItemStack)obj).func_77952_i());
                ItemStack savedFolder = player.func_184586_b(hand);
                player.func_184611_a(hand, stackToPlace);
                EnumActionResult ear = stackToPlace.func_179546_a(player, world, pos, hand, side, hitX, hitY, hitZ);
                player.func_184611_a(hand, savedFolder);
                if (ear == EnumActionResult.SUCCESS) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        FolderUtils.get(folder).remove(1L);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return EnumActionResult.PASS;
        }
    }
    ,
    ENDER{

        public ItemStack insert(CapabilityFolder cap, Object toInsert, boolean sim, boolean oreDict) {
            if (!(toInsert instanceof ItemStack) || !cap.isItemStack()) {
                return null;
            }
            if (!ItemStack.func_179545_c((ItemStack)((ItemStack)toInsert), (ItemStack)cap.getItemStack()) && !oreDict) {
                return null;
            }
            ItemStack stack = (ItemStack)toInsert;
            if (!sim) {
                cap.setCount(cap.getCount() + (long)stack.func_190916_E());
                stack.func_190920_e(0);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extract(CapabilityFolder cap, long amount, boolean sim, boolean creative) {
            ItemStack items = cap.getItemStack().func_77946_l();
            items.func_190920_e((int)Math.min(cap.getCount(), amount));
            if (!sim && !creative) {
                cap.setCount(cap.getCount() - (long)items.func_190916_E());
            }
            return items;
        }

        @Override
        public EnumActionResult placeObject(ItemStack folder, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
            Object obj = FolderUtils.get(folder).getObject();
            if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof ItemBlock) {
                long count = FolderUtils.get(folder).getFileSize();
                if (!EnderUtils.preValidateEnderFolder(folder)) {
                    return EnumActionResult.PASS;
                }
                if (count > 0L) {
                    ItemStack stackToPlace = new ItemStack(((ItemStack)obj).func_77973_b(), 1, ((ItemStack)obj).func_77952_i());
                    ItemStack savedFolder = player.func_184586_b(hand);
                    player.func_184611_a(hand, stackToPlace);
                    EnumActionResult ear = stackToPlace.func_179546_a(player, world, pos, hand, side, hitX, hitY, hitZ);
                    player.func_184611_a(hand, savedFolder);
                    if (ear == EnumActionResult.SUCCESS) {
                        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
                            FolderUtils.get(folder).setExtractSize(-1);
                            EnderUtils.syncToTile(folder);
                            if (player instanceof FakePlayer) {
                                EnderUtils.syncToFolder(folder);
                            }
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            return EnumActionResult.PASS;
        }
    }
    ,
    DURA{

        public ItemStack insert(CapabilityFolder cap, Object toInsert, boolean sim, boolean oreDict) {
            if (!(toInsert instanceof ItemStack) || !cap.isItemStack()) {
                return null;
            }
            if (!ItemStack.func_185132_d((ItemStack)((ItemStack)toInsert), (ItemStack)cap.getItemStack()) && !oreDict) {
                return null;
            }
            ItemStack stack = (ItemStack)toInsert;
            if (!sim) {
                cap.setRemainingDurability(cap.getRemainingDurability() + (stack.func_77958_k() - stack.func_77952_i()));
                int newRem = cap.getRemainingDurability();
                if (newRem >= stack.func_77958_k()) {
                    cap.setCount(cap.getCount() + 1L);
                    int newStoredRem = newRem - stack.func_77958_k();
                    cap.setRemainingDurability(newStoredRem);
                }
                stack.func_190918_g(1);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extract(CapabilityFolder cap, long amount, boolean sim, boolean creative) {
            ItemStack items = cap.getItemStack().func_77946_l();
            items.func_190920_e((int)Math.min(cap.getCount(), amount));
            if (!sim && !creative) {
                cap.setCount(cap.getCount() - (long)items.func_190916_E());
            }
            return items;
        }
    }
    ,
    MOB{

        public EntityLivingBase insert(CapabilityFolder cap, Object toInsert, boolean sim, boolean oreDict) {
            if (!(toInsert instanceof EntityLivingBase)) {
                return null;
            }
            EntityLivingBase target = (EntityLivingBase)toInsert;
            if (MobUtils.acceptableTargets(target) && cap.getContents().equals(target.getClass()) && !sim) {
                cap.setCount(cap.getCount() + 1L);
                MobUtils.dropMobEquips(target.field_70170_p, target);
                target.func_70106_y();
            }
            return target;
        }

        public EntityLivingBase extract(CapabilityFolder cap, long amount, boolean sim, boolean creative) {
            return null;
        }

        @Override
        public EnumActionResult placeObject(ItemStack folder, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
            if (MobUtils.spawnEntityFromFolder(world, player, folder, pos, side)) {
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
    }
    ,
    FLUID{

        public FluidStack insert(CapabilityFolder cap, Object toInsert, boolean sim, boolean oreDict) {
            if (!(toInsert instanceof FluidStack) || !cap.isFluidStack()) {
                return null;
            }
            FluidStack fluid = (FluidStack)toInsert;
            if (!fluid.isFluidEqual(cap.getFluidStack())) {
                return null;
            }
            if (sim) {
                cap.setCount(cap.getCount() + (long)fluid.amount);
            }
            return fluid;
        }

        public FluidStack extract(CapabilityFolder cap, long amount, boolean sim, boolean creative) {
            if (!cap.isFluidStack()) {
                return null;
            }
            return cap.getFluidStack();
        }

        @Override
        public EnumActionResult placeObject(ItemStack folder, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
            if (FluidUtils.doPlace(world, player, folder, pos, side)) {
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
    }
    ,
    NBT{

        public ItemStack insert(CapabilityFolder cap, Object toInsert, boolean sim, boolean oreDict) {
            if (!(toInsert instanceof ItemStack) || !cap.isItemStack()) {
                return null;
            }
            if (!ItemStack.func_77970_a((ItemStack)((ItemStack)toInsert), (ItemStack)cap.getItemStack()) && !oreDict) {
                return null;
            }
            ItemStack stack = (ItemStack)toInsert;
            if (!sim) {
                cap.setCount(cap.getCount() + (long)stack.func_190916_E());
                stack.func_190920_e(0);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extract(CapabilityFolder cap, long amount, boolean sim, boolean creative) {
            ItemStack items = cap.getItemStack().func_77946_l();
            items.func_190920_e((int)Math.min(cap.getCount(), amount));
            if (!sim && !creative) {
                cap.setCount(cap.getCount() - (long)items.func_190916_E());
            }
            return items;
        }
    };


    public abstract <T> T insert(CapabilityFolder var1, Object var2, boolean var3, boolean var4);

    public abstract <T> T extract(CapabilityFolder var1, long var2, boolean var4, boolean var5);

    public EnumActionResult placeObject(ItemStack folder, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }
}

