/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks.tiles;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.utils.ManaStorageUtils;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;

public class TileManaCabinet
extends TileEntityRFC
implements IManaReceiver,
ISparkAttachable {
    private static final long MAX_MANA_INTERNAL = ManaStorageUtils.getMaxManaFolder() * 8;

    public long getTotalInternalManaPool() {
        long total = 0L;
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            ItemStack stack = this.getInventory().getFolder(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem)) continue;
            total += (long)ManaStorageUtils.getManaSize(stack);
        }
        return total;
    }

    public int getManaFromFolder() {
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            int manaSize;
            ItemStack stack = this.getInventory().getFolder(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem) || (manaSize = ManaStorageUtils.getManaSize(stack)) < 0) continue;
            return manaSize;
        }
        return -1;
    }

    public void addManaToFolder(int mana) {
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            ItemStack stack = this.getInventory().getFolder(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IManaItem) || mana > 0 && ManaStorageUtils.isManaFolderFull(stack) || mana < 0 && ManaStorageUtils.getManaSize(stack) <= 0) continue;
            ManaStorageUtils.addManaToFolder(stack, mana);
            break;
        }
    }

    public boolean canRecieveManaFromBursts() {
        return this.getManaFromFolder() != -1;
    }

    public boolean isFull() {
        return this.getTotalInternalManaPool() == MAX_MANA_INTERNAL || this.getManaFromFolder() == -1;
    }

    public void recieveMana(int mana) {
        int manaToAdd = Math.min(ManaStorageUtils.getMaxManaFolder(), mana);
        this.addManaToFolder(manaToAdd);
    }

    public int getCurrentMana() {
        return this.getManaFromFolder();
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public void attachSpark(ISparkEntity arg0) {
    }

    public boolean canAttachSpark(ItemStack arg0) {
        return true;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        if (this.getTotalInternalManaPool() == MAX_MANA_INTERNAL) {
            return 0;
        }
        return 1000;
    }
}

