/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.storage.ILocalStorageHandler;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.storage.BetweenlandsChunkStorage;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.ChunkStorageImpl;
import thebetweenlands.common.world.storage.LocalStorageHandlerImpl;

public abstract class WorldStorageImpl
implements IWorldStorage {
    @CapabilityInject(value=IWorldStorage.class)
    public static final Capability<IWorldStorage> CAPABILITY_INSTANCE = null;
    private Map<ChunkPos, ChunkStorageImpl> storageMap = new HashMap<ChunkPos, ChunkStorageImpl>();
    private List<ITickable> tickableStorages = new ArrayList<ITickable>();
    private World world;
    private ILocalStorageHandler localStorageHandler;

    @Nullable
    public static IWorldStorage getCapability(World world) {
        return (IWorldStorage)world.getCapability(CAPABILITY_INSTANCE, null);
    }

    protected void init() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IWorldStorage.class, (Capability.IStorage)new Capability.IStorage<IWorldStorage>(){

            public NBTBase writeNBT(Capability<IWorldStorage> capability, IWorldStorage instance, EnumFacing side) {
                NBTTagCompound nbt = new NBTTagCompound();
                instance.writeToNBT(nbt);
                return nbt;
            }

            public void readNBT(Capability<IWorldStorage> capability, IWorldStorage instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagCompound) {
                    instance.readFromNBT((NBTTagCompound)nbt);
                }
            }
        }, (Callable)new Callable<IWorldStorage>(){

            @Override
            public IWorldStorage call() throws Exception {
                return new BetweenlandsWorldStorage();
            }
        });
        MinecraftForge.EVENT_BUS.register(Handler.class);
    }

    private void setWorld(World world) {
        this.world = world;
        this.localStorageHandler = new LocalStorageHandlerImpl(this);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void loadChunk(Chunk chunk) {
        if (!this.storageMap.containsKey(chunk.func_76632_l())) {
            try {
                BetweenlandsChunkStorage storage = new BetweenlandsChunkStorage(this, chunk);
                storage.init();
                ((ChunkStorageImpl)storage).setDefaults();
                this.storageMap.put(chunk.func_76632_l(), storage);
                if (storage instanceof ITickable) {
                    this.tickableStorages.add(storage);
                }
                chunk.func_177427_f(true);
            }
            catch (Exception ex) {
                TheBetweenlands.logger.error(String.format("Failed creating chunk storage at %s", "[x=" + chunk.field_76635_g + ", z=" + chunk.field_76647_h + "]"), (Throwable)ex);
            }
        }
    }

    @Override
    public void readAndLoadChunk(Chunk chunk, NBTTagCompound nbt) {
        if (this.storageMap.containsKey(chunk.func_76632_l())) {
            if (BetweenlandsConfig.DEBUG.debug) {
                TheBetweenlands.logger.warn(String.format("Reading chunk storage at %s, but chunk storage is already loaded!", "[x=" + chunk.field_76635_g + ", z=" + chunk.field_76647_h + "]"));
            }
        } else {
            try {
                BetweenlandsChunkStorage storage = new BetweenlandsChunkStorage(this, chunk);
                storage.init();
                ((ChunkStorageImpl)storage).readFromNBT(nbt, false);
                this.storageMap.put(chunk.func_76632_l(), storage);
                if (storage instanceof ITickable) {
                    this.tickableStorages.add(storage);
                }
            }
            catch (Exception ex) {
                TheBetweenlands.logger.error(String.format("Failed reading chunk storage at %s", "[x=" + chunk.field_76635_g + ", z=" + chunk.field_76647_h + "]"), (Throwable)ex);
            }
        }
    }

    @Override
    public void unloadChunk(Chunk chunk) {
        if (!this.storageMap.containsKey(chunk.func_76632_l())) {
            if (BetweenlandsConfig.DEBUG.debug) {
                TheBetweenlands.logger.warn(String.format("Unloading chunk storage at %s, but chunk storage is not loaded!", "[x=" + chunk.field_76635_g + ", z=" + chunk.field_76647_h + "]"));
            }
        } else {
            ChunkStorageImpl storage = this.storageMap.remove(chunk.func_76632_l());
            if (storage instanceof ITickable) {
                this.tickableStorages.remove(storage);
            }
            storage.onUnload();
        }
    }

    @Override
    public NBTTagCompound saveChunk(Chunk chunk) {
        if (!this.storageMap.containsKey(chunk.func_76632_l())) {
            if (BetweenlandsConfig.DEBUG.debug) {
                TheBetweenlands.logger.warn(String.format("Saving chunk storage at %s, but chunk storage is not loaded!", "[x=" + chunk.field_76635_g + ", z=" + chunk.field_76647_h + "]"));
            }
        } else {
            try {
                ChunkStorageImpl storage = this.storageMap.get(chunk.func_76632_l());
                NBTTagCompound nbt = storage.writeToNBT(new NBTTagCompound(), false);
                storage.setDirty(false);
                return nbt;
            }
            catch (Exception ex) {
                TheBetweenlands.logger.error(String.format("Failed saving chunk storage at %s", "[x=" + chunk.field_76635_g + ", z=" + chunk.field_76647_h + "]"), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void watchChunk(ChunkPos pos, EntityPlayerMP player) {
        ChunkStorageImpl storage = this.storageMap.get(pos);
        if (storage != null) {
            storage.addWatcher(player);
        }
    }

    @Override
    public void unwatchChunk(ChunkPos pos, EntityPlayerMP player) {
        ChunkStorageImpl storage = this.storageMap.get(pos);
        if (storage != null) {
            storage.removeWatcher(player);
        }
    }

    @Override
    public ChunkStorageImpl getChunkStorage(Chunk chunk) {
        return this.storageMap.get(chunk.func_76632_l());
    }

    @Override
    public ILocalStorageHandler getLocalStorageHandler() {
        return this.localStorageHandler;
    }

    @Override
    public void tick() {
        this.localStorageHandler.update();
        for (int i = 0; i < this.tickableStorages.size(); ++i) {
            ITickable tickable = this.tickableStorages.get(i);
            tickable.func_73660_a();
        }
    }

    public static class Handler {
        private Handler() {
        }

        @SubscribeEvent
        public static void onWorldCapability(final AttachCapabilitiesEvent<World> event) {
            event.addCapability(new ResourceLocation("thebetweenlands", "world_data"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                private IWorldStorage instance = this.getNewInstance();

                private IWorldStorage getNewInstance() {
                    BetweenlandsWorldStorage instance = new BetweenlandsWorldStorage();
                    ((WorldStorageImpl)instance).setWorld((World)event.getObject());
                    ((WorldStorageImpl)instance).init();
                    return instance;
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == CAPABILITY_INSTANCE;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == CAPABILITY_INSTANCE ? this.instance : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)CAPABILITY_INSTANCE.getStorage().writeNBT(CAPABILITY_INSTANCE, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    CAPABILITY_INSTANCE.getStorage().readNBT(CAPABILITY_INSTANCE, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }
}

