/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.layer;

import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.world.gen.layer.GenLayerBetweenlandsBiome;
import thebetweenlands.common.world.gen.layer.GenLayerCircleMask;
import thebetweenlands.common.world.gen.layer.GenLayerMask;
import thebetweenlands.common.world.gen.layer.GenLayerMixMask;
import thebetweenlands.common.world.gen.layer.GenLayerResetCache;
import thebetweenlands.common.world.gen.layer.GenLayerSurrounded;
import thebetweenlands.common.world.gen.layer.GenLayerThinMask;
import thebetweenlands.common.world.gen.layer.GenLayerVoronoiZoomInstanced;
import thebetweenlands.common.world.gen.layer.GenLayerZoomIncrement;
import thebetweenlands.common.world.gen.layer.InstancedIntCache;

public abstract class GenLayerBetweenlands
extends GenLayer {
    protected final InstancedIntCache cache;

    public GenLayerBetweenlands(InstancedIntCache cache, long seed) {
        super(seed);
        this.cache = cache;
    }

    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldType) {
        int biomeSize = GenLayerBetweenlands.getModdedBiomeSize((WorldType)worldType, (int)(worldType == WorldType.field_77135_d ? 6 : 4));
        InstancedIntCache cache = new InstancedIntCache();
        GenLayerBetweenlands genLayer = new GenLayerBetweenlandsBiome(cache, 100L);
        genLayer = GenLayerZoomIncrement.magnify(cache, 2000L, genLayer, false, 2);
        GenLayerBetweenlands swamplandsClearingLayer = new GenLayerSurrounded(cache, 102L, genLayer, BiomeRegistry.SWAMPLANDS, BiomeRegistry.SWAMPLANDS_CLEARING, 1, 1.0f);
        swamplandsClearingLayer = new GenLayerMask(cache, swamplandsClearingLayer, Biome.func_185362_a((Biome)BiomeRegistry.SWAMPLANDS_CLEARING), Biome.func_185362_a((Biome)BiomeRegistry.SWAMPLANDS_CLEARING));
        swamplandsClearingLayer = GenLayerThinMask.thin(cache, 105L, swamplandsClearingLayer, Biome.func_185362_a((Biome)BiomeRegistry.SWAMPLANDS_CLEARING), 3, 0.25f, 10);
        genLayer = GenLayerZoomIncrement.magnify(cache, 2345L, genLayer, false, biomeSize);
        swamplandsClearingLayer = GenLayerZoomIncrement.magnify(cache, 2345L, swamplandsClearingLayer, true, biomeSize);
        swamplandsClearingLayer = new GenLayerCircleMask(cache, 103L, swamplandsClearingLayer, Biome.func_185362_a((Biome)BiomeRegistry.SWAMPLANDS_CLEARING), 10);
        genLayer = new GenLayerMixMask(cache, genLayer, swamplandsClearingLayer);
        GenLayerResetCache indexLayer = new GenLayerResetCache(cache, new GenLayerVoronoiZoomInstanced(cache, 10L, genLayer));
        genLayer = new GenLayerResetCache(cache, genLayer);
        indexLayer.func_75905_a(seed);
        genLayer.func_75905_a(seed);
        return new GenLayer[]{genLayer, indexLayer, genLayer};
    }
}

