/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.terrain.BlockLeavesBetweenlands;
import thebetweenlands.common.block.terrain.BlockRubberLog;
import thebetweenlands.common.registries.BlockRegistry;

public class WorldGenRubberTree
extends WorldGenerator {
    private IBlockState log;
    private IBlockState leaves;
    private BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 1) {
                ++y;
            }
            if (dir == 1) {
                world.func_180501_a(new BlockPos(x + i, y, z), this.log, 2);
                world.func_180501_a(new BlockPos(x + i + 1, y, z), this.log, 2);
            }
            if (dir == 2) {
                world.func_180501_a(new BlockPos(x - i, y, z), this.log, 2);
                world.func_180501_a(new BlockPos(x - i - 1, y, z), this.log, 2);
            }
            if (dir == 3) {
                world.func_180501_a(new BlockPos(x, y, z + i), this.log, 2);
                world.func_180501_a(new BlockPos(x, y, z + i + 1), this.log, 2);
            }
            if (dir != 4) continue;
            world.func_180501_a(new BlockPos(x, y, z - i), this.log, 2);
            world.func_180501_a(new BlockPos(x, y, z - i - 1), this.log, 2);
        }
    }

    private void createMainCanopy(World world, Random rand, int x, int y, int z, int maxRadius) {
        for (int x1 = x - maxRadius; x1 <= x + maxRadius; ++x1) {
            for (int z1 = z - maxRadius; z1 <= z + maxRadius; ++z1) {
                for (int y1 = y; y1 < y + maxRadius; ++y1) {
                    double dSq = Math.pow(x1 - x, 2.0) + Math.pow(z1 - z, 2.0) + Math.pow(y1 - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) > (long)maxRadius || world.func_180495_p((BlockPos)this.checkPos.func_181079_c(x1, y1, z1)).func_177230_c() == this.log.func_177230_c() || rand.nextInt(5) == 0) continue;
                    world.func_180501_a(new BlockPos(x1, y1, z1), this.leaves, 2);
                }
            }
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        int x = position.func_177958_n();
        int y = position.func_177956_o();
        int z = position.func_177952_p();
        int height = rand.nextInt(8) + 8;
        int maxRadius = 4;
        this.log = BlockRegistry.LOG_RUBBER.func_176223_P().func_177226_a((IProperty)BlockRubberLog.NATURAL, (Comparable)Boolean.valueOf(true));
        this.leaves = BlockRegistry.LEAVES_RUBBER_TREE.func_176223_P().func_177226_a((IProperty)BlockLeavesBetweenlands.field_176236_b, (Comparable)Boolean.valueOf(false));
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_175623_d((BlockPos)this.checkPos.func_181079_c(xx, yy, zz)) || world.func_180495_p((BlockPos)this.checkPos.func_181079_c(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)this.checkPos.func_181079_c(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            world.func_180501_a(new BlockPos(x, yy, z), this.log, 2);
            if (yy == y + height - 1) {
                this.createMainCanopy(world, rand, x, yy, z, maxRadius);
            }
            if (yy != y + height - 2) continue;
            this.createBranch(world, rand, x + 1, yy, z, 1, 1);
            this.createBranch(world, rand, x - 1, yy, z, 2, 1);
            this.createBranch(world, rand, x, yy, z + 1, 3, 1);
            this.createBranch(world, rand, x, yy, z - 1, 4, 1);
        }
        return true;
    }
}

