/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.container.BlockChestBetweenlands;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.block.plant.BlockDoublePlantBL;
import thebetweenlands.common.block.plant.BlockPlant;
import thebetweenlands.common.block.structure.BlockMobSpawnerBetweenlands;
import thebetweenlands.common.block.structure.BlockPossessedBlock;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.block.structure.BlockStairsBetweenlands;
import thebetweenlands.common.block.structure.BlockWallWeedwoodSign;
import thebetweenlands.common.entity.EntitySwordEnergy;
import thebetweenlands.common.entity.mobs.EntityFortressBossTeleporter;
import thebetweenlands.common.entity.mobs.EntityPyrad;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityChestBetweenlands;
import thebetweenlands.common.tile.TileEntityItemCage;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.common.tile.TileEntityWeedwoodSign;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationAmbience;
import thebetweenlands.common.world.storage.location.LocationGuarded;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.common.world.storage.location.guard.ILocationGuard;

public class WorldGenWightFortress
extends WorldGenerator {
    private int length = 13;
    private int width = 13;
    private int height = 19;
    private int direction = -1;
    private IBlockState limestonePolished = BlockRegistry.POLISHED_LIMESTONE.func_176223_P();
    private IBlockState limestoneChiselled = BlockRegistry.LIMESTONE_CHISELED.func_176223_P();
    private IBlockState limestoneBrickSlab = BlockRegistry.LIMESTONE_BRICK_SLAB.func_176223_P();
    private IBlockState limestonePolishedCollapsing = BlockRegistry.WEAK_POLISHED_LIMESTONE.func_176223_P();
    private IBlockState betweenstone = BlockRegistry.BETWEENSTONE.func_176223_P();
    private IBlockState betweenstoneSmooth = BlockRegistry.SMOOTH_BETWEENSTONE.func_176223_P();
    private IBlockState betweenstoneSmoothMossy = BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE.func_176223_P();
    private IBlockState betweenstoneTiles = BlockRegistry.BETWEENSTONE_TILES.func_176223_P();
    private IBlockState betweenstoneTilesMossy = BlockRegistry.MOSSY_BETWEENSTONE_TILES.func_176223_P();
    private IBlockState betweenstoneTilesCracked = BlockRegistry.CRACKED_BETWEENSTONE_TILES.func_176223_P();
    private IBlockState betweenstoneTilesCollapsing = BlockRegistry.WEAK_BETWEENSTONE_TILES.func_176223_P();
    private IBlockState betweenstoneTilesMossyCollapsing = BlockRegistry.WEAK_MOSSY_BETWEENSTONE_TILES.func_176223_P();
    private IBlockState betweenstoneBrickStairs = BlockRegistry.BETWEENSTONE_BRICK_STAIRS.func_176223_P();
    private IBlockState betweenstoneBrickStairsMossy = BlockRegistry.MOSSY_BETWEENSTONE_BRICK_STAIRS.func_176223_P();
    private IBlockState betweenstoneBrickStairsCracked = BlockRegistry.CRACKED_BETWEENSTONE_BRICK_STAIRS.func_176223_P();
    private IBlockState betweenstoneBrickSlab = BlockRegistry.BETWEENSTONE_BRICK_SLAB.func_176223_P();
    private IBlockState betweenstoneBrickWall = BlockRegistry.BETWEENSTONE_BRICK_WALL.func_176223_P();
    private IBlockState betweenstoneBrickWallMossy = BlockRegistry.MOSSY_BETWEENSTONE_BRICK_WALL.func_176223_P();
    private IBlockState betweenstoneBrickWallCracked = BlockRegistry.CRACKED_BETWEENSTONE_BRICK_WALL.func_176223_P();
    private IBlockState betweenstoneBricks = BlockRegistry.BETWEENSTONE_BRICKS.func_176223_P();
    private IBlockState betweenstoneBricksMirage = BlockRegistry.BETWEENSTONE_BRICKS_MIRAGE.func_176223_P();
    private IBlockState betweenstoneBricksMossy = BlockRegistry.MOSSY_BETWEENSTONE_BRICKS.func_176223_P();
    private IBlockState betweenstoneBricksCracked = BlockRegistry.CRACKED_BETWEENSTONE_BRICKS.func_176223_P();
    private IBlockState betweenstonePillar = BlockRegistry.BETWEENSTONE_PILLAR.func_176223_P();
    private IBlockState betweenstoneStairsSmooth = BlockRegistry.SMOOTH_BETWEENSTONE_STAIRS.func_176223_P();
    private IBlockState betweenstoneStairsSmoothMossy = BlockRegistry.MOSSY_SMOOTH_BETWEENSTONE_STAIRS.func_176223_P();
    private IBlockState betweenstoneTilesFortress = BlockRegistry.GLOWING_BETWEENSTONE_TILE.func_176223_P();
    private IBlockState stagnantWater = BlockRegistry.STAGNANT_WATER.func_176223_P();
    private IBlockState spikeTrap = BlockRegistry.SPIKE_TRAP.func_176223_P();
    private IBlockState swordStone = BlockRegistry.ITEM_CAGE.func_176223_P();
    private IBlockState root = BlockRegistry.ROOT.func_176223_P();
    private IBlockState possessedBlock = BlockRegistry.POSSESSED_BLOCK.func_176223_P();
    private IBlockState chest = BlockRegistry.WEEDWOOD_CHEST.func_176223_P();
    private IBlockState lootPot1 = BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1));
    private IBlockState lootPot2 = BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_2));
    private IBlockState lootPot3 = BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_3));
    private IBlockState spawner = BlockRegistry.MOB_SPAWNER.func_176223_P();
    private IBlockState obviousSign = BlockRegistry.WALL_WEEDWOOD_SIGN.func_176223_P();
    private IBlockState valoniteBlock = BlockRegistry.VALONITE_BLOCK.func_176223_P();
    private IBlockState syrmoriteBlock = BlockRegistry.SYRMORITE_BLOCK.func_176223_P();
    private IBlockState octineBlock = BlockRegistry.OCTINE_BLOCK.func_176223_P();
    private IBlockState mushroomBlackHat = BlockRegistry.BLACK_HAT_MUSHROOM.func_176223_P();
    private IBlockState mushroomBulbCapped = BlockRegistry.BULB_CAPPED_MUSHROOM.func_176223_P();
    private IBlockState mushroomflatHead = BlockRegistry.FLAT_HEAD_MUSHROOM.func_176223_P();
    private IBlockState energyBarrier = BlockRegistry.ENERGY_BARRIER.func_176223_P();
    private ILocationGuard guard;

    protected boolean isProtectedBlock(IBlockState state) {
        Block block = state.func_177230_c();
        return block != Blocks.field_150350_a && block != BlockRegistry.MOB_SPAWNER && block != BlockRegistry.LOOT_POT && block != BlockRegistry.ROOT && !(block instanceof BlockPlant) && block != BlockRegistry.VALONITE_BLOCK && block != BlockRegistry.SYRMORITE_BLOCK && block != BlockRegistry.OCTINE_BLOCK && block != BlockRegistry.WEEDWOOD_CHEST && block != BlockRegistry.ITEM_CAGE && block != BlockRegistry.POSSESSED_BLOCK && block != BlockRegistry.WEAK_POLISHED_LIMESTONE && block != BlockRegistry.WEAK_BETWEENSTONE_TILES && block != BlockRegistry.WEAK_MOSSY_BETWEENSTONE_TILES;
    }

    protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isProtectedBlock(state)) {
            this.guard.setGuarded(worldIn, pos, true);
        } else {
            this.guard.setGuarded(worldIn, pos, false);
        }
        super.func_175903_a(worldIn, pos, state);
    }

    protected boolean canGenerateAt(World world, Random rand, BlockPos pos) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        if (!this.isBiomeValid(world.func_180494_b(pos))) {
            return false;
        }
        if (!this.isBiomeValid(world.func_180494_b(pos.func_177982_a(32, 0, 0)))) {
            return false;
        }
        if (!this.isBiomeValid(world.func_180494_b(pos.func_177982_a(32, 0, 32)))) {
            return false;
        }
        if (!this.isBiomeValid(world.func_180494_b(pos.func_177982_a(0, 0, 32)))) {
            return false;
        }
        for (int xa = 0; xa <= 31; ++xa) {
            for (int za = 0; za <= 31; ++za) {
                for (int ya = 0; ya < 42; ++ya) {
                    boolean replaceable;
                    checkPos.func_181079_c(pos.func_177958_n() + xa, pos.func_177956_o() + ya, pos.func_177952_p() + za);
                    IBlockState state = world.func_180495_p((BlockPos)checkPos);
                    boolean bl = replaceable = state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos) || state.func_177230_c() instanceof BlockPlant || state.func_177230_c() instanceof BlockDoublePlantBL;
                    if (replaceable) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isBiomeValid(Biome biome) {
        return biome == BiomeRegistry.MARSH_0 || biome == BiomeRegistry.MARSH_1;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.canGenerateAt(world, rand, pos)) {
            return false;
        }
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        long locationSeed = rand.nextLong();
        LocalRegion region = LocalRegion.getFromBlockPos(pos);
        LocationGuarded fortressLocation = new LocationGuarded(worldStorage, new StorageUUID(UUID.randomUUID()), region, "wight_tower", EnumLocationType.WIGHT_TOWER);
        this.guard = fortressLocation.getGuard();
        fortressLocation.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 10), (double)(pos.func_177956_o() - 10), (double)(pos.func_177952_p() - 10), (double)(pos.func_177958_n() + 42), (double)(pos.func_177956_o() + 80), (double)(pos.func_177952_p() + 42)));
        fortressLocation.linkChunks();
        fortressLocation.setAmbience(new LocationAmbience(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER).setFogRangeMultiplier(0.2f).setFogBrightness(80));
        fortressLocation.setLayer(0);
        fortressLocation.setDirty(true);
        fortressLocation.setSeed(locationSeed);
        LocationStorage puzzleLocation = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), region, "wight_tower_puzzle", EnumLocationType.WIGHT_TOWER);
        puzzleLocation.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 10 + 20), (double)(pos.func_177956_o() + 17), (double)(pos.func_177952_p() - 10 + 20), (double)(pos.func_177958_n() + 42 - 20), (double)(pos.func_177956_o() + 17 + 6), (double)(pos.func_177952_p() + 42 - 20)));
        puzzleLocation.linkChunks();
        puzzleLocation.setLayer(1);
        puzzleLocation.setHasSharedLootPools(false);
        puzzleLocation.setDirty(true);
        puzzleLocation.setSeed(locationSeed);
        LocationStorage teleporterLocation = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), region, "wight_tower_teleporter", EnumLocationType.WIGHT_TOWER);
        teleporterLocation.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 10 + 23), (double)(pos.func_177956_o() + 17 + 12), (double)(pos.func_177952_p() - 10 + 23), (double)(pos.func_177958_n() + 42 - 23), (double)(pos.func_177956_o() + 17 + 6 + 11), (double)(pos.func_177952_p() + 42 - 23)));
        teleporterLocation.linkChunks();
        teleporterLocation.setLayer(2);
        teleporterLocation.setHasSharedLootPools(false);
        teleporterLocation.setDirty(true);
        teleporterLocation.setSeed(locationSeed);
        LocationStorage bossLocation = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), region, "wight_tower_boss", EnumLocationType.WIGHT_TOWER);
        bossLocation.addBounds(new AxisAlignedBB((double)(pos.func_177958_n() - 10 + 17), (double)(pos.func_177956_o() + 17 + 19), (double)(pos.func_177952_p() - 10 + 17), (double)(pos.func_177958_n() + 42 - 17), (double)(pos.func_177956_o() + 17 + 12 + 32), (double)(pos.func_177952_p() + 42 - 17)));
        bossLocation.linkChunks();
        bossLocation.setAmbience(new LocationAmbience(LocationAmbience.EnumLocationAmbience.WIGHT_TOWER).setFogRange(12.0f, 20.0f).setFogColorMultiplier(0.1f));
        bossLocation.setLayer(3);
        bossLocation.setHasSharedLootPools(false);
        bossLocation.setDirty(true);
        bossLocation.setSeed(locationSeed);
        if (this.generateStructure(world, rand, pos)) {
            worldStorage.getLocalStorageHandler().addLocalStorage(fortressLocation);
            worldStorage.getLocalStorageHandler().addLocalStorage(puzzleLocation);
            worldStorage.getLocalStorageHandler().addLocalStorage(teleporterLocation);
            worldStorage.getLocalStorageHandler().addLocalStorage(bossLocation);
            return true;
        }
        return false;
    }

    public IBlockState getRandomWall(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.betweenstoneBrickWall;
            }
            case 1: {
                return this.betweenstoneBrickWallMossy;
            }
            case 2: {
                return this.betweenstoneBrickWallCracked;
            }
        }
        return this.betweenstoneBrickWall;
    }

    public IBlockState getRandomBricks(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.betweenstoneBricks;
            }
            case 1: {
                return this.betweenstoneBricksMossy;
            }
            case 2: {
                return this.betweenstoneBricksCracked;
            }
        }
        return this.betweenstoneBricks;
    }

    public IBlockState getRandomTiles(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.betweenstoneTiles;
            }
            case 1: {
                return this.betweenstoneTilesMossy;
            }
            case 2: {
                return this.betweenstoneTilesCracked;
            }
        }
        return this.betweenstoneTiles;
    }

    public IBlockState getRandomMetalBlock(Random rand) {
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                return this.syrmoriteBlock;
            }
            case 1: {
                return this.octineBlock;
            }
            case 2: {
                return this.valoniteBlock;
            }
        }
        return this.syrmoriteBlock;
    }

    public IBlockState getRandomMushroom(Random rand) {
        int rnd = rand.nextInt(30);
        if (rnd < 14) {
            return this.mushroomflatHead;
        }
        if (rnd < 28) {
            return this.mushroomBlackHat;
        }
        return this.mushroomBulbCapped;
    }

    public IBlockState getRandomCollapsingTiles(Random rand) {
        return rand.nextBoolean() ? this.betweenstoneTilesCollapsing : this.betweenstoneTilesMossyCollapsing;
    }

    public IBlockState getRandomSmoothBetweenstone(Random rand) {
        return rand.nextBoolean() ? this.betweenstoneSmooth : this.betweenstoneSmoothMossy;
    }

    public IBlockState getRandomSmoothBetweenstoneStairs(Random rand, IBlockState state, int blockMeta) {
        int type = rand.nextInt(4);
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                state = this.betweenstoneStairsSmoothMossy;
            }
        }
        return this.getStairRotations(state, blockMeta);
    }

    public IBlockState getRandomBetweenstoneBrickStairs(Random rand, IBlockState state, int blockMeta) {
        int type = rand.nextInt(8);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                state = this.betweenstoneBrickStairsMossy;
                break;
            }
            case 7: {
                state = this.betweenstoneBrickStairsCracked;
            }
        }
        return this.getStairRotations(state, blockMeta);
    }

    public IBlockState getStairRotations(IBlockState state, int blockMeta) {
        int direction = blockMeta;
        switch (direction) {
            case 0: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST);
            }
            case 1: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST);
            }
            case 2: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH);
            }
            case 4: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 6: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 7: {
                return state.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
        }
        return state;
    }

    public IBlockState getWeedWoodChestRotations(IBlockState state, int blockMeta) {
        int direction = blockMeta;
        switch (direction) {
            case 0: 
            case 1: 
            case 2: {
                return state.func_177226_a((IProperty)BlockChestBetweenlands.field_176459_a, (Comparable)EnumFacing.NORTH);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockChestBetweenlands.field_176459_a, (Comparable)EnumFacing.SOUTH);
            }
            case 4: {
                return state.func_177226_a((IProperty)BlockChestBetweenlands.field_176459_a, (Comparable)EnumFacing.WEST);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockChestBetweenlands.field_176459_a, (Comparable)EnumFacing.EAST);
            }
        }
        return state;
    }

    private IBlockState getLootPotRotations(IBlockState state, int blockMeta) {
        int direction = blockMeta;
        switch (direction) {
            case 0: 
            case 1: 
            case 2: {
                return state.func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.NORTH);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 4: {
                return state.func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.WEST);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.EAST);
            }
        }
        return state;
    }

    public IBlockState getPossessedBlockRotations(IBlockState state, int blockMeta) {
        int direction = blockMeta;
        switch (direction) {
            case 0: 
            case 1: 
            case 2: {
                return state.func_177226_a((IProperty)BlockPossessedBlock.FACING, (Comparable)EnumFacing.NORTH);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockPossessedBlock.FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 4: {
                return state.func_177226_a((IProperty)BlockPossessedBlock.FACING, (Comparable)EnumFacing.WEST);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockPossessedBlock.FACING, (Comparable)EnumFacing.EAST);
            }
        }
        return state;
    }

    private IBlockState getSlabType(IBlockState slabType, int blockMeta) {
        return blockMeta == 0 ? slabType.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.BOTTOM)) : slabType.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP));
    }

    public boolean generateStructure(World world, Random rand, BlockPos pos) {
        int count;
        int z;
        int tower;
        int ya;
        int za;
        int xa;
        for (xa = 0; xa <= 32; ++xa) {
            for (za = 0; za <= 32; ++za) {
                for (ya = -12; ya < 0; ++ya) {
                    if (world.func_180495_p(pos.func_177982_a(xa, ya, za)).func_185915_l()) continue;
                    this.func_175903_a(world, pos.func_177982_a(xa, ya, za), this.betweenstone);
                }
            }
        }
        for (xa = 8; xa <= 24; ++xa) {
            for (za = 8; za <= 24; ++za) {
                for (ya = -8; ya < 0; ++ya) {
                    world.func_175698_g(pos.func_177982_a(xa, ya, za));
                }
            }
        }
        this.length = 32;
        this.width = 32;
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, pos, 8, -7, 8, this.betweenstoneBricks, 0, 8, 6, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 8, -7, 9, this.betweenstoneBricks, 0, 1, 6, 7, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 8, -8, 8, this.betweenstoneSmooth, 0, 8, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 8, -8, 9, this.betweenstoneSmooth, 0, 2, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, -8, 10, this.betweenstoneTilesFortress, 0, 1, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, pos, 10, -6, 10, this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(10, -6, 10), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : (rand.nextBoolean() ? "thebetweenlands:chiromaw" : "thebetweenlands:termite"), new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(21, -6, 21), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : (rand.nextBoolean() ? "thebetweenlands:chiromaw" : "thebetweenlands:termite"), new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(10, -6, 21), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : (rand.nextBoolean() ? "thebetweenlands:chiromaw" : "thebetweenlands:termite"), new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(21, -6, 10), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : (rand.nextBoolean() ? "thebetweenlands:chiromaw" : "thebetweenlands:termite"), new Consumer[0]);
            this.rotatedCubeVolume(world, rand, pos, 11, -8, 10, this.betweenstoneTiles, 0, 5, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, -8, 11, this.betweenstoneTiles, 0, 1, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, -8, 11, this.betweenstoneSmooth, 0, 5, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, -7, 12, this.betweenstoneStairsSmooth, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, -7, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -7, 13, this.stagnantWater, 0, 3, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -7, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -6, 9, this.betweenstonePillar, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -4, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -3, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -3, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, -3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, -3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -7, 13, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -6, 13, this.betweenstonePillar, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -4, 13, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -3, 13, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, -3, 13, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -3, 14, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -3, 12, this.betweenstoneBrickStairs, this.direction == 0 ? 6 : (this.direction == 1 ? 4 : (this.direction == 2 ? 7 : 5)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -2, 9, this.betweenstoneBricks, 0, 7, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -2, 10, this.betweenstoneBricks, 0, 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, -2, 10, this.limestoneBrickSlab, 8, 3, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, -2, 10, this.limestoneBrickSlab, 8, 2, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, -2, 14, this.limestoneBrickSlab, 8, 3, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -2, 10, this.betweenstoneBricks, 0, 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, -2, 13, this.betweenstoneBricks, 0, 6, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -7, 9, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -6, 9, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -5, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, -7, 9, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, -6, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -7, 11, this.getRandomMetalBlock(rand), 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, -6, 11, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 0, -1, 0, this.betweenstoneSmooth, 0, 13, 1, 13, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, -1, 4, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 4, -1, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 6, -1, 5, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 7, -1, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 4, -1, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, -1, 6, this.limestonePolished, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 8, -1, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 4, -1, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 6, -1, 7, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 7, -1, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, -1, 8, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, pos, 6, 2, 6, this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 2, 6), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : "thebetweenlands:chiromaw", new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 2, 6), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : "thebetweenlands:chiromaw", new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 2, 25), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : "thebetweenlands:chiromaw", new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 2, 25), rand.nextBoolean() ? "thebetweenlands:swamp_hag" : "thebetweenlands:chiromaw", new Consumer[0]);
            this.rotatedCubeVolume(world, rand, pos, 3, 5, 3, this.limestonePolished, 0, 7, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 6, 5, 5, this.limestoneChiselled, 0, 1, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, 5, 6, this.limestoneChiselled, 0, 3, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, pos, 6, 8, 6, this.spawner, 0, 1, 1, 1, this.direction);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagCompound entityNbt = new NBTTagCompound();
            entityNbt.func_74778_a("id", "thebetweenlands:pyrad");
            EntityPyrad pyrad = new EntityPyrad(world);
            pyrad.func_110148_a(EntityPyrad.AGRESSIVE).func_111128_a(1.0);
            entityNbt.func_74782_a("Attributes", (NBTBase)SharedMonsterAttributes.func_111257_a((AbstractAttributeMap)pyrad.func_110140_aT()));
            nbt.func_74782_a("Entity", (NBTBase)entityNbt);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 8, 6), "thebetweenlands:pyrad", logic -> logic.setNextEntity(new WeightedSpawnerEntity(nbt)).setCheckRange(16.0).setMaxEntities(1));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 8, 6), "thebetweenlands:pyrad", logic -> logic.setNextEntity(new WeightedSpawnerEntity(nbt)).setCheckRange(16.0).setMaxEntities(1));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 8, 25), "thebetweenlands:pyrad", logic -> logic.setNextEntity(new WeightedSpawnerEntity(nbt)).setCheckRange(16.0).setMaxEntities(1));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 8, 25), "thebetweenlands:pyrad", logic -> logic.setNextEntity(new WeightedSpawnerEntity(nbt)).setCheckRange(16.0).setMaxEntities(1));
            this.rotatedCubeVolume(world, rand, pos, 4, 11, 4, this.limestonePolished, 0, 5, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 6, 11, 6, this.limestoneChiselled, 0, 1, 1, 1, this.direction);
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, pos, 6, 14, 6, this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 14, 6), "thebetweenlands:termite", new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 14, 6), "thebetweenlands:termite", new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 14, 25), "thebetweenlands:termite", new Consumer[0]);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 14, 25), "thebetweenlands:termite", new Consumer[0]);
            this.rotatedCubeVolume(world, rand, pos, 4, 16, 4, this.limestoneChiselled, 0, 5, 1, 5, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, 16, 4, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 4, 16, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 6, 16, 5, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 7, 16, 5, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 4, 16, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, 16, 6, this.limestonePolished, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 8, 16, 6, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 4, 16, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 6, 16, 7, this.limestonePolished, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 7, 16, 7, this.betweenstoneTiles, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, 16, 8, this.betweenstoneTiles, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 6, 19, 6, this.spawner, 0, 1, 1, 1, this.direction);
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 19, 6), "thebetweenlands:wight", logic -> logic.setCheckRange(32.0).setDelayRange(3000, 5000).setMaxEntities(3));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 19, 6), "thebetweenlands:wight", logic -> logic.setCheckRange(32.0).setDelayRange(3000, 5000).setMaxEntities(3));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(25, 19, 25), "thebetweenlands:wight", logic -> logic.setCheckRange(32.0).setDelayRange(3000, 5000).setMaxEntities(3));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(6, 19, 25), "thebetweenlands:wight", logic -> logic.setCheckRange(32.0).setDelayRange(3000, 5000).setMaxEntities(3));
            if (rand.nextBoolean()) {
                this.rotatedCubeVolume(world, rand, pos, 16, 26, 16, this.spawner, 0, 1, 1, 1, this.direction);
            }
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(16, 26, 16), "thebetweenlands:chiromaw", logic -> logic.setSpawnRange(2));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(16, 26, 15), "thebetweenlands:chiromaw", logic -> logic.setSpawnRange(2));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(15, 26, 16), "thebetweenlands:chiromaw", logic -> logic.setSpawnRange(2));
            BlockMobSpawnerBetweenlands.setMob(world, pos.func_177982_a(15, 26, 15), "thebetweenlands:chiromaw", logic -> logic.setSpawnRange(2));
            ++this.direction;
        }
        this.length = 13;
        this.width = 13;
        for (tower = 0; tower < 5; ++tower) {
            int x = 0;
            int y = 0;
            z = 0;
            if (tower == 1) {
                x = 19;
            }
            if (tower == 2) {
                x = 19;
                z = 19;
            }
            if (tower == 3) {
                z = 19;
            }
            this.direction = 0;
            while (this.direction < 4) {
                if (tower < 4) {
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 2, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 7, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 4, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 8, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 0, 3, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 0, 0, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 3, 1, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 0, 1, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 0, 0, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 0, 2, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 4, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 4, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 10, 3, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 4, 0, this.betweenstoneBrickWall, 0, 9, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 4, 1, this.betweenstoneBrickWall, 0, 1, 1, 3, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 4, 1, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 4, 1, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 4, 3, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 6, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 6, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 7, 2, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 9, 2, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 9, 3, this.betweenstoneBrickWall, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 14, 3, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 16, 2, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 16, 3, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 17, 2, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 17, 1, this.betweenstoneBrickWall, 0, 4, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 17, 3, this.betweenstoneBrickWall, 0, 1, 1, 3, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 16, 1, this.betweenstoneBrickWall, 0, 5, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 16, 0, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 15, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 18, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 18, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 16, 0, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 15, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 18, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 18, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 10, 2, this.betweenstoneBrickWall, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 14, 2, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 10, 2, this.betweenstoneBrickWall, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 10, 1, this.betweenstoneBrickWall, 0, 3, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 5, 1, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 8, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 5, 1, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 5, 0, this.betweenstoneBrickWall, 0, 3, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 9, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 9, 1, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 3, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 4, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 3, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 4, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 4, 4, this.betweenstoneBrickSlab, 8, 5, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 3, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 3, 1, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 0, 2, this.betweenstone, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 4, 1, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 4, 1, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 5, 2, this.betweenstoneBricks, 0, 1, 2, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 5, 3, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 5, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 3, 1, this.betweenstoneBricks, 0, 7, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 3, 3, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 8, 3, this.betweenstoneBricks, 0, 1, 6, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 8, 2, this.betweenstoneBricks, 0, 1, 11, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 8, 2, this.betweenstoneBricks, 0, 1, 11, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 16, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 17, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 17, 2, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 16, 3, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 10, 3, this.betweenstoneBricks, 0, 1, 8, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 10, 3, this.betweenstoneBricks, 0, 1, 8, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 10, 3, this.betweenstoneBricks, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 10, 3, this.betweenstoneBricks, 0, 1, 7, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 5, 2, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 5, 2, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 6, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 6, 2, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 15, 3, this.betweenstoneTilesFortress, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 14, 3, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 9, 2, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 8, 2, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 3, 0, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 2, 0, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 1, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 3, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 9, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 9, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 5, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 3, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 0, 3, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 8, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 8, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 8, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 8, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 11, 4, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 3, 0, 1, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 9, 0, 1, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 6, 2, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 6, 2, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    if (tower == 0 && this.direction == 0 || tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 1 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 10, 2, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
                    }
                    this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 12, 4, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                    if (tower == 0 && this.direction == 0 || tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 1 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 17, 3, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 17, 3, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 17, 3, this.chest, this.direction == 0 ? 3 : (this.direction == 1 ? 5 : (this.direction == 2 ? 2 : 4)), 1, 1, 1, this.direction);
                    }
                }
                ++this.direction;
            }
        }
        for (tower = 0; tower < 5; ++tower) {
            int x = 0;
            int y = 0;
            z = 0;
            if (tower == 1) {
                x = 19;
            }
            if (tower == 2) {
                x = 19;
                z = 19;
            }
            if (tower == 3) {
                z = 19;
            }
            this.direction = 0;
            while (this.direction < 4) {
                if (tower < 4) {
                    if (tower == 0 && this.direction == 0 || tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 1 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 4, 11, this.betweenstoneTiles, 0, 3, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 5, 12, this.betweenstoneBricks, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 5, 12, this.betweenstoneBricks, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 4, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 3, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 6, 10, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 5, 11, Blocks.field_150350_a.func_176223_P(), 0, 3, 5, 2, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 6, 12, this.betweenstoneBrickWall, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 6, 12, this.betweenstoneBrickWall, 0, 1, 1, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 7, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 7, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 9, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 9, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 10, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 10, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 10, 10, this.betweenstoneTilesCollapsing, 0, 3, 1, 6, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 11, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 11, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 12, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 12, 11, this.betweenstoneBrickWall, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 13, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 13, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 15, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 15, 11, this.betweenstoneBricks, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 16, 10, this.betweenstoneTiles, 0, 3, 1, 6, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 11, 10, Blocks.field_150350_a.func_176223_P(), 0, 3, 5, 2, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 17, 10, Blocks.field_150350_a.func_176223_P(), 0, 3, 4, 3, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 5, 12, this.possessedBlock, tower == 0 && this.direction == 0 ? 5 : (tower == 0 && this.direction == 1 ? 2 : (tower == 1 && this.direction == 0 ? 5 : (tower == 1 && this.direction == 3 ? 3 : (tower == 2 && this.direction == 2 ? 4 : (tower == 2 && this.direction == 3 ? 3 : (tower == 3 && this.direction == 1 ? 2 : 4)))))), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 5, 11, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 5, 12, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 5, 13, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 11, 10, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 11, 11, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 11, 12, this.lootPot1, this.direction == 0 ? 5 : (this.direction == 1 ? 3 : (this.direction == 2 ? 4 : 2)), 1, 1, 1, this.direction);
                    }
                    if (tower == 0 && this.direction == 0 || tower == 1 && this.direction == 3 || tower == 2 && this.direction == 2 || tower == 3 && this.direction == 1) {
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 16, 11, this.betweenstoneBricks, 0, 1, 3, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 7, 17, 15, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 17, 15, this.spikeTrap, 0, 3, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 9, 17, 14, this.betweenstoneBricks, 0, 2, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 19, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 19, 12, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 19, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 21, 10, this.betweenstoneBrickSlab, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 16, 12, this.betweenstoneBrickWall, 0, 1, 2, 4, this.direction);
                    }
                    if (tower == 0 && this.direction == 1 || tower == 1 && this.direction == 0 || tower == 2 && this.direction == 3 || tower == 3 && this.direction == 2) {
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 16, 11, this.betweenstoneBricks, 0, 1, 3, 4, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 5, 17, 15, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 17, 15, this.spikeTrap, 0, 3, 1, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 2, 17, 14, this.betweenstoneBricks, 0, 2, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 19, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 19, 12, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 19, 14, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 4, 21, 10, this.betweenstoneBrickSlab, 0, 1, 1, 5, this.direction);
                        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, y, z), 8, 16, 12, this.betweenstoneBrickWall, 0, 1, 2, 4, this.direction);
                    }
                }
                if (tower == 4) {
                    this.length = 14;
                    this.width = 14;
                    x = 9;
                    z = 9;
                    y = 18;
                    this.generateTopTowerRight(world, rand, pos.func_177982_a(x, y, z), this.direction);
                    this.generateTopTowerLeft(world, rand, pos.func_177982_a(x, y, z), this.direction);
                }
                ++this.direction;
            }
        }
        this.length = 32;
        this.width = 32;
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, pos, 10, 22, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 23, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 23, 11, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 24, 11, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 26, 11, this.betweenstoneBrickWall, 0, 1, 12, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 26, 12, this.betweenstoneBrickWall, 0, 1, 12, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 32, 12, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 34, 11, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 35, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 35, 12, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 32, 11, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 32, 14, this.betweenstoneBrickWall, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 32, 11, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 32, 15, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 33, 10, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 33, 14, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 34, 9, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 9, 34, 14, this.betweenstoneBrickWall, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 34, 10, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 34, 15, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 36, 11, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 36, 14, this.betweenstoneBrickWall, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 26, 10, this.betweenstoneBrickWall, 0, 1, 11, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 26, 13, this.betweenstoneBrickWall, 0, 1, 11, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 22, 10, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 22, 12, this.betweenstoneBrickWall, 0, 1, 4, 1, this.direction);
            ++this.direction;
        }
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, pos, 13, 0, 9, this.betweenstonePillar, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 3, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 4, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 9, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 10, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 15, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 16, 9, this.betweenstonePillar, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 0, 9, this.betweenstonePillar, 0, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 3, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 4, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 9, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 10, 9, this.betweenstonePillar, 0, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 15, 9, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 16, 9, this.betweenstonePillar, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 3, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 4, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 3, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 4, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 3, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 20, 4, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 4, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 9, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 9, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 10, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 9, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 10, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 9, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 20, 10, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 10, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 15, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 15, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 16, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 15, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 10, 16, 9, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 15, 9, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 20, 16, 9, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 22, 15, 9, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 16, 9, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 15, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 16, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 16, 11, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 16, 12, this.betweenstoneBrickSlab, 8, 1, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 16, 12, this.betweenstoneBrickSlab, 8, 4, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 15, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 16, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 16, 11, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 16, 12, this.betweenstoneBrickSlab, 8, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -1, 5, this.betweenstoneTiles, 0, 6, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, -1, 6, this.betweenstoneStairsSmooth, this.direction == 0 ? 3 : (this.direction == 1 ? 1 : (this.direction == 2 ? 2 : 0)), 4, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, -1, 7, this.betweenstoneStairsSmooth, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, -1, 7, this.betweenstoneSmooth, 0, 2, 1, 2, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, -1, 7, this.betweenstoneStairsSmooth, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 6, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, -1, 9, this.betweenstoneStairsSmooth, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, -1, 10, this.betweenstoneSmooth, 0, 2, 1, 3, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, -1, 13, this.betweenstoneStairsSmooth, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 2, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, -1, 6, this.betweenstoneTiles, 0, 1, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, -1, 6, this.betweenstoneTiles, 0, 1, 1, 7, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, -1, 12, this.betweenstoneTiles, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, -1, 14, this.betweenstoneSmooth, 0, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, -1, 15, this.stagnantWater, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, -2, 15, this.stagnantWater, 0, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 3, 5, this.betweenstoneBrickStairs, this.direction == 0 ? 7 : (this.direction == 1 ? 5 : (this.direction == 2 ? 6 : 4)), 6, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 0, 5, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 0, 5, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, 0, 13, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 5, 0, 18, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 1 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 0, 11, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 0, 11, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 0, 13, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 0, 18, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 4, 11, this.root, 0, 1, rand.nextInt(3) + 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 0, 14, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(4) + 4 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 16, 0, 14, this.root, 0, 1, rand.nextBoolean() ? rand.nextInt(3) + 2 : 0, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 0, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 0, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 5, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 16, 5, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 16, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 20, 11, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            ++this.direction;
        }
        this.direction = rand.nextInt(4);
        for (xa = 1; xa <= 31; ++xa) {
            for (int za2 = 1; za2 <= 31; ++za2) {
                if (!world.func_180495_p(pos.func_177982_a(xa, -1, za2)).func_185915_l() || !world.func_175623_d(pos.func_177982_a(xa, 0, za2)) || rand.nextInt(8) != 0) continue;
                this.func_175903_a(world, pos.func_177982_a(xa, 0, za2), this.getRandomMushroom(rand));
            }
        }
        this.rotatedCubeVolume(world, rand, pos, 13, 0, 3, this.betweenstoneBricks, 0, 1, 5, 2, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 0, 2, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 0, 1, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 0, 0, this.betweenstoneBricks, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 0, 3, this.betweenstoneBricks, 0, 1, 5, 2, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 0, 2, this.betweenstoneBricks, 0, 1, 4, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 0, 1, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 0, 0, this.betweenstoneBricks, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 0, 1, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 2, 4, this.betweenstoneBricks, 0, 4, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 2, 3, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 15, 0, 4, this.betweenstoneBricks, 0, 2, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 0, 4, this.betweenstoneBricksMirage, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 17, 0, 4, this.betweenstoneBricksMirage, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, -1, 0, this.betweenstoneTiles, 0, 4, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 15, 0, 3, this.chest, this.direction == 0 ? 4 : (this.direction == 1 ? 3 : (this.direction == 2 ? 5 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 16, 0, 3, this.chest, this.direction == 0 ? 4 : (this.direction == 1 ? 3 : (this.direction == 2 ? 5 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 5, 3, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 4, 2, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 3, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 2, 0, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 5, 3, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 4, 2, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 3, 1, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 2, 0, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 7, 4, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 7, 4, this.betweenstoneBrickWall, 0, 1, 2, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 0, 0, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 1, 1, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 2, 2, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 3, 3, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 4, 4, this.betweenstoneBrickStairs, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1)), 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 5, 3, Blocks.field_150350_a.func_176223_P(), 0, 4, 4, 2, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 4, 0, 13, this.betweenstone, 0, 1, 4, 6, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 4, 4, 14, this.betweenstone, 0, 1, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 3, 0, 14, this.betweenstone, 0, 1, 3, 4, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 15, this.betweenstone, 0, 1, 1, 2, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 27, 0, 13, this.betweenstone, 0, 1, 4, 6, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 27, 4, 14, this.betweenstone, 0, 1, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 28, 0, 14, this.betweenstone, 0, 1, 3, 4, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 28, 3, 15, this.betweenstone, 0, 1, 1, 2, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 0, 27, this.betweenstone, 0, 6, 4, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 4, 27, this.betweenstone, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 0, 28, this.betweenstone, 0, 4, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 15, 3, 28, this.betweenstone, 0, 2, 1, 1, this.direction);
        for (count = 0; count < 6; ++count) {
            this.rotatedCubeVolume(world, rand, pos, 16 + count, 5 + count, 24, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, pos, 17, 5, 24, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 6, 24, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 19, 7, 24, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 20, 8, 24, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 19, 5, 23, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 18, 10, 24, Blocks.field_150350_a.func_176223_P(), 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 22, 12, 24, this.possessedBlock, this.direction == 0 ? 4 : (this.direction == 1 ? 3 : (this.direction == 2 ? 5 : 2)), 1, 1, 1, this.direction);
        for (count = 0; count < 6; ++count) {
            this.rotatedCubeVolume(world, rand, pos, 16 - count, 11 + count, 7, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, pos, 10, 11, 7, this.betweenstoneBricks, 0, 6, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 10, 12, 7, this.betweenstoneBricks, 0, 5, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 10, 13, 7, this.betweenstoneBricks, 0, 4, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 10, 14, 7, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 10, 15, 7, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 10, 16, 7, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 12, 16, 7, Blocks.field_150350_a.func_176223_P(), 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 17, 19, 23, Blocks.field_150350_a.func_176223_P(), 0, 3, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 23, 17, 22, this.betweenstoneBricks, 0, 1, 4, 2, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 22, 21, 10, this.betweenstoneBrickSlab, 0, 2, 1, 14, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 22, 21, 14, this.betweenstoneBricks, 0, 1, 1, 4, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 22, 21, 10, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 22, 18, 22, this.betweenstoneBricks, 0, 1, 3, 2, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 19, 19, 23, this.betweenstoneBricks, 0, 3, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 20, 20, 23, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        for (count = 0; count < 3; ++count) {
            this.rotatedCubeVolume(world, rand, pos, 17 + count, 18 + count, 23, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, pos, 18, 19, 22, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 20, 21, 22, this.betweenstoneBrickSlab, 0, 1, 1, 1, this.direction);
        for (count = 0; count < 6; ++count) {
            this.rotatedCubeVolume(world, rand, pos, 22 - count, 22 + count, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 1 : (this.direction == 1 ? 2 : (this.direction == 2 ? 0 : 3)), 1, 1, 1, this.direction);
        }
        this.rotatedCubeVolume(world, rand, pos, 18, 27, 10, Blocks.field_150350_a.func_176223_P(), 0, 1, 5, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 21, 22, 10, this.betweenstoneBricks, 0, 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 19, 22, 10, this.betweenstoneBricks, 0, 1, 3, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 15, 27, 10, this.betweenstoneBricks, 0, 2, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 27, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 26, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 0 : (this.direction == 1 ? 3 : (this.direction == 2 ? 1 : 2)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 17, 26, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 4 : (this.direction == 1 ? 7 : (this.direction == 2 ? 5 : 6)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 14, 26, 10, this.betweenstoneBrickStairs, this.direction == 0 ? 5 : (this.direction == 1 ? 6 : (this.direction == 2 ? 4 : 7)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 17, 29, 11, this.obviousSign, this.direction == 0 ? 2 : (this.direction == 1 ? 4 : (this.direction == 2 ? 3 : 5)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 9, 17, 9, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, pos, 9, 17, 11, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, pos, 9, 17, 18, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, pos, 9, 17, 21, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, pos, 18, 17, 21, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, pos, 18, 17, 9, this.limestonePolished, 0, 5, 1, 2, 0);
        this.rotatedCubeVolume(world, rand, pos, 21, 17, 11, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, pos, 21, 17, 18, this.limestonePolished, 0, 2, 1, 3, 0);
        this.rotatedCubeVolume(world, rand, pos, 11, 17, 11, this.spikeTrap, 0, 10, 1, 10, 0);
        this.rotatedCubeVolume(world, rand, pos, 9, 17, 9, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 22, 17, 22, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 9, 17, 22, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 22, 17, 9, this.betweenstoneBricks, 0, 1, 1, 1, 0);
        this.setSwordStone(world, rand, pos.func_177982_a(12, 22, 12), this.swordStone, (byte)0);
        this.setSwordStone(world, rand, pos.func_177982_a(19, 22, 12), this.swordStone, (byte)1);
        this.setSwordStone(world, rand, pos.func_177982_a(19, 22, 19), this.swordStone, (byte)2);
        this.setSwordStone(world, rand, pos.func_177982_a(12, 22, 19), this.swordStone, (byte)3);
        this.rotatedCubeVolume(world, rand, pos, 12, 17, 12, this.betweenstoneTilesFortress, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 19, 17, 12, this.betweenstoneTilesFortress, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 19, 17, 19, this.betweenstoneTilesFortress, 0, 1, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 12, 17, 19, this.betweenstoneTilesFortress, 0, 1, 1, 1, 0);
        EntitySwordEnergy swordEnergy = new EntitySwordEnergy(world);
        swordEnergy.func_70107_b((double)pos.func_177958_n() + 16.0, (double)pos.func_177956_o() + 21.5, (double)pos.func_177952_p() + 16.0);
        world.func_72838_d((Entity)swordEnergy);
        this.rotatedCubeVolume(world, rand, pos, 12, 23, 12, this.limestonePolishedCollapsing, 0, 8, 1, 8, 0);
        this.rotatedCubeVolume(world, rand, pos, 16, 24, 16, this.chest, this.direction == 0 ? 5 : (this.direction == 1 ? 2 : (this.direction == 2 ? 4 : 3)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 16, 24, 15, this.chest, this.direction == 0 ? 5 : (this.direction == 1 ? 2 : (this.direction == 2 ? 4 : 3)), 1, 1, 1, this.direction);
        this.rotatedCubeVolume(world, rand, pos, 13, 28, 13, this.limestonePolished, 0, 6, 1, 6, 0);
        EntityFortressBossTeleporter tp = new EntityFortressBossTeleporter(world);
        tp.func_70012_b(pos.func_177958_n() + 16, pos.func_177956_o() + 30, pos.func_177952_p() + 16, 0.0f, 0.0f);
        tp.setTeleportDestination(new Vec3d((double)(pos.func_177958_n() + 16), (double)(pos.func_177956_o() + 17) + 19.2, (double)(pos.func_177952_p() + 16)));
        tp.setBossSpawnPosition(new BlockPos((double)(pos.func_177958_n() + 16), (double)(pos.func_177956_o() + 17 + 19) + 5.2, (double)(pos.func_177952_p() + 16)));
        world.func_72838_d((Entity)tp);
        this.rotatedCubeVolume(world, rand, pos, 13, 35, 13, this.betweenstoneTiles, 0, 6, 1, 6, 0);
        this.rotatedCubeVolume(world, rand, pos, 14, 35, 12, this.betweenstoneTiles, 0, 4, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 14, 35, 19, this.betweenstoneTiles, 0, 4, 1, 1, 0);
        this.rotatedCubeVolume(world, rand, pos, 12, 35, 14, this.betweenstoneTiles, 0, 1, 1, 4, 0);
        this.rotatedCubeVolume(world, rand, pos, 19, 35, 14, this.betweenstoneTiles, 0, 1, 1, 4, 0);
        this.direction = 0;
        while (this.direction < 4) {
            this.rotatedCubeVolume(world, rand, pos, 12, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 11, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 13, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 17, 7, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 18, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 20, 18, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 22, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 16, 22, 9, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 28, 11, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 16, 28, 11, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 12, 18, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 14, 19, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 17, 19, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 19, 18, 10, this.lootPot1, this.direction == 0 ? 2 : (this.direction == 1 ? 5 : (this.direction == 2 ? 3 : 4)), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 15, 29, 13, this.energyBarrier, 0, 2, 4, 1, this.direction);
            ++this.direction;
        }
        return true;
    }

    private void placeChest(World world, Random rand, BlockPos pos, int blockMeta) {
        this.func_175903_a(world, pos, this.getWeedWoodChestRotations(this.chest, blockMeta));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityChestBetweenlands) {
            ((TileEntityChestBetweenlands)tile).func_189404_a(LootTableRegistry.DUNGEON_CHEST_LOOT, rand.nextLong());
        }
    }

    private void placeRandomisedLootPot(World world, Random rand, BlockPos pos, IBlockState blockType, int blockMeta) {
        if (rand.nextInt(5) != 0 || world.func_175623_d(pos.func_177977_b())) {
            return;
        }
        this.func_175903_a(world, pos, this.getLootPotRotations(blockType, blockMeta));
        TileEntityLootPot lootPot = BlockLootPot.getTileEntity((IBlockAccess)world, pos);
        if (lootPot != null) {
            lootPot.setLootTable(LootTableRegistry.DUNGEON_POT_LOOT, rand.nextLong());
            lootPot.setModelRotationOffset(world.field_73012_v.nextInt(41) - 20);
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        }
    }

    public void setSwordStone(World world, Random rand, BlockPos pos, IBlockState blockType, byte type) {
        this.func_175903_a(world, pos, blockType);
        TileEntityItemCage swordStone = (TileEntityItemCage)world.func_175625_s(pos);
        if (swordStone != null) {
            swordStone.setType(type);
        }
    }

    private void placeSign(World world, Random rand, BlockPos pos, IBlockState state, int blockMeta) {
        this.func_175903_a(world, pos, state.func_177226_a((IProperty)BlockWallWeedwoodSign.field_176412_a, (Comparable)EnumFacing.func_82600_a((int)blockMeta)));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityWeedwoodSign) {
            TileEntityWeedwoodSign sign = (TileEntityWeedwoodSign)tile;
            sign.field_145915_a[0] = new TextComponentTranslation("sign.fortress.line1", new Object[0]);
            sign.field_145915_a[1] = new TextComponentTranslation("sign.fortress.line2", new Object[0]);
            sign.field_145915_a[2] = new TextComponentTranslation("sign.fortress.line3", new Object[0]);
            sign.field_145915_a[3] = new TextComponentTranslation("sign.fortress.line4", new Object[0]);
            sign.func_70296_d();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
        }
    }

    public void rotatedCubeVolume(World world, Random rand, BlockPos pos, int offsetA, int offsetB, int offsetC, IBlockState blockType, int blockMeta, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        switch (direction) {
            case 0: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = offsetA; xx < offsetA + sizeWidth; ++xx) {
                        for (int zz = offsetC; zz < offsetC + sizeDepth; ++zz) {
                            if (blockType == this.limestoneBrickSlab || blockType == this.betweenstoneBrickSlab) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getSlabType(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneTiles) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomTiles(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomBricks(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomWall(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomBetweenstoneBrickStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomSmoothBetweenstoneStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomSmoothBetweenstone(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomCollapsingTiles(rand));
                                continue;
                            }
                            if (blockType == this.possessedBlock) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getPossessedBlockRotations(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= 17 && yy != 0) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                    continue;
                                }
                                if (yy <= 17 && yy != 0) continue;
                                this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, pos.func_177982_a(xx, yy, zz), this.obviousSign, blockMeta);
                                continue;
                            }
                            this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), blockType);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = this.length - offsetA - 1; zz > this.length - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = offsetC; xx < offsetC + sizeDepth; ++xx) {
                            if (blockType == this.limestoneBrickSlab || blockType == this.betweenstoneBrickSlab) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getSlabType(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneTiles) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomTiles(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomBricks(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomWall(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomBetweenstoneBrickStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomSmoothBetweenstoneStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomSmoothBetweenstone(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomCollapsingTiles(rand));
                                continue;
                            }
                            if (blockType == this.possessedBlock) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getPossessedBlockRotations(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= 17 && yy != 0) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                    continue;
                                }
                                if (yy <= 17 && yy != 0) continue;
                                this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, pos.func_177982_a(xx, yy, zz), this.obviousSign, blockMeta);
                                continue;
                            }
                            this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), blockType);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = this.length - offsetA - 1; xx > this.length - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = this.length - offsetC - 1; zz > this.length - offsetC - sizeDepth - 1; --zz) {
                            if (blockType == this.limestoneBrickSlab || blockType == this.betweenstoneBrickSlab) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getSlabType(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneTiles) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomTiles(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomBricks(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomWall(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomBetweenstoneBrickStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomSmoothBetweenstoneStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomSmoothBetweenstone(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomCollapsingTiles(rand));
                                continue;
                            }
                            if (blockType == this.possessedBlock) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getPossessedBlockRotations(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= 17 && yy != 0) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                    continue;
                                }
                                if (yy <= 17 && yy != 0) continue;
                                this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, pos.func_177982_a(xx, yy, zz), this.obviousSign, blockMeta);
                                continue;
                            }
                            this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), blockType);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = offsetA; zz < offsetA + sizeWidth; ++zz) {
                        for (int xx = this.length - offsetC - 1; xx > this.length - offsetC - sizeDepth - 1; --xx) {
                            if (blockType == this.limestoneBrickSlab || blockType == this.betweenstoneBrickSlab) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getSlabType(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneTiles) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomTiles(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBricks) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomBricks(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickWall) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomWall(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneBrickStairs) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomBetweenstoneBrickStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneStairsSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getRandomSmoothBetweenstoneStairs(rand, blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.betweenstoneSmooth) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomSmoothBetweenstone(rand));
                                continue;
                            }
                            if (blockType == this.betweenstoneTilesCollapsing) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : this.getRandomCollapsingTiles(rand));
                                continue;
                            }
                            if (blockType == this.possessedBlock) {
                                this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), this.getPossessedBlockRotations(blockType, blockMeta));
                                continue;
                            }
                            if (blockType == this.lootPot1) {
                                this.placeRandomisedLootPot(world, rand, pos.func_177982_a(xx, yy, zz), rand.nextBoolean() ? blockType : (rand.nextBoolean() ? this.lootPot2 : this.lootPot3), blockMeta);
                                continue;
                            }
                            if (blockType == this.chest) {
                                if (yy <= 17 && yy != 0) {
                                    if (rand.nextInt(4) != 0) continue;
                                    this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                    continue;
                                }
                                if (yy <= 17 && yy != 0) continue;
                                this.placeChest(world, rand, pos.func_177982_a(xx, yy, zz), blockMeta);
                                continue;
                            }
                            if (blockType == this.obviousSign) {
                                this.placeSign(world, rand, pos.func_177982_a(xx, yy, zz), this.obviousSign, blockMeta);
                                continue;
                            }
                            this.func_175903_a(world, pos.func_177982_a(xx, yy, zz), blockType);
                        }
                    }
                }
                break;
            }
        }
    }

    public void generateTopTowerRight(World world, Random rand, BlockPos pos, int direction) {
        this.rotatedCubeVolume(world, rand, pos, 0, 0, 1, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 0, 0, 3, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 1, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 2, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 2, 0, 1, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 4, 0, 1, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 2, 4, 2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 2, 4, 3, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 3, 4, 2, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 1, this.betweenstoneBricks, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 3, 8, 3, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 4, 8, 2, this.betweenstoneBricks, 0, 1, 11, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 16, 2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 5, 17, 2, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 16, 3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 4, 10, 3, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 5, 10, 3, this.betweenstoneBricks, 0, 1, 7, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 1, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 3, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 5, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 4, 5, 2, this.betweenstoneBricks, 0, 2, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 5, 6, 2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 15, 3, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 14, 3, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 9, 2, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 8, 2, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 3, 0, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 2, 0, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 1, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 3, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 5, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 5, 9, 2, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 5, 2, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 1, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 0, 3, 3, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 5, 4, 1, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 4, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos, 6, 10, 3, this.betweenstoneBrickStairs, direction == 0 ? 2 : (direction == 1 ? 0 : (direction == 2 ? 3 : 1)), 2, 1, 1, direction);
    }

    public void generateTopTowerLeft(World world, Random rand, BlockPos pos, int direction) {
        int x = 0;
        int z = 0;
        if (direction == 2) {
            z = -13;
        }
        if (direction == 0) {
            z = 13;
        }
        if (direction == 3) {
            x = -13;
        }
        if (direction == 1) {
            x = 13;
        }
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 0, 0, -1, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 0, 0, -3, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 1, 0, -1, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 1, 0, -2, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 2, 0, -1, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 4, 0, -1, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 2, 4, -2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 2, 4, -3, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 3, 4, -2, this.betweenstoneBricks, 0, 1, 4, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 3, 3, -1, this.betweenstoneBricks, 0, 4, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 1, 3, -3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 3, 8, -3, this.betweenstoneBricks, 0, 1, 6, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 4, 8, -2, this.betweenstoneBricks, 0, 1, 11, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 16, -2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 5, 17, -2, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 16, -3, this.betweenstoneBricks, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 4, 10, -3, this.betweenstoneBricks, 0, 1, 8, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 5, 10, -3, this.betweenstoneBricks, 0, 1, 7, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 1, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 3, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 5, 0, 0, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 4, 5, -2, this.betweenstoneBricks, 0, 2, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 5, 6, -2, this.betweenstoneBricks, 0, 1, 3, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 15, -3, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 14, -3, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 9, -2, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 8, -2, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 3, 0, this.betweenstoneTiles, 0, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 2, 0, this.betweenstoneBrickSlab, 8, 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 1, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 3, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 5, 3, 0, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 5, 9, -2, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 6, 5, -2, this.betweenstoneBrickStairs, direction == 0 ? 3 : (direction == 1 ? 1 : (direction == 2 ? 2 : 0)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 0, 3, -1, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
        this.rotatedCubeVolume(world, rand, pos.func_177982_a(x, 0, z), 0, 3, -3, this.betweenstoneBrickStairs, direction == 0 ? 0 : (direction == 1 ? 3 : (direction == 2 ? 1 : 2)), 1, 1, 1, direction);
    }
}

