/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.world.gen.feature.WorldGenHelper;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenUndergroundRuins
extends WorldGenHelper {
    public IBlockState PITSTONE_TILES = BlockRegistry.PITSTONE_TILES.func_176223_P();
    public IBlockState PITSTONE_BRICKS = BlockRegistry.PITSTONE_BRICKS.func_176223_P();
    public IBlockState PITSTONE_PILLAR = BlockRegistry.PITSTONE_PILLAR.func_176223_P();
    public IBlockState PITSTONE_BRICK_WALL = BlockRegistry.PITSTONE_BRICK_WALL.func_176223_P();
    public IBlockState PITSTONE_CHISELED = BlockRegistry.PITSTONE_PILLAR.func_176223_P();
    public IBlockState PITSTONE_BRICK_SLAB = BlockRegistry.PITSTONE_BRICK_SLAB.func_176223_P();
    public IBlockState PITSTONE_BRICK_SLAB_UPSIDE_DOWN = BlockRegistry.PITSTONE_BRICK_SLAB.func_176223_P();
    public IBlockState PITSTONE_BRICK_STAIRS = BlockRegistry.PITSTONE_BRICK_STAIRS.func_176223_P();
    private List<AxisAlignedBB> locationAABBs = new ArrayList<AxisAlignedBB>();

    private boolean structure1(World world, Random random, int x, int y, int z, LocationStorage location) {
        this.width = 7;
        this.depth = 6;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, 1, 4, this.depth, direction) || this.rotatedCubeCantReplace(world, x, y, z, 6, 0, 0, 1, 4, this.depth, direction) || this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 4, 1, direction) || this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 5, this.width, 4, 1, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        location.addBounds(this.rotatedAABB(world, x, y, z, 0.0, 0.0, 0.0, 1.0, 4.0, this.depth, direction).func_72314_b(3.0, 2.0, 3.0));
        location.addBounds(this.rotatedAABB(world, x, y, z, 6.0, 0.0, 0.0, 1.0, 4.0, this.depth, direction).func_72314_b(3.0, 2.0, 3.0));
        location.addBounds(this.rotatedAABB(world, x, y, z, 0.0, 0.0, 0.0, this.width, 4.0, 1.0, direction).func_72314_b(3.0, 2.0, 3.0));
        location.addBounds(this.rotatedAABB(world, x, y, z, 0.0, 0.0, 5.0, this.width, 4.0, 1.0, direction).func_72314_b(3.0, 2.0, 3.0));
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, this.PITSTONE_TILES, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 0, this.PITSTONE_TILES, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 0, this.PITSTONE_TILES, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, this.PITSTONE_TILES, 2, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 5, this.PITSTONE_TILES, 5, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, this.PITSTONE_BRICKS, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, this.PITSTONE_BRICKS, 5, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1 + random.nextInt(5), 1, 5, this.PITSTONE_CHISELED, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 0, this.PITSTONE_BRICKS, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 2 + random.nextInt(2), Blocks.field_150350_a.func_176223_P(), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 2, 0, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 5, this.PITSTONE_BRICKS, 7, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2 + random.nextInt(4), 2, 5, Blocks.field_150350_a.func_176223_P(), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, this.PITSTONE_BRICKS, 1, 1, 2, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 0, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 3, 4, this.PITSTONE_BRICKS, 1, 1, 2, direction, new Consumer[0]);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 1, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 5, 0, 1, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 4, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 5, 0, 4, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        return true;
    }

    private boolean structure2(World world, Random random, int x, int y, int z, LocationStorage location) {
        this.width = 9;
        this.depth = 11;
        int direction = random.nextInt(4);
        int height = 6 + random.nextInt(2);
        if (this.rotatedCubeCantReplace(world, x, y, z, 4, height - 3, 0, 5, height - 3, this.depth, direction) || this.rotatedCubeCantReplace(world, x, y, z, 0, height - 3, 6, 4, height - 3, 5, direction)) {
            return false;
        }
        if (!(this.makePitstoneSupport(world, x, y, z, 0, -1, 6, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 0, -1, 10, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 4, -1, 6, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 4, -1, 10, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 4, -1, 2, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 8, -1, 6, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 8, -1, 10, 1, 1, direction, true) && this.makePitstoneSupport(world, x, y, z, 8, -1, 2, 1, 1, direction, true))) {
            return false;
        }
        location.addBounds(this.rotatedAABB(world, x, y, z, 4.0, height - 3, 0.0, 5.0, height - 3, this.depth, direction).func_72314_b(2.0, 2.0, 2.0));
        this.makePitstoneSupport(world, x, y, z, 0, -1, 6, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 0, -1, 10, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 4, -1, 6, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 4, -1, 10, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 4, -1, 2, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 8, -1, 6, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 8, -1, 10, 1, 1, direction, false);
        this.makePitstoneSupport(world, x, y, z, 8, -1, 2, 1, 1, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 6, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 10, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 6, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 10, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 2, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, 0, 6, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, 0, 10, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, 0, 2, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 6, this.PITSTONE_PILLAR, 1, 2 + random.nextInt(3), 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 10, this.PITSTONE_PILLAR, 1, random.nextInt(3), 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 6, this.PITSTONE_PILLAR, 1, height - 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 10, this.PITSTONE_PILLAR, 1, height - 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 2, this.PITSTONE_PILLAR, 1, height - 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, 1, 6, this.PITSTONE_PILLAR, 1, height - 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, 1, 10, this.PITSTONE_PILLAR, 1, height - 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, 1, 2, this.PITSTONE_PILLAR, 1, height - 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, height - 2, 10, this.PITSTONE_BRICKS, 8, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, height - 2, 9, this.PITSTONE_TILES, 6, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, height - 2, 8, this.PITSTONE_TILES, 5, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, height - 2, 7, this.PITSTONE_TILES, 6, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, height - 2, 6, this.PITSTONE_BRICKS, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 2, 0, this.PITSTONE_BRICKS, 1, 1, 10, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, height - 2, 1, this.PITSTONE_TILES, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, height - 2, 2, this.PITSTONE_TILES, 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, height - 2, 3, this.PITSTONE_TILES, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 2, 2, this.PITSTONE_BRICKS, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 1, 10, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 1, 1, this.PITSTONE_BRICK_WALL, 1, 1, 9, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 8, height - 1, 2 + random.nextInt(7), Blocks.field_150350_a.func_176223_P(), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 1, 2, this.PITSTONE_BRICK_WALL, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 1, 3 + random.nextInt(2), Blocks.field_150350_a.func_176223_P(), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, height - 1, 6, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, height - 1, 10, this.PITSTONE_BRICK_WALL, 6, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3 + random.nextInt(4), height - 1, 10, Blocks.field_150350_a.func_176223_P(), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, height - 1, 6, this.PITSTONE_BRICK_WALL, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, height - 1, 6, this.PITSTONE_BRICK_WALL, 1, 1, 1, direction, new Consumer[0]);
        if (random.nextBoolean()) {
            this.rotatedCubeVolume(world, x, y, z, 8, height, 10, this.PITSTONE_CHISELED, 1, 1, 1, direction, new Consumer[0]);
        }
        this.rotatedLootPot(world, random, x, y, z, 7, height - 1, 9, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 5, height - 1, 4, direction, 1, 2, 4, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 7, direction, 1, 2, 4, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 7, 0, 9, direction, 1, 2, 4, LootTableRegistry.DUNGEON_POT_LOOT);
        return true;
    }

    private boolean structure3(World world, Random random, int x, int y, int z, LocationStorage location) {
        this.width = 6;
        this.depth = 6;
        int direction = 0;
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 7, this.depth, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        location.addBounds(this.rotatedAABB(world, x, y, z, 0.0, 0.0, 0.0, this.width, 7.0, this.depth, direction).func_72314_b(2.0, 1.0, 2.0));
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 1, this.PITSTONE_TILES, 4, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, this.PITSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 5, this.PITSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 0, this.PITSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 5, this.PITSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, this.getStateFromRotation(3, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 1, this.getStateFromRotation(0, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 5, this.getStateFromRotation(1, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 0, 1, this.getStateFromRotation(2, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 0, this.PITSTONE_PILLAR, 1, 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 5, this.PITSTONE_PILLAR, 1, 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 0, this.PITSTONE_PILLAR, 1, 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 5, this.PITSTONE_PILLAR, 1, 3, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 5, 0, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 5, 5, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 5, 0, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 5, 5, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 5, 0, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 5, 1, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 5, 5, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 5, 1, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 6, 0, this.PITSTONE_BRICK_SLAB, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 6, 1, this.PITSTONE_BRICK_SLAB, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 6, 5, this.PITSTONE_BRICK_SLAB, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 6, 1, this.PITSTONE_BRICK_SLAB, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedLootPot(world, random, x, y, z, 1, 1, 1, 0, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 4, 1, 1, 0, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 1, 1, 4, 0, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 4, 1, 4, 0, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        return true;
    }

    private boolean structure4(World world, Random random, int x, int y, int z, LocationStorage location) {
        this.depth = 11;
        this.width = 5;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 4, this.depth, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        location.addBounds(this.rotatedAABB(world, x, y, z, 0.0, 0.0, 0.0, this.width, 4.0, this.depth, direction).func_72314_b(2.0, 1.0, 2.0));
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, this.PITSTONE_BRICKS, 1, 1, 11, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 4, this.PITSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 10, this.PITSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 4, this.PITSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 10, this.PITSTONE_BRICKS, 1, 4, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 0, 2, this.PITSTONE_BRICKS, 1, 1, 9, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 10, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 2, this.PITSTONE_BRICKS, 1, 1, 9, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 3, this.PITSTONE_BRICKS, 1, 1, 8, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, this.PITSTONE_BRICK_SLAB, 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 1, 5, this.PITSTONE_BRICK_SLAB, 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 1, 10, this.PITSTONE_CHISELED, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 2, 5, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 2, 5, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, this.PITSTONE_BRICKS, 1, 1, 8, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 2, 4, this.PITSTONE_BRICKS, 1, 1, 7, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 2, 10, this.PITSTONE_BRICKS, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 2, 4, this.getStateFromRotation(3, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.UPSIDE_DOWN_STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 4, this.PITSTONE_BRICKS, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 3, 4, this.PITSTONE_BRICKS, 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 3, 4, this.PITSTONE_BRICKS, 1, 1, 6, direction, new Consumer[0]);
        for (int i = 0; i <= 4; ++i) {
            this.rotatedLootPot(world, random, x, y, z, 1, 0, 5 + i, direction, 1, 2, 4, LootTableRegistry.DUNGEON_POT_LOOT);
            this.rotatedLootPot(world, random, x, y, z, 3, 0, 5 + i, direction, 1, 2, 4, LootTableRegistry.DUNGEON_POT_LOOT);
        }
        return true;
    }

    private boolean structure5(World world, Random random, int x, int y, int z, LocationStorage location) {
        this.depth = 8;
        this.width = 7;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, this.width, 5, this.depth, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        location.addBounds(this.rotatedAABB(world, x, y, z, 0.0, 0.0, 0.0, this.width, 5.0, this.depth, direction).func_72314_b(2.0, 1.0, 2.0));
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, this.PITSTONE_BRICKS, 7, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 6, this.PITSTONE_BRICKS, 7, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, this.PITSTONE_BRICKS, 1, 1, 7, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 0, 0, this.PITSTONE_BRICKS, 1, 1, 7, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 2, this.PITSTONE_BRICK_WALL, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 4, this.PITSTONE_BRICK_WALL, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 1, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 1, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 3, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 1, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 5, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 0, 5, this.PITSTONE_BRICK_SLAB_UPSIDE_DOWN, 3, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 5, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, this.PITSTONE_TILES, 7, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 6, this.PITSTONE_TILES, 7, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 0, this.PITSTONE_TILES, 1, 2, 7, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 0, this.PITSTONE_TILES, 1, 2, 7, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 0, this.PITSTONE_BRICK_WALL, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 4, 1, 6, this.PITSTONE_BRICK_WALL, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 1, 3, this.PITSTONE_BRICK_WALL, 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 1, this.PITSTONE_BRICK_WALL, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 1, 5, this.PITSTONE_BRICK_WALL, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 3, Blocks.field_150350_a.func_176223_P(), 1, 2, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 2, this.getStateFromRotation(3, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 3, this.getStateFromRotation(0, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 2, 4, this.getStateFromRotation(1, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 0, this.getStateFromRotation(3, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 7, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 3, 1, this.getStateFromRotation(0, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 6, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 3, 6, this.getStateFromRotation(1, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 6, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 7, 3, 1, this.getStateFromRotation(2, direction, this.PITSTONE_BRICK_STAIRS, WorldGenHelper.EnumRotationSequence.STAIR), 1, 1, 5, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 4, 1, this.PITSTONE_BRICK_SLAB, 5, 1, 5, direction, new Consumer[0]);
        this.rotatedLootPot(world, random, x, y, z, 2, 1, 1, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 2, 1, 5, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 6, 1, 1, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 6, 1, 5, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        return true;
    }

    private boolean structure6(World world, Random random, int x, int y, int z, LocationStorage location) {
        this.width = 7;
        this.depth = 7;
        int direction = random.nextInt(4);
        if (this.rotatedCubeCantReplace(world, x, y, z, 0, 0, 0, 3, 2, 1, direction) || this.rotatedCubeCantReplace(world, x, y, z, 1, 0, 0, 1, 1, 1, direction) || this.rotatedCubeCantReplace(world, x, y, z, 6, 0, 3, 1, 2, 3, direction) || this.rotatedCubeCantReplace(world, x, y, z, 2, 0, 6, 4, 3, 1, direction)) {
            return false;
        }
        if (!this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, true)) {
            return false;
        }
        location.addBounds(this.rotatedAABB(world, x, y, z, 0.0, 0.0, 0.0, 3.0, 2.0, 1.0, direction).func_72314_b(3.0, 2.0, 3.0));
        location.addBounds(this.rotatedAABB(world, x, y, z, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, direction).func_72314_b(3.0, 2.0, 3.0));
        location.addBounds(this.rotatedAABB(world, x, y, z, 6.0, 0.0, 3.0, 1.0, 2.0, 3.0, direction).func_72314_b(3.0, 2.0, 3.0));
        location.addBounds(this.rotatedAABB(world, x, y, z, 2.0, 0.0, 6.0, 4.0, 3.0, 1.0, direction).func_72314_b(3.0, 2.0, 3.0));
        this.makePitstoneSupport(world, x, y, z, 0, -1, 0, this.width, this.depth, direction, false);
        this.rotatedCubeVolume(world, x, y, z, 0, 0, 0, this.PITSTONE_BRICKS, 1, 1, 3, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 1, 0, 0, this.PITSTONE_BRICKS, 1, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 0, 3, this.PITSTONE_BRICKS, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 2, 0, 6, this.PITSTONE_BRICKS, 4, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 0, 1, 0, this.PITSTONE_BRICKS, 1, 1, 2, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 6, 1, 4, this.PITSTONE_BRICKS, 1, 1, 4, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 3, 1, 6, this.PITSTONE_BRICKS, 3, 1, 1, direction, new Consumer[0]);
        this.rotatedCubeVolume(world, x, y, z, 5, 2, 6, this.PITSTONE_BRICKS, 2, 1, 1, direction, new Consumer[0]);
        this.rotatedLootPot(world, random, x, y, z, 5, 0, 5, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        this.rotatedLootPot(world, random, x, y, z, 1, 0, 1, direction, 1, 2, 3, LootTableRegistry.DUNGEON_POT_LOOT);
        return true;
    }

    private boolean makePitstoneSupport(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int sizeWidth, int sizeDepth, int direction, boolean simulate) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                if (world.func_175707_a(new BlockPos(x + offsetX, y, z + offsetZ), new BlockPos(x + offsetX + sizeWidth, y + offsetZ, z + offsetZ + sizeWidth))) {
                    for (int xx = x + offsetX; xx < x + offsetX + sizeWidth; ++xx) {
                        block7: for (int zz = z + offsetZ; zz < z + offsetZ + sizeDepth; ++zz) {
                            int yy = y + offsetY;
                            int times = 0;
                            while (world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)this.getCheckPos(xx, yy, zz))) {
                                if (!simulate) {
                                    world.func_180501_a(new BlockPos(xx, yy, zz), BlockRegistry.PITSTONE.func_176223_P(), 18);
                                }
                                --yy;
                                if (++times <= 4) continue;
                                if (!simulate) continue block7;
                                return false;
                            }
                        }
                    }
                    break;
                }
                return false;
            }
            case 1: {
                if (world.func_175707_a(new BlockPos(x + offsetZ, y, z + this.depth - offsetX - sizeWidth - 1), new BlockPos(x + offsetZ + sizeDepth, y + offsetZ, z + this.depth - offsetX - 1))) {
                    for (int zz = z + this.depth - offsetX - 1; zz > z + this.depth - offsetX - sizeWidth - 1; --zz) {
                        block10: for (int xx = x + offsetZ; xx < x + offsetZ + sizeDepth; ++xx) {
                            int yy = y + offsetY;
                            int times = 0;
                            while (world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)this.getCheckPos(xx, yy, zz))) {
                                if (!simulate) {
                                    world.func_180501_a(new BlockPos(xx, yy, zz), BlockRegistry.PITSTONE.func_176223_P(), 18);
                                }
                                --yy;
                                if (++times <= 4) continue;
                                if (!simulate) continue block10;
                                return false;
                            }
                        }
                    }
                    break;
                }
                return false;
            }
            case 2: {
                if (world.func_175707_a(new BlockPos(x - offsetX - sizeWidth - 1, y, z + this.depth - offsetZ - sizeDepth - 1), new BlockPos(x + this.width - offsetX - 1, y + offsetZ, z + this.depth - offsetZ - 1))) {
                    for (int xx = x + this.width - offsetX - 1; xx > x + this.width - offsetX - sizeWidth - 1; --xx) {
                        block13: for (int zz = z + this.depth - offsetZ - 1; zz > z + this.depth - offsetZ - sizeDepth - 1; --zz) {
                            int yy = y + offsetY;
                            int times = 0;
                            while (world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)this.getCheckPos(xx, yy, zz))) {
                                if (!simulate) {
                                    world.func_180501_a(new BlockPos(xx, yy, zz), BlockRegistry.PITSTONE.func_176223_P(), 18);
                                }
                                --yy;
                                if (++times <= 4) continue;
                                if (!simulate) continue block13;
                                return false;
                            }
                        }
                    }
                    break;
                }
                return false;
            }
            case 3: {
                if (world.func_175707_a(new BlockPos(x + this.width - offsetZ - sizeDepth - 1, y, z + offsetX), new BlockPos(x + this.width - offsetZ - 1, y + offsetZ, z + offsetX + sizeWidth))) {
                    for (int zz = z + offsetX; zz < z + offsetX + sizeWidth; ++zz) {
                        block16: for (int xx = x + this.width - offsetZ - 1; xx > x + this.width - offsetZ - sizeDepth - 1; --xx) {
                            int yy = y + offsetY;
                            int times = 0;
                            while (world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)this.getCheckPos(xx, yy, zz))) {
                                if (!simulate) {
                                    world.func_180501_a(new BlockPos(xx, yy, zz), BlockRegistry.PITSTONE.func_176223_P(), 18);
                                }
                                --yy;
                                if (++times <= 4) continue;
                                if (!simulate) continue block16;
                                return false;
                            }
                        }
                    }
                    break;
                }
                return false;
            }
        }
        return true;
    }

    public boolean func_180709_b(World world, Random random, BlockPos position) {
        int y;
        boolean shouldStop = true;
        int x = position.func_177958_n();
        int z = position.func_177952_p();
        for (y = position.func_177956_o(); y > 15; --y) {
            if (world.func_180495_p((BlockPos)this.getCheckPos(x, y - 1, z)).func_177230_c() != BlockRegistry.PITSTONE || !world.func_175623_d((BlockPos)this.getCheckPos(x, y, z))) continue;
            shouldStop = false;
            break;
        }
        if (shouldStop) {
            return false;
        }
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        LocationStorage locationStorage = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(position), "underground_ruins", EnumLocationType.RUINS);
        boolean generated = false;
        int randomInt = random.nextInt(6);
        switch (randomInt) {
            case 0: {
                generated = this.structure1(world, random, x, y, z, locationStorage);
                break;
            }
            case 1: {
                generated = this.structure2(world, random, x, y, z, locationStorage);
                break;
            }
            case 2: {
                generated = this.structure3(world, random, x, y, z, locationStorage);
                break;
            }
            case 3: {
                generated = this.structure4(world, random, x, y, z, locationStorage);
                break;
            }
            case 4: {
                generated = this.structure5(world, random, x, y, z, locationStorage);
                break;
            }
            case 5: {
                generated = this.structure6(world, random, x, y, z, locationStorage);
                break;
            }
        }
        if (generated) {
            locationStorage.setSeed(random.nextLong());
            locationStorage.linkChunks();
            locationStorage.setDirty(true);
            worldStorage.getLocalStorageHandler().addLocalStorage(locationStorage);
            return true;
        }
        return false;
    }
}

