/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.structure.BlockTreePortal;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationPortal;

public class WorldGenSmallPortal
extends WorldGenerator {
    protected final EnumFacing dir;

    public WorldGenSmallPortal(EnumFacing dir) {
        super(true);
        this.dir = dir;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        for (BlockPos p : BlockPos.func_191532_a((int)(pos.func_177958_n() - 2), (int)(pos.func_177956_o() + 1), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)(pos.func_177956_o() + 4), (int)(pos.func_177952_p() + 2))) {
            world.func_175698_g(p);
        }
        for (BlockPos p : BlockPos.func_191532_a((int)(pos.func_177958_n() - 2), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 2))) {
            world.func_175656_a(p, BlockRegistry.LOG_PORTAL.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
        }
        if (this.dir.func_176740_k() == EnumFacing.Axis.X) {
            BlockTreePortal.makePortalX(world, pos.func_177981_b(2));
        }
        if (this.dir.func_176740_k() == EnumFacing.Axis.Z) {
            BlockTreePortal.makePortalZ(world, pos.func_177981_b(2));
        }
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        LocationPortal location = new LocationPortal(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(pos), pos.func_177972_a(this.dir).func_177977_b());
        location.addBounds(new AxisAlignedBB(pos).func_72314_b(2.0, 1.0, 2.0).func_72321_a(0.0, -2.0, 0.0).func_72317_d(0.0, 3.0, 0.0).func_72321_a(0.0, -1.0, 0.0));
        location.setSeed(rand.nextLong());
        location.setDirty(true);
        location.setVisible(false);
        location.linkChunks();
        worldStorage.getLocalStorageHandler().addLocalStorage(location);
        return true;
    }
}

