/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.misc.Fog;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.sky.BLSkyRenderer;
import thebetweenlands.client.render.sky.BLSnowRenderer;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.EventRift;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeProviderBetweenlands;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class WorldProviderBetweenlands
extends WorldProvider {
    public static final int LAYER_HEIGHT = 120;
    public static final int CAVE_WATER_HEIGHT = 15;
    public static final int PITSTONE_HEIGHT = 45;
    public static final int CAVE_START = 110;
    private boolean allowHostiles = true;
    private boolean allowAnimals = true;
    private BetweenlandsWorldStorage worldData;
    @SideOnly(value=Side.CLIENT)
    private static BLSkyRenderer skyRenderer;
    private boolean showClouds = false;

    public static final WorldProviderBetweenlands getProvider(World world) {
        if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands) {
            return (WorldProviderBetweenlands)world.field_73011_w;
        }
        return null;
    }

    public boolean func_76567_e() {
        return true;
    }

    public float func_76563_a(long worldTime, float partialTickTime) {
        return 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        EventRift rift = BetweenlandsWorldStorage.forWorld((World)this.field_76579_a).getEnvironmentEventRegistry().rift;
        return rift.getVisibility(partialTicks) * this.getOverworldSunBrightness(partialTicks) * 0.6f + rift.getVisibility(partialTicks) * 0.2f;
    }

    public float getSunBrightnessFactor(float partialTicks) {
        BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorldNullable(this.field_76579_a);
        if (storage != null) {
            EventRift rift = storage.getEnvironmentEventRegistry().rift;
            return rift.getVisibility(partialTicks) * this.getOverworldSunBrightnessFactor(partialTicks);
        }
        return 0.2f;
    }

    protected float getOverworldSunBrightnessFactor(float partialTicks) {
        float f = this.getOverworldCelestialAngle(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        return f1;
    }

    @SideOnly(value=Side.CLIENT)
    protected float getOverworldSunBrightness(float partialTicks) {
        float f = this.getOverworldCelestialAngle(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        return f1 * 0.8f + 0.2f;
    }

    public float getOverworldCelestialAngle(float partialTicks) {
        int i = (int)(this.field_76579_a.func_72820_D() % 24000L);
        float f = ((float)i + partialTicks) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorBetweenlands(this.field_76579_a, this.field_76579_a.func_72905_C(), BlockRegistry.BETWEENSTONE, BlockRegistry.SWAMP_WATER, 120);
    }

    protected void func_76556_a() {
        if (this.field_76579_a.field_72995_K) {
            float configBrightness = (float)BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionBrightness / 100.0f;
            for (int i = 0; i <= 15; ++i) {
                float f1 = 1.0f - (float)Math.pow((float)i / 15.0f, 1.1f + 0.35f * (1.0f - configBrightness));
                this.field_76573_f[i] = Math.max((1.0f - f1) / (f1 * f1 * (0.75f + configBrightness * 0.6f) + 1.0f) * (0.4f + configBrightness * 0.5f) - 0.1f, 0.0f);
            }
        } else {
            super.func_76556_a();
        }
    }

    public void func_76572_b() {
        this.setDimension(BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
        this.field_76578_c = new BiomeProviderBetweenlands(this, this.field_76579_a.func_72912_H());
        this.field_191067_f = true;
    }

    public boolean func_76569_d() {
        return this.showClouds;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public void setAllowedSpawnTypes(boolean allowHostiles, boolean allowAnimals) {
        super.setAllowedSpawnTypes(allowHostiles, allowAnimals);
        this.allowHostiles = allowHostiles;
        this.allowAnimals = allowAnimals;
    }

    public boolean getCanSpawnHostiles() {
        return this.allowHostiles;
    }

    public boolean getCanSpawnAnimals() {
        return this.allowAnimals;
    }

    public BlockPos getRandomizedSpawnPoint() {
        BlockPos spawnPos = this.field_76579_a.func_175694_M();
        boolean isAdventure = this.field_76579_a.func_72912_H().func_76077_q() == GameType.ADVENTURE;
        int spawnFuzz = 100;
        int spawnFuzzHalf = spawnFuzz / 2;
        if (!isAdventure) {
            spawnPos = spawnPos.func_177982_a(this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf, 0, this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf);
            spawnPos = this.field_76579_a.func_175672_r(spawnPos);
        }
        return spawnPos;
    }

    protected BetweenlandsWorldStorage getWorldData() {
        return BetweenlandsWorldStorage.forWorld(this.field_76579_a);
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return true;
    }

    public void updateWeather() {
        BLEnvironmentEventRegistry eeRegistry = this.getWorldData().getEnvironmentEventRegistry();
        this.field_76579_a.func_72912_H().func_76080_g(2000);
        this.field_76579_a.func_72912_H().func_76090_f(2000);
        this.field_76579_a.func_72912_H().func_76084_b(eeRegistry.heavyRain.isActive());
        this.field_76579_a.func_72912_H().func_76069_a(eeRegistry.thunderstorm.isActive());
        this.field_76579_a.field_73018_p = eeRegistry.thunderstorm.isActive() ? 1.0f : 0.0f;
        this.field_76579_a.field_73017_q = this.field_76579_a.field_73018_p;
        this.field_76579_a.field_73003_n = this.field_76579_a.field_73004_o;
        if (!this.field_76579_a.field_72995_K) {
            float rainingStrength = this.field_76579_a.field_73004_o;
            if (eeRegistry.heavyRain.isActive()) {
                if (rainingStrength < 0.5f) {
                    rainingStrength += 0.0125f;
                }
                if (rainingStrength > 0.5f) {
                    rainingStrength = 0.5f;
                }
            } else {
                if (rainingStrength > 0.0f) {
                    rainingStrength -= 0.0125f;
                }
                if (rainingStrength < 0.0f) {
                    rainingStrength = 0.0f;
                }
            }
            this.field_76579_a.field_73004_o = rainingStrength;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClientLightTable(EntityPlayer player) {
        float f1;
        int i;
        float configBrightness = (float)BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionBrightness / 100.0f;
        float[] surfaceTable = new float[16];
        float[] undergroundTable = new float[16];
        for (i = 0; i <= 15; ++i) {
            f1 = 1.0f - (float)Math.pow((float)i / 15.0f, 1.1f + 0.35f * (1.0f - configBrightness));
            surfaceTable[i] = Math.max((1.0f - f1) / (f1 * f1 * (0.75f + configBrightness * 0.6f) + 1.0f) * (0.4f + configBrightness * 0.5f) - 0.1f, 0.0f);
        }
        for (i = 0; i <= 15; ++i) {
            f1 = 1.0f - (float)Math.pow((float)i / 15.0f, 0.4);
            undergroundTable[i] = Math.max((1.0f - f1) / (f1 * 2.5f * (1.0f - configBrightness) + 1.0f) * 0.425f - 0.05f, -0.035f + 0.035f * configBrightness * configBrightness);
        }
        double caveHeightDiff = Math.max(110.0 - player.field_70163_u, 0.0);
        float caveMultiplier = (float)caveHeightDiff / 110.0f;
        caveMultiplier = 1.0f - caveMultiplier;
        caveMultiplier = (float)((double)caveMultiplier * Math.pow(caveMultiplier, 6.0));
        for (int i2 = 0; i2 < 16; ++i2) {
            this.field_76573_f[i2] = surfaceTable[i2] + (undergroundTable[i2] - surfaceTable[i2]) * (1.0f - caveMultiplier);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTickTime) {
        Fog fog = FogHandler.getFogState().getFog(partialTickTime);
        return new Vec3d((double)fog.getRed(), (double)fog.getGreen(), (double)fog.getBlue());
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return WorldProviderBetweenlands.getBLSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return new Vec3d((double)0.1f, (double)0.8f, (double)0.55f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static BLSkyRenderer getBLSkyRenderer() {
        if (skyRenderer == null) {
            skyRenderer = new BLSkyRenderer();
        }
        return skyRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (this.getEnvironmentEventRegistry().snowfall.isSnowing()) {
            return BLSnowRenderer.INSTANCE;
        }
        return null;
    }

    public BLEnvironmentEventRegistry getEnvironmentEventRegistry() {
        return this.getWorldData().getEnvironmentEventRegistry();
    }

    public DimensionType func_186058_p() {
        return TheBetweenlands.dimensionType;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowClouds(boolean show) {
        this.showClouds = show;
    }
}

