/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.capability.IFlightCapability;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.network.serverbound.MessageFlightState;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemRingOfFlight
extends ItemRing {
    public ItemRingOfFlight() {
        this.func_77656_e(1800);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.ring.flight.bonus", (Object[])new Object[0]), 0));
        if (GuiScreen.func_146272_n()) {
            String toolTip = I18n.func_135052_a((String)"tooltip.ring.flight", (Object[])new Object[]{KeyBindRegistry.RADIAL_MENU.getDisplayName(), Minecraft.func_71410_x().field_71474_y.field_74314_A.getDisplayName()});
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.press.shift", (Object[])new Object[0]));
        }
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity, IInventory inventory) {
        block17: {
            EntityPlayer player;
            IFlightCapability cap;
            block18: {
                NBTTagCompound nbt;
                block19: {
                    block20: {
                        if (!(entity instanceof EntityPlayer) || (cap = (IFlightCapability)(player = (EntityPlayer)entity).getCapability(CapabilityRegistry.CAPABILITY_FLIGHT, null)) == null) break block17;
                        cap.setFlightRing(true);
                        if (cap.canFlyWithoutRing(player) || !cap.canFlyWithRing(player, stack)) break block18;
                        double flightHeight = 3.5;
                        if (player.field_70170_p.field_72995_K || cap.isFlying()) {
                            player.field_71075_bZ.field_75101_c = true;
                        }
                        boolean isFlying = cap.isFlying();
                        nbt = NBTHelper.getStackNBTSafe(stack);
                        if (entity.field_70122_E) break block19;
                        if (!isFlying) break block20;
                        cap.onFlightTick(player, stack, !nbt.func_74767_n("ringActive"));
                        nbt.func_74757_a("ringActive", true);
                        if (entity.func_70093_af()) {
                            entity.field_70181_x = -0.2f;
                        } else {
                            double actualPosY = entity.field_70163_u;
                            double height = this.getGroundHeight(player);
                            Vec3d dir = new Vec3d(entity.func_70040_Z().field_72450_a, 0.0, entity.func_70040_Z().field_72449_c).func_72432_b();
                            if (player.field_191988_bg > 0.0f) {
                                entity.field_70159_w += dir.field_72450_a * (double)0.02f;
                                entity.field_70179_y += dir.field_72449_c * (double)0.02f;
                            }
                            double my = 0.0;
                            boolean moveUp = false;
                            if (player.field_70170_p.field_72995_K && player instanceof EntityPlayerSP) {
                                moveUp = ((EntityPlayerSP)player).field_71158_b.field_78901_c;
                            }
                            if (moveUp) {
                                my = 0.1;
                            }
                            double mul = height - (actualPosY - flightHeight);
                            entity.field_70181_x = my * mul;
                            if (actualPosY - flightHeight > height && entity.field_70181_x > 0.0) {
                                entity.field_70181_x = 0.0;
                            }
                            if (actualPosY - flightHeight > height) {
                                entity.field_70181_x = -Math.min(actualPosY - flightHeight - height, 2.0) / 8.0;
                            }
                        }
                        entity.field_70143_R = 0.0f;
                        if (entity.field_70122_E || !entity.field_70170_p.field_72995_K) break block17;
                        if (cap.getFlightTime() > 40) {
                            BLParticles.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(400, Float.valueOf(0.0f), entity));
                        } else {
                            for (int i = 0; i < 5; ++i) {
                                BLParticles.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(400, Float.valueOf(1.0f - ((float)cap.getFlightTime() + (float)i / 5.0f) / 40.0f), entity));
                            }
                        }
                        break block17;
                    }
                    nbt.func_74757_a("ringActive", false);
                    break block17;
                }
                cap.setFlying(false);
                nbt.func_74757_a("ringActive", false);
                break block17;
            }
            if (!player.field_70170_p.field_72995_K) {
                NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
                nbt.func_74757_a("ringActive", false);
                if (cap.isFlying()) {
                    cap.setFlying(false);
                }
            }
            if (cap.isFlying() && !player.field_70122_E && player.field_70170_p.field_72995_K) {
                if (cap.getFlightTime() > 40) {
                    BLParticles.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(400, Float.valueOf(0.0f), entity));
                } else {
                    for (int i = 0; i < 5; ++i) {
                        BLParticles.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(400, Float.valueOf(1.0f - ((float)cap.getFlightTime() + (float)i / 5.0f) / 40.0f), entity));
                    }
                }
            }
        }
    }

    private double getGroundHeight(EntityPlayer player) {
        RayTraceResult result = player.field_70170_p.func_72901_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v), new Vec3d(player.field_70165_t, player.field_70163_u - 64.0, player.field_70161_v), true);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            return result.field_72307_f.field_72448_b;
        }
        return -512.0;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player != null) {
            IFlightCapability cap;
            EntityPlayer player = event.player;
            if (!player.field_71075_bZ.field_75098_d && (cap = (IFlightCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FLIGHT, null)) != null) {
                if (cap.isFlying()) {
                    cap.setFlightTime(cap.getFlightTime() + 1);
                }
                ItemStack flightRing = ItemStack.field_190927_a;
                IEquipmentCapability equipmentCap = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
                if (equipmentCap != null) {
                    IInventory inv = equipmentCap.getInventory(EnumEquipmentInventory.RING);
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.RING_OF_FLIGHT) continue;
                        flightRing = stack;
                        break;
                    }
                }
                if (!flightRing.func_190926_b() && player.field_70170_p.field_72995_K) {
                    if (!cap.canFlyWithoutRing(player) && cap.canFlyWithRing(player, flightRing)) {
                        if (event.phase == TickEvent.Phase.START) {
                            player.field_71075_bZ.field_75100_b = false;
                        } else if (player.field_71075_bZ.field_75100_b) {
                            cap.setFlying(!cap.isFlying());
                            if (player == TheBetweenlands.proxy.getClientPlayer()) {
                                TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageFlightState(cap.isFlying()));
                            }
                        }
                    } else if (cap.isFlying()) {
                        cap.setFlying(false);
                        if (player == TheBetweenlands.proxy.getClientPlayer()) {
                            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageFlightState(cap.isFlying()));
                        }
                    }
                }
                if (player == TheBetweenlands.proxy.getClientPlayer() && player.field_70173_aa % 20 == 0) {
                    TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageFlightState(cap.isFlying()));
                }
                if (event.phase == TickEvent.Phase.END && (flightRing.func_190926_b() || !cap.isFlying()) && cap.getFlightRing()) {
                    if (!cap.canFlyWithoutRing(player)) {
                        player.field_71075_bZ.field_75100_b = false;
                        player.field_71075_bZ.field_75101_c = false;
                        if (player.field_70170_p.field_72995_K) {
                            player.field_71075_bZ.func_75092_a(0.05f);
                        }
                    }
                    cap.setFlightRing(false);
                }
            }
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("ringActive", false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("ringActive");
    }
}

