/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets.text;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.TextFormatting;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.herblore.book.widgets.text.TextContainer;

public class FormatTags {

    public static class TagFont
    extends TextContainer.RangedTag {
        private FontRenderer font;

        public TagFont() {
            super("font");
        }

        @Override
        TextContainer.Tag create() {
            return new TagFont();
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 0) {
                FontRenderer font;
                switch (argument) {
                    default: {
                        font = container.getDefaultFont();
                        break;
                    }
                    case "custom": {
                        font = TheBetweenlands.proxy.getCustomFontRenderer();
                    }
                }
                this.font = font;
                container.setCurrentFont(font);
                return true;
            }
            return false;
        }

        @Override
        void pop(TextContainer container, TextContainer.RangedTag previous) {
            if (previous != null) {
                container.setCurrentFont(((TagFont)previous).font);
            } else {
                container.setCurrentFont(container.getDefaultFont());
            }
        }
    }

    public static class TagRainbow
    extends TextContainer.RangedTag {
        public TagRainbow() {
            super("rb");
        }

        @Override
        TextContainer.RangedTag create() {
            return new TagRainbow();
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 1) {
                area.addProperty("rainbow");
                return true;
            }
            return false;
        }

        @Override
        void expand(TextContainer container, TextContainer.TextArea area) {
            area.addProperty("rainbow");
        }
    }

    public static class TagPagelink
    extends TextContainer.RangedTag {
        private String page;
        private List<PagelinkArea> pagelinkAreas = new ArrayList<PagelinkArea>();

        public TagPagelink() {
            super("pagelink");
        }

        @Override
        TextContainer.RangedTag create() {
            return new TagPagelink();
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 1) {
                this.page = argument;
                PagelinkArea newArea = new PagelinkArea(area, this.page);
                this.pagelinkAreas.add(newArea);
                container.addTextArea(newArea);
                return true;
            }
            return false;
        }

        @Override
        void expand(TextContainer container, TextContainer.TextArea area) {
            if (this.pagelinkAreas.size() > 0) {
                TextContainer.TextArea prev = this.pagelinkAreas.get(this.pagelinkAreas.size() - 1);
                prev.setBounds(prev);
            }
            PagelinkArea newArea = new PagelinkArea(area, this.page);
            this.pagelinkAreas.add(newArea);
            container.addTextArea(newArea);
        }

        @Override
        void pop(TextContainer container, TextContainer.RangedTag previous) {
            for (PagelinkArea pagelinkArea : this.pagelinkAreas) {
                container.removeTextArea(pagelinkArea);
            }
        }

        public static class PagelinkArea
        extends TextContainer.TextArea {
            public final String page;

            public PagelinkArea(TextContainer.TextArea area, String page) {
                super(area);
                this.page = page;
            }

            @Override
            public boolean equals(Object object) {
                if (object instanceof PagelinkArea) {
                    PagelinkArea area = (PagelinkArea)object;
                    return super.equals(area) && area.page.equals(this.page);
                }
                return false;
            }
        }
    }

    public static class TagSimple
    extends TextContainer.RangedTag {
        private final TextFormatting format;
        private final String name;

        public TagSimple(String name, TextFormatting format) {
            super(name);
            this.name = name;
            this.format = format;
        }

        @Override
        TextContainer.RangedTag create() {
            return new TagSimple(this.name, this.format);
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 0) {
                container.addFormatting(this.format);
                return true;
            }
            return false;
        }

        @Override
        void pop(TextContainer container, TextContainer.RangedTag previous) {
            container.removeFormatting(this.format);
        }
    }

    public static class TagTooltip
    extends TextContainer.RangedTag {
        private String text;
        private List<TextContainer.TooltipArea> tooltipAreas = new ArrayList<TextContainer.TooltipArea>();

        public TagTooltip(String text) {
            super("tooltip");
            this.text = text;
        }

        @Override
        TextContainer.RangedTag create() {
            return new TagTooltip("N/A");
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 1) {
                this.text = argument;
                TextContainer.TooltipArea newArea = new TextContainer.TooltipArea(area, this.text);
                this.tooltipAreas.add(newArea);
                container.addTextArea(newArea);
                return true;
            }
            return false;
        }

        @Override
        void expand(TextContainer container, TextContainer.TextArea area) {
            if (this.tooltipAreas.size() > 0) {
                TextContainer.TextArea prev = this.tooltipAreas.get(this.tooltipAreas.size() - 1);
                prev.setBounds(prev);
            }
            TextContainer.TooltipArea newArea = new TextContainer.TooltipArea(area, this.text);
            this.tooltipAreas.add(newArea);
            container.addTextArea(newArea);
        }

        @Override
        void pop(TextContainer container, TextContainer.RangedTag previous) {
            for (TextContainer.TooltipArea tooltipArea : this.tooltipAreas) {
                container.removeTextArea(tooltipArea);
            }
        }
    }

    public static class TagColor
    extends TextContainer.RangedTag {
        private int color;

        public TagColor(int color) {
            super("color");
            this.color = color;
        }

        @Override
        TextContainer.RangedTag create() {
            return new TagColor(0x808080);
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 0) {
                this.color = Integer.decode(argument);
                container.setCurrentColor(this.color);
                return true;
            }
            return false;
        }

        @Override
        void pop(TextContainer container, TextContainer.RangedTag previous) {
            container.setCurrentColor(((TagColor)previous).color);
        }
    }

    public static class TagScale
    extends TextContainer.RangedTag {
        private float scale;

        public TagScale(float scale) {
            super("scale");
            this.scale = scale;
        }

        @Override
        TextContainer.RangedTag create() {
            return new TagScale(this.scale);
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 0) {
                this.scale = Float.parseFloat(argument);
                container.setCurrentScale(this.scale);
                return true;
            }
            return false;
        }

        @Override
        void pop(TextContainer container, TextContainer.RangedTag previous) {
            container.setCurrentScale(((TagScale)previous).scale);
        }
    }

    public static class TagNewPage
    extends TextContainer.Tag {
        public TagNewPage() {
            super("np");
        }

        @Override
        TextContainer.Tag create() {
            return new TagNewPage();
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 0) {
                container.newPage();
                return true;
            }
            return false;
        }
    }

    public static class TagNewLine
    extends TextContainer.Tag {
        public TagNewLine() {
            super("nl");
        }

        @Override
        TextContainer.Tag create() {
            return new TagNewLine();
        }

        @Override
        boolean push(TextContainer container, TextContainer.Tag previous, String argument, TextContainer.TextArea area, int pass) {
            if (pass == 0) {
                container.newLine();
                return true;
            }
            return false;
        }
    }
}

