/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class LocationHandler {
    public static List<LocationStorage> getLocations(Entity entity) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(entity.field_70170_p);
        return worldStorage.getLocalStorageHandler().getLocalStorages(LocationStorage.class, entity.field_70165_t, entity.field_70161_v, location -> location.isInside(entity));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) != null && !player.field_70170_p.field_72995_K) {
            if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_70170_p.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                if (player.field_70163_u < 100.0) {
                    AdvancementCriterionRegistry.LOCATION.trigger((EntityPlayerMP)player, "caverns");
                } else {
                    AdvancementCriterionRegistry.LOCATION.trigger((EntityPlayerMP)player, "wilderness");
                }
            }
            List<LocationStorage> locations = LocationHandler.getLocations((Entity)player);
            for (LocationStorage loc : locations) {
                if (!(player instanceof EntityPlayerMP)) continue;
                AdvancementCriterionRegistry.LOCATION.trigger((EntityPlayerMP)player, loc.getName());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player != null) {
            BlockPos pos = event.getPos();
            BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(event.getWorld());
            List<LocationStorage> locations = worldStorage.getLocalStorageHandler().getLocalStorages(LocationStorage.class, pos.func_177958_n(), pos.func_177952_p(), location -> location.isInside((Vec3i)pos));
            for (LocationStorage location2 : locations) {
                location2.onBreakBlock(event);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!player.func_184812_l_()) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if (event instanceof BlockEvent.MultiPlaceEvent) {
                BlockEvent.MultiPlaceEvent multiPlaceEvent = (BlockEvent.MultiPlaceEvent)event;
                for (BlockSnapshot snapshot : multiPlaceEvent.getReplacedBlockSnapshots()) {
                    positions.add(snapshot.getPos());
                }
            } else {
                positions.add(event.getPos());
            }
            for (BlockPos pos : positions) {
                List<LocationStorage> locations = LocationStorage.getLocations(player.field_70170_p, new Vec3d((Vec3i)pos));
                for (LocationStorage location : locations) {
                    if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(player.field_70170_p, (Entity)player, pos)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_184812_l_() && !event.getItemStack().func_190926_b() && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) != Blocks.field_150350_a) {
            BlockPos resultingPos = event.getPos();
            IBlockState blockState = player.field_70170_p.func_180495_p(resultingPos);
            if (!blockState.func_177230_c().func_176200_f((IBlockAccess)player.field_70170_p, resultingPos)) {
                resultingPos = resultingPos.func_177972_a(event.getFace());
            }
            List<LocationStorage> locations = LocationStorage.getLocations(player.field_70170_p, new Vec3d((Vec3i)resultingPos));
            for (LocationStorage location : locations) {
                if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(player.field_70170_p, (Entity)player, resultingPos)) continue;
                event.setUseItem(Event.Result.DENY);
                if (event.getWorld().field_72995_K) {
                    Vec3d hitVec = event.getHitVec();
                    BLParticles.BLOCK_PROTECTION.spawn(event.getWorld(), hitVec.field_72450_a + (double)((float)event.getFace().func_82601_c() * 0.025f), hitVec.field_72448_b + (double)((float)event.getFace().func_96559_d() * 0.025f), hitVec.field_72449_c + (double)((float)event.getFace().func_82599_e() * 0.025f), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(event.getFace()));
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        List<LocationStorage> locations = LocationStorage.getLocations(player.field_70170_p, new Vec3d((Vec3i)event.getPos()));
        for (LocationStorage location : locations) {
            if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(player.field_70170_p, (Entity)player, event.getPos())) continue;
            event.setNewSpeed(0.0f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        World world = event.getWorld();
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        Long2ObjectOpenHashMap locationCache = new Long2ObjectOpenHashMap();
        ArrayList<LocationStorage> affectedLocations = new ArrayList<LocationStorage>();
        for (BlockPos pos : explosion.func_180343_e()) {
            long chunkId = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
            List<LocationStorage> locations = (List<LocationStorage>)locationCache.get(chunkId);
            if (locations == null) {
                locations = worldStorage.getLocalStorageHandler().getLocalStorages(LocationStorage.class, pos.func_177958_n(), pos.func_177952_p(), storage -> storage.getGuard() != null);
                locationCache.put(chunkId, locations);
            }
            for (LocationStorage location : locations) {
                if (!location.getGuard().isGuarded(world, (Entity)explosion.func_94613_c(), pos) || affectedLocations.contains(location)) continue;
                affectedLocations.add(location);
            }
        }
        for (LocationStorage location : affectedLocations) {
            location.getGuard().handleExplosion(world, explosion);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getEntityPlayer().func_184812_l_()) {
            List<LocationStorage> locations = LocationStorage.getLocations(event.getWorld(), new Vec3d((Vec3i)event.getPos()));
            for (LocationStorage location : locations) {
                if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(event.getWorld(), (Entity)event.getEntityPlayer(), event.getPos())) continue;
                if (event.getWorld().field_72995_K && event.getEntityPlayer().field_110158_av == 0) {
                    Vec3d hitVec = event.getHitVec();
                    BLParticles.BLOCK_PROTECTION.spawn(event.getWorld(), hitVec.field_72450_a + (double)((float)event.getFace().func_82601_c() * 0.025f), hitVec.field_72448_b + (double)((float)event.getFace().func_96559_d() * 0.025f), hitVec.field_72449_c + (double)((float)event.getFace().func_82599_e() * 0.025f), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(event.getFace()));
                }
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
        if (LocationHandler.isProtected(event.getEntityLiving().field_70170_p, (Entity)event.getEntityLiving(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    public static boolean isProtected(World world, @Nullable Entity entity, BlockPos pos) {
        List<LocationStorage> locations = LocationStorage.getLocations(world, new Vec3d((Vec3i)pos));
        for (LocationStorage location : locations) {
            if (location == null || location.getGuard() == null || !location.getGuard().isGuarded(world, entity, pos)) continue;
            return true;
        }
        return false;
    }
}

