/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;

public abstract class EntityWallFace
extends EntityCreature
implements IEntityBL {
    private static final DataParameter<EnumFacing> FACING = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<EnumFacing> FACING_UP = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<BlockPos> ANCHOR = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187200_j);
    private int targetFacingTimeout = 40;
    private EnumFacing targetFacing;
    private EnumFacing targetFacingUp;
    private int targetAnchorTimeout = 40;
    private BlockPos targetAnchor;
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> MOVE_SPEED = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<EnumFacing> MOVE_FACING = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<EnumFacing> MOVE_FACING_UP = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<BlockPos> MOVE_ANCHOR = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> ANCHORED = EntityDataManager.func_187226_a(EntityWallFace.class, (DataSerializer)DataSerializers.field_187198_h);
    protected final LookHelper field_70749_g = new LookHelper(this);
    private float lastMoveProgress = 0.0f;
    private float moveProgress = 0.0f;
    protected float peek = 0.25f;

    public EntityWallFace(World world) {
        super(world);
        this.field_70765_h = new MoveHelper(this);
        this.func_70105_a(0.9f, 0.9f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FACING, (Object)EnumFacing.NORTH);
        this.field_70180_af.func_187214_a(FACING_UP, (Object)EnumFacing.UP);
        this.field_70180_af.func_187214_a(ANCHOR, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(MOVE_SPEED, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(MOVE_FACING, (Object)EnumFacing.NORTH);
        this.field_70180_af.func_187214_a(MOVE_FACING_UP, (Object)EnumFacing.UP);
        this.field_70180_af.func_187214_a(MOVE_ANCHOR, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(ANCHORED, (Object)true);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.field_70180_af.func_187227_b(ANCHOR, (Object)new BlockPos((Entity)this));
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || super.func_180431_b(source);
    }

    public boolean func_70652_k(Entity target) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, target);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public LookHelper getLookHelper() {
        return this.field_70749_g;
    }

    public MoveHelper getMoveHelper() {
        return (MoveHelper)this.field_70765_h;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70613_aW() && !this.func_70610_aX()) {
            this.field_70749_g.func_75649_a();
        }
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
    }

    public boolean func_70104_M() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected boolean func_70610_aX() {
        return this.isMoving();
    }

    public void func_70659_e(float speedIn) {
        this.field_70180_af.func_187227_b(MOVE_SPEED, (Object)Float.valueOf(speedIn));
    }

    public float func_70689_ay() {
        return ((Float)this.field_70180_af.func_187225_a(MOVE_SPEED)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        if (!this.isAnchored()) {
            return super.func_70070_b();
        }
        EnumFacing facing = this.getFacing();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_70165_t) + facing.func_82601_c(), 0, MathHelper.func_76128_c((double)this.field_70161_v) + facing.func_82599_e());
        if (this.field_70170_p.func_175667_e((BlockPos)pos)) {
            pos.func_185336_p(MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())) + facing.func_96559_d());
            return this.field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190926_b()) {
            return null;
        }
        EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
        EnumFacing facing = this.getFacing();
        Vec3d dropPos = this.getFrontCenter().func_72441_c((double)((float)facing.func_82601_c() * entityItem.field_70130_N), (double)((float)facing.func_96559_d() * entityItem.field_70131_O), (double)((float)facing.func_82599_e() * entityItem.field_70130_N));
        entityItem.func_70107_b(dropPos.field_72450_a, dropPos.field_72448_b, dropPos.field_72449_c);
        entityItem.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entityItem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityItem);
        }
        return entityItem;
    }

    public boolean func_70685_l(Entity entity) {
        Vec3d frontCenter = this.getFrontCenter();
        return this.field_70170_p.func_147447_a(frontCenter, new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false, true, false) == null;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("facing", this.getFacing().func_176745_a());
        nbt.func_74768_a("facingUp", this.getFacing().func_176745_a());
        nbt.func_74772_a("anchor", this.getAnchor().func_177986_g());
        nbt.func_74757_a("anchored", this.isAnchored());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(FACING, (Object)EnumFacing.func_82600_a((int)nbt.func_74762_e("facing")));
        this.field_70180_af.func_187227_b(FACING_UP, (Object)EnumFacing.func_82600_a((int)nbt.func_74762_e("facingUp")));
        this.field_70180_af.func_187227_b(ANCHOR, (Object)BlockPos.func_177969_a((long)nbt.func_74763_f("anchor")));
        if (!nbt.func_150297_b("anchored", 1)) {
            this.setAnchored(true);
        } else {
            this.setAnchored(nbt.func_74767_n("anchored"));
        }
    }

    public void func_70071_h_() {
        boolean isAnchored = (Boolean)this.field_70180_af.func_187225_a(ANCHORED);
        if (isAnchored) {
            this.field_70143_R = 0.0f;
            this.field_70122_E = true;
            this.func_189654_d(true);
            double px = this.field_70165_t;
            double py = this.field_70163_u;
            double pz = this.field_70161_v;
            super.func_70071_h_();
            this.field_70169_q = this.field_70142_S = px;
            this.field_70165_t = this.field_70142_S;
            this.field_70167_r = this.field_70137_T = py;
            this.field_70163_u = this.field_70137_T;
            this.field_70166_s = this.field_70136_U = pz;
            this.field_70161_v = this.field_70136_U;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else {
            this.func_189654_d(false);
            super.func_70071_h_();
        }
        this.updatePositioning(isAnchored);
        this.updateMovement();
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.isAnchored()) {
            this.field_70124_G = true;
            this.field_70123_F = true;
            this.field_70132_H = true;
        } else {
            super.func_70091_d(type, x, y, z);
        }
    }

    public void func_174828_a(BlockPos pos, float rotationYawIn, float rotationPitchIn) {
        if (!this.isAnchored()) {
            super.func_174828_a(pos, rotationYawIn, rotationPitchIn);
        }
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
        if (!this.isAnchored()) {
            super.func_191958_b(strafe, up, forward, friction);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.field_70143_R = 0.0f;
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return false;
    }

    protected void updatePositioning(boolean isAnchored) {
        EnumFacing facing = this.getFacing();
        EnumFacing facingUp = this.getFacingUp();
        if (isAnchored) {
            if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                this.field_70125_A = facing == EnumFacing.UP ? -90.0f : 90.0f;
                this.field_70127_C = this.field_70125_A;
                this.field_70760_ar = this.field_70761_aq = facingUp.func_185119_l();
            } else {
                this.field_70125_A = 0.0f;
                this.field_70127_C = 0.0f;
                this.field_70760_ar = this.field_70761_aq = facing.func_185119_l();
            }
        } else if (this.field_70122_E && Math.abs(this.field_70125_A + 90.0f) > 1.0f) {
            if (this.field_70125_A > -90.0f) {
                this.field_70125_A -= 25.0f;
                if (this.field_70125_A < -90.0f) {
                    this.field_70125_A = -90.0f;
                }
            } else {
                this.field_70125_A += 25.0f;
                if (this.field_70125_A > -90.0f) {
                    this.field_70125_A = -90.0f;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            int violatedChecks;
            if (!this.isMoving()) {
                if (this.targetFacingTimeout > 0) {
                    --this.targetFacingTimeout;
                } else {
                    this.targetFacingUp = null;
                    this.targetFacing = null;
                }
                if (this.targetAnchorTimeout > 0) {
                    --this.targetAnchorTimeout;
                } else {
                    this.targetAnchor = null;
                }
                if (!(this.func_70610_aX() || this.isMoving() || this.targetFacing == null && this.targetAnchor == null)) {
                    BlockPos targetAnchor;
                    EnumFacing targetFacing = this.targetFacing != null ? this.targetFacing : facing;
                    EnumFacing targetFacingUp = this.targetFacingUp != null ? this.targetFacingUp : facingUp;
                    BlockPos blockPos = targetAnchor = this.targetAnchor != null ? this.targetAnchor : this.getAnchor();
                    if (!(facing == targetFacing && facingUp == targetFacingUp && this.getAnchor().equals((Object)targetAnchor) || this.checkAnchorAt(targetAnchor, targetFacing, targetFacingUp, 7) != 0)) {
                        this.field_70180_af.func_187227_b(MOVING, (Object)true);
                        this.field_70180_af.func_187227_b(MOVE_FACING, (Object)targetFacing);
                        this.field_70180_af.func_187227_b(MOVE_FACING_UP, (Object)targetFacingUp);
                        this.field_70180_af.func_187227_b(MOVE_ANCHOR, (Object)targetAnchor);
                        this.targetFacing = null;
                        this.targetFacingUp = null;
                        this.targetAnchor = null;
                    }
                }
            }
            if ((violatedChecks = this.checkAnchorHere(7)) != 0) {
                this.fixUnsuitablePosition(violatedChecks);
            }
        }
        if (!this.isMoving() && isAnchored) {
            Vec3d offset = this.getOffset(1.0f);
            Vec3d position = this.getCenter().func_178787_e(offset);
            this.func_70107_b(position.field_72450_a, position.field_72448_b - (double)this.field_70131_O / 2.0, position.field_72449_c);
        }
    }

    protected void updateMovement() {
        this.lastMoveProgress = this.moveProgress;
        if (this.isMoving()) {
            float movementProgress = this.getMovementProgress(1.0f);
            if (movementProgress < 0.5f) {
                Vec3d offset = this.getOffset(movementProgress);
                Vec3d position = this.getCenter().func_178787_e(offset);
                this.func_70107_b(position.field_72450_a, position.field_72448_b - (double)this.field_70131_O / 2.0, position.field_72449_c);
            } else {
                this.field_70180_af.func_187227_b(ANCHOR, this.field_70180_af.func_187225_a(MOVE_ANCHOR));
                this.field_70180_af.func_187227_b(FACING, this.field_70180_af.func_187225_a(MOVE_FACING));
                this.field_70180_af.func_187227_b(FACING_UP, this.field_70180_af.func_187225_a(MOVE_FACING_UP));
                this.setAnchored(true);
                Vec3d offset = this.getOffset(movementProgress);
                Vec3d position = this.getCenter().func_178787_e(offset);
                double px = this.field_70165_t;
                double py = this.field_70163_u;
                double pz = this.field_70161_v;
                this.func_70107_b(position.field_72450_a, position.field_72448_b - (double)this.field_70131_O / 2.0, position.field_72449_c);
                if ((this.field_70165_t - px) * (this.field_70165_t - px) + (this.field_70163_u - py) * (this.field_70163_u - py) + (this.field_70161_v - pz) * (this.field_70161_v - pz) >= 1.0) {
                    this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            }
            if (this.moveProgress >= 1.0f) {
                this.field_70180_af.func_187227_b(MOVING, (Object)false);
                this.moveProgress = 0.0f;
                this.lastMoveProgress = 0.0f;
            } else {
                this.moveProgress += 0.05f * (this.func_70689_ay() + 0.05f);
            }
        } else {
            this.lastMoveProgress = 0.0f;
            this.moveProgress = 0.0f;
        }
    }

    public float getPeek() {
        return this.peek;
    }

    public float getHalfMovementProgress(float partialTicks) {
        float movementProgress = this.getMovementProgress(partialTicks);
        float halfProgress = movementProgress < 0.5f ? (0.5f - movementProgress) / 0.5f : (movementProgress - 0.5f) / 0.5f;
        return halfProgress;
    }

    public float getMovementProgress(float partialTicks) {
        return MathHelper.func_76131_a((float)(this.lastMoveProgress + (this.moveProgress - this.lastMoveProgress) * partialTicks), (float)0.0f, (float)1.0f);
    }

    public Vec3d getOffset(float movementProgress) {
        float offsetLength = this.getHalfMovementProgress(1.0f);
        return new Vec3d(this.getFacing().func_176730_m()).func_186678_a((double)this.getPeek() + (double)(this.getFacing().func_176740_k().func_176722_c() ? (float)this.getBlockWidth() - this.field_70130_N : (float)this.getBlockHeight() - this.field_70131_O) / 2.0).func_186678_a((double)offsetLength);
    }

    public int getBlockWidth() {
        return MathHelper.func_76123_f((float)this.field_70130_N);
    }

    public int getBlockHeight() {
        return MathHelper.func_76123_f((float)this.field_70131_O);
    }

    public EnumFacing getFacing() {
        return (EnumFacing)this.field_70180_af.func_187225_a(FACING);
    }

    public EnumFacing getFacingUp() {
        return (EnumFacing)this.field_70180_af.func_187225_a(FACING_UP);
    }

    public BlockPos getAnchor() {
        return (BlockPos)this.field_70180_af.func_187225_a(ANCHOR);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    public Vec3d getCenter() {
        return new Vec3d((Vec3i)this.getAnchor()).func_72441_c((double)this.getBlockWidth() / 2.0, (double)this.getBlockHeight() / 2.0, (double)this.getBlockWidth() / 2.0);
    }

    public Vec3d getFrontCenter() {
        EnumFacing facing = this.getFacing();
        Vec3d center = this.getCenter();
        return center.func_178787_e(this.getOffset(this.getMovementProgress(1.0f))).func_72441_c((double)((float)facing.func_82601_c() * this.field_70130_N / 2.0f), (double)((float)facing.func_96559_d() * this.field_70131_O / 2.0f), (double)((float)facing.func_82599_e() * this.field_70130_N / 2.0f));
    }

    public boolean isAnchored() {
        return (Boolean)this.field_70180_af.func_187225_a(ANCHORED);
    }

    public void setAnchored(boolean anchored) {
        this.field_70180_af.func_187227_b(ANCHORED, (Object)anchored);
        if (anchored) {
            this.field_70180_af.func_187227_b(MOVING, (Object)false);
            this.moveProgress = 0.0f;
            this.lastMoveProgress = 0.0f;
        }
    }

    public EnumFacing[] getFacingForLookDir(Vec3d lookDir) {
        EnumFacing dir = EnumFacing.func_176737_a((float)((float)lookDir.field_72450_a), (float)((float)lookDir.field_72448_b), (float)((float)lookDir.field_72449_c));
        EnumFacing[] facing = new EnumFacing[]{dir, dir == EnumFacing.DOWN || dir == EnumFacing.UP ? EnumFacing.func_176737_a((float)((float)lookDir.field_72450_a), (float)0.0f, (float)((float)lookDir.field_72449_c)) : EnumFacing.UP};
        return facing;
    }

    public void setPositionToAnchor(BlockPos anchor, EnumFacing facing, EnumFacing facingUp) {
        this.field_70180_af.func_187227_b(ANCHOR, (Object)anchor);
        this.field_70180_af.func_187227_b(FACING, (Object)facing);
        this.field_70180_af.func_187227_b(FACING_UP, (Object)facingUp);
        this.field_70180_af.func_187227_b(MOVING, (Object)false);
        this.moveProgress = 0.0f;
        this.lastMoveProgress = 0.0f;
        this.setAnchored(true);
        this.updatePositioning(true);
    }

    public int checkAnchorAt(Vec3d pos, Vec3d lookDir, int checks) {
        EnumFacing[] facing = this.getFacingForLookDir(lookDir);
        BlockPos anchor = new BlockPos(pos.field_72450_a - (double)(this.getBlockWidth() / 2), pos.field_72448_b - (double)(this.getBlockHeight() / 2), pos.field_72449_c - (double)(this.getBlockWidth() / 2));
        return this.checkAnchorAt(anchor, facing[0], facing[1], checks);
    }

    public int checkAnchorAt(BlockPos anchor, EnumFacing facing, EnumFacing facingUp, int checks) {
        int violations;
        block14: {
            int yo;
            BlockPos.MutableBlockPos pos;
            block16: {
                int xo;
                block15: {
                    int zo;
                    violations = 0;
                    if ((checks & 4) != 0 && !this.field_70170_p.func_175647_a(EntityWallFace.class, this.func_174813_aQ().func_186670_a(anchor.func_177973_b((Vec3i)this.getAnchor())).func_72321_a((double)((float)facing.func_82601_c() * this.getPeek()), (double)((float)facing.func_96559_d() * this.getPeek()), (double)((float)facing.func_82599_e() * this.getPeek())), e -> e != this).isEmpty()) {
                        violations |= 4;
                    }
                    pos = new BlockPos.MutableBlockPos();
                    if ((checks & 1) != 0) {
                        block0: for (int xo2 = 0; xo2 < this.getBlockWidth(); ++xo2) {
                            for (int yo2 = 0; yo2 < this.getBlockHeight(); ++yo2) {
                                for (zo = 0; zo < this.getBlockWidth(); ++zo) {
                                    pos.func_181079_c(anchor.func_177958_n() + xo2, anchor.func_177956_o() + yo2, anchor.func_177952_p() + zo);
                                    if (this.canResideInBlock((BlockPos)pos)) continue;
                                    violations |= 1;
                                    break block0;
                                }
                            }
                        }
                    }
                    if ((checks & 2) == 0) break block14;
                    if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) break block15;
                    int y = facing == EnumFacing.UP ? this.getBlockHeight() : -1;
                    for (xo = 0; xo < this.getBlockWidth(); ++xo) {
                        for (zo = 0; zo < this.getBlockWidth(); ++zo) {
                            for (int yo3 = 0; yo3 < MathHelper.func_76123_f((float)this.getPeek()); ++yo3) {
                                pos.func_181079_c(anchor.func_177958_n() + xo, anchor.func_177956_o() + y + facing.func_96559_d() * yo3, anchor.func_177952_p() + zo);
                                if (this.canMoveFaceInto((BlockPos)pos)) continue;
                                violations |= 2;
                                break block14;
                            }
                        }
                    }
                    break block14;
                }
                if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) break block16;
                int z = facing == EnumFacing.NORTH ? -1 : this.getBlockWidth();
                for (xo = 0; xo < this.getBlockWidth(); ++xo) {
                    for (yo = 0; yo < this.getBlockHeight(); ++yo) {
                        for (int zo = 0; zo < MathHelper.func_76123_f((float)this.getPeek()); ++zo) {
                            pos.func_181079_c(anchor.func_177958_n() + xo, anchor.func_177956_o() + yo, anchor.func_177952_p() + z + facing.func_82599_e() * zo);
                            if (this.canMoveFaceInto((BlockPos)pos)) continue;
                            violations |= 2;
                            break block14;
                        }
                    }
                }
                break block14;
            }
            if (facing != EnumFacing.WEST && facing != EnumFacing.EAST) break block14;
            int x = facing == EnumFacing.WEST ? -1 : this.getBlockWidth();
            for (int zo = 0; zo < this.getBlockWidth(); ++zo) {
                for (yo = 0; yo < this.getBlockHeight(); ++yo) {
                    for (int xo = 0; xo < MathHelper.func_76123_f((float)this.getPeek()); ++xo) {
                        pos.func_181079_c(anchor.func_177958_n() + x + facing.func_82601_c() * xo, anchor.func_177956_o() + yo, anchor.func_177952_p() + zo);
                        if (this.canMoveFaceInto((BlockPos)pos)) continue;
                        violations |= 2;
                        break block14;
                    }
                }
            }
        }
        return violations;
    }

    protected int checkAnchorHere(int checks) {
        return this.checkAnchorAt(this.getAnchor(), this.getFacing(), this.getFacingUp(), checks);
    }

    public abstract boolean canResideInBlock(BlockPos var1);

    public abstract boolean canMoveFaceInto(BlockPos var1);

    protected void fixUnsuitablePosition(int violatedChecks) {
    }

    public static class MoveHelper
    extends EntityMoveHelper {
        private final EntityWallFace face;

        private MoveHelper(EntityWallFace entity) {
            super((EntityLiving)entity);
            this.face = entity;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.STRAFE && this.field_188490_g != 0.0f) {
                Vec3i horDir = this.face.getFacing().func_176730_m().func_177955_d(this.face.getFacingUp().func_176730_m());
                int strafeDir = -((int)Math.signum(this.field_188490_g));
                this.face.targetAnchorTimeout = 30 + this.field_75648_a.field_70170_p.field_73012_v.nextInt(30);
                this.face.targetAnchor = this.face.getAnchor().func_177982_a(horDir.func_177958_n() * strafeDir, horDir.func_177956_o() * strafeDir, horDir.func_177952_p() * strafeDir);
                this.setSpeed((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            } else if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.face.targetAnchorTimeout = 30 + this.field_75648_a.field_70170_p.field_73012_v.nextInt(30);
                this.face.targetAnchor = new BlockPos(this.field_75646_b - (double)this.face.getBlockWidth() / 2.0, this.field_75647_c - (double)this.face.getBlockHeight() / 2.0, this.field_75644_d - (double)this.face.getBlockWidth() / 2.0);
                this.setSpeed((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            }
            this.field_188491_h = EntityMoveHelper.Action.WAIT;
        }

        public void setSpeed(double speed) {
            this.face.func_70659_e((float)speed);
        }
    }

    public static final class LookHelper
    extends EntityLookHelper {
        private final EntityWallFace face;
        private int lookingMode = 0;
        private double x;
        private double y;
        private double z;

        private LookHelper(EntityWallFace entity) {
            super((EntityLiving)entity);
            this.face = entity;
        }

        public void func_75651_a(Entity entityIn, float deltaYaw, float deltaPitch) {
            this.x = entityIn.field_70165_t;
            this.y = entityIn instanceof EntityLivingBase ? entityIn.field_70163_u + (double)entityIn.func_70047_e() : (entityIn.func_174813_aQ().field_72338_b + entityIn.func_174813_aQ().field_72337_e) / 2.0;
            this.z = entityIn.field_70161_v;
            this.lookingMode = 1;
        }

        public void func_75650_a(double x, double y, double z, float deltaYaw, float deltaPitch) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.lookingMode = 1;
        }

        public void setLookDirection(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.lookingMode = 2;
        }

        public boolean func_180424_b() {
            return this.lookingMode != 0;
        }

        public double func_180423_e() {
            return this.x;
        }

        public double func_180422_f() {
            return this.y;
        }

        public double func_180421_g() {
            return this.z;
        }

        public void func_75649_a() {
            if (this.lookingMode == 1) {
                Vec3d center = this.face.getCenter();
                EnumFacing[] facing = this.face.getFacingForLookDir(new Vec3d(this.x - center.field_72450_a, this.y - center.field_72448_b, this.z - center.field_72449_c));
                this.face.targetFacingTimeout = 30 + this.face.field_70170_p.field_73012_v.nextInt(30);
                this.face.targetFacing = facing[0];
                this.face.targetFacingUp = facing[1];
            } else if (this.lookingMode == 2) {
                EnumFacing[] facing = this.face.getFacingForLookDir(new Vec3d(this.x, this.y, this.z));
                this.face.targetFacingTimeout = 30 + this.face.field_70170_p.field_73012_v.nextInt(30);
                this.face.targetFacing = facing[0];
                this.face.targetFacingUp = facing[1];
            }
            this.lookingMode = 0;
        }

        public void setSpeed(double speed) {
            this.face.func_70659_e((float)speed);
        }
    }

    public static class AnchorChecks {
        public static final int ANCHOR_BLOCKS = 1;
        public static final int FACE_BLOCKS = 2;
        public static final int ENTITIES = 4;
        public static final int BLOCKS = 3;
        public static final int ALL = 7;
    }
}

