/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.config.remapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.TheBetweenlands;

public abstract class ConfigRemapper
implements Comparable<ConfigRemapper> {
    private static final Map<String, ConfigRemapper> remappers = new HashMap<String, ConfigRemapper>();
    private static final ArtifactVersion NO_VERSION = new ArtifactVersion(){

        public int compareTo(ArtifactVersion other) {
            if (other == this) {
                return 0;
            }
            return 1;
        }

        public String getLabel() {
            return null;
        }

        public String getVersionString() {
            return null;
        }

        public boolean containsVersion(ArtifactVersion source) {
            return false;
        }

        public String getRangeString() {
            return null;
        }
    };
    public final ArtifactVersion acceptedVersions;
    public final ArtifactVersion acceptedVersionsComparator;
    public final String outputVersion;

    public static void register(ConfigRemapper remapper) {
        remappers.put(remapper.getClass().getName(), remapper);
    }

    @Nullable
    public static Pair<Configuration, String> remap(Configuration oldConfig, Configuration newConfig, @Nullable String version) {
        Configuration workingConfig = oldConfig;
        try {
            String workingConfigVersionString = version == null ? "No version" : version;
            ArtifactVersion workingConfigVersion = version == null ? NO_VERSION : ConfigRemapper.parseVersionRangeComparable(version);
            ArrayList<ConfigRemapper> sortedRemappers = new ArrayList<ConfigRemapper>();
            sortedRemappers.addAll(remappers.values());
            Collections.sort(sortedRemappers);
            HashSet<String> propertiesToRemove = new HashSet<String>();
            for (int i = 0; i < sortedRemappers.size(); ++i) {
                boolean remapped = false;
                for (ConfigRemapper remapper : sortedRemappers) {
                    if ((workingConfigVersion != NO_VERSION || remapper.acceptedVersions != NO_VERSION) && !remapper.acceptedVersions.containsVersion(workingConfigVersion)) continue;
                    TheBetweenlands.logger.info(String.format("### Config remapper '%s' (remaps to '%s') accepted config with version '%s'", remapper.getClass().getName(), remapper.outputVersion, workingConfigVersionString));
                    Configuration remappedValues = new Configuration();
                    if (!ConfigRemapper.remapConfig(remapper, workingConfig, remappedValues, propertiesToRemove)) continue;
                    TheBetweenlands.logger.info(String.format("### Remapped config version '%s' to '%s'", workingConfigVersionString, remapper.outputVersion));
                    ConfigRemapper.removeExclusions(remappedValues, propertiesToRemove);
                    workingConfig = ConfigRemapper.mergeRemaps(workingConfig, remappedValues, propertiesToRemove, remapper.outputVersion);
                    workingConfigVersion = ConfigRemapper.parseVersionRangeComparable(remapper.outputVersion);
                    workingConfigVersionString = remapper.outputVersion;
                    remapped = true;
                    break;
                }
                if (!remapped) break;
            }
            if (workingConfig != oldConfig) {
                TheBetweenlands.logger.info(String.format("### Remapped values for config with version '%s':", workingConfigVersionString));
                ConfigRemapper.printConfig(workingConfig);
                Configuration remappedConfig = ConfigRemapper.clear(new Configuration(oldConfig.getConfigFile()));
                TheBetweenlands.logger.info("### Removing properties from remapped config:");
                TreeSet sortedPropertiesToRemove = new TreeSet(propertiesToRemove);
                for (String entry : sortedPropertiesToRemove) {
                    TheBetweenlands.logger.info(entry);
                }
                ConfigRemapper.copy(newConfig, remappedConfig, propertiesToRemove);
                TheBetweenlands.logger.info("### Stripped config:");
                ConfigRemapper.printConfig(remappedConfig);
                TheBetweenlands.logger.info("### Overriding remapped properties");
                if (ConfigRemapper.overrideValues(remappedConfig, workingConfig)) {
                    TheBetweenlands.logger.info("### Remapped config:");
                    ConfigRemapper.printConfig(remappedConfig);
                    return Pair.of((Object)remappedConfig, (Object)workingConfigVersionString);
                }
                TheBetweenlands.logger.info("### No properties were overridden");
            }
            return null;
        }
        catch (Exception ex) {
            TheBetweenlands.logger.warn("### Failed to remap and update the Betweenlands config file", (Throwable)ex);
            return null;
        }
    }

    public static void copy(Configuration source, Configuration target) {
        ConfigRemapper.copy(source, target, Collections.emptySet());
    }

    public static void copy(Configuration source, Configuration target, Set<String> exclusions) {
        ConfigRemapper.traverseConfig(source, sourceCategory -> {
            if (!sourceCategory.getValues().isEmpty()) {
                String categoryName = sourceCategory.getQualifiedName();
                if (exclusions.contains(categoryName)) {
                    return false;
                }
                target.getCategory(categoryName);
                return target.hasCategory(categoryName);
            }
            return false;
        }, (sourceCategory, sourceProperty) -> {
            String categoryName = sourceCategory.getQualifiedName();
            if (!exclusions.contains(categoryName + "/" + sourceProperty.getName())) {
                target.getCategory(categoryName).put(sourceProperty.getName(), sourceProperty);
            }
        });
    }

    public static Configuration clear(Configuration config) {
        for (String category : config.getCategoryNames()) {
            config.removeCategory(config.getCategory(category));
        }
        return config;
    }

    private static void printConfig(Configuration config) {
        TreeMap flattenedStrippedConfig = new TreeMap();
        ConfigRemapper.traverseConfig(config, category -> true, (category, property) -> {
            String key = category.getQualifiedName() + "/" + property.getName();
            String value = property.isList() ? Arrays.toString(property.getStringList()) : property.getString();
            flattenedStrippedConfig.put(key, value);
        });
        for (Map.Entry entry : flattenedStrippedConfig.entrySet()) {
            TheBetweenlands.logger.info((String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }

    private static void traverseConfig(Configuration config, Function<ConfigCategory, Boolean> categoryTraverser, BiConsumer<ConfigCategory, Property> propertyTraverser) {
        for (String categoryName : config.getCategoryNames()) {
            ConfigCategory category = config.getCategory(categoryName);
            ConfigRemapper.traverseCategory(category, categoryTraverser, propertyTraverser);
        }
    }

    private static void traverseCategory(ConfigCategory category, Function<ConfigCategory, Boolean> categoryTraverser, BiConsumer<ConfigCategory, Property> propertyTraverser) {
        if (categoryTraverser.apply(category).booleanValue()) {
            for (Property property : category.getOrderedValues()) {
                propertyTraverser.accept(category, property);
            }
            for (ConfigCategory innerCategory : category.getChildren()) {
                ConfigRemapper.traverseCategory(innerCategory, categoryTraverser, propertyTraverser);
            }
        }
    }

    private static void removeExclusions(Configuration config, Set<String> exclusions) {
        ConfigRemapper.traverseConfig(config, category -> {
            exclusions.remove(category.getQualifiedName());
            return true;
        }, (category, property) -> exclusions.remove(category.getQualifiedName() + "/" + property.getName()));
    }

    private static boolean remapConfig(ConfigRemapper remapper, Configuration inputConfig, Configuration remappedValues, Set<String> remappedProperties) {
        AtomicBoolean ret = new AtomicBoolean(false);
        ConfigRemapper.traverseConfig(inputConfig, category -> true, (category, property) -> {
            String categoryName = category.getQualifiedName();
            if (remapper.remap(categoryName, (Property)property, remappedValues)) {
                remappedProperties.add(categoryName);
                remappedProperties.add(categoryName + "/" + property.getName());
                ret.set(true);
                TheBetweenlands.logger.info(String.format("Remapped property '%s'", categoryName + "/" + property.getName()));
            }
        });
        return ret.get();
    }

    private static Configuration mergeRemaps(Configuration inputConfig, Configuration remappedValues, Set<String> remappedProperties, String newVersion) {
        Configuration newConfig = new Configuration();
        ConfigRemapper.copy(inputConfig, newConfig, remappedProperties);
        ConfigRemapper.copy(remappedValues, newConfig, Collections.emptySet());
        return newConfig;
    }

    private static boolean overrideValues(Configuration config, Configuration remappedValues) {
        AtomicBoolean ret = new AtomicBoolean(false);
        HashMap flattenedRemappedValues = new HashMap();
        ConfigRemapper.traverseConfig(remappedValues, remappedCategory -> true, (remappedCategory, remappedProperty) -> flattenedRemappedValues.put(remappedCategory.getQualifiedName() + "/" + remappedProperty.getName(), remappedProperty));
        ConfigRemapper.traverseConfig(config, category -> true, (category, property) -> {
            Property remappedProperty = (Property)flattenedRemappedValues.get(category.getQualifiedName() + "/" + property.getName());
            if (remappedProperty != null && remappedProperty.isList() == property.isList()) {
                if (property.isList()) {
                    property.set(remappedProperty.getStringList());
                } else {
                    property.set(remappedProperty.getString());
                }
                ret.set(true);
            }
        });
        return ret.get();
    }

    private static ArtifactVersion parseVersionRangeSpec(String version) throws InvalidVersionSpecificationException {
        return new DefaultArtifactVersion(null, VersionRange.createFromVersionSpec((String)version));
    }

    private static ArtifactVersion parseVersionRangeComparable(String version) {
        return new DefaultArtifactVersion(version);
    }

    public ConfigRemapper(@Nullable String acceptedVersions, String outputVersion) {
        try {
            this.acceptedVersions = acceptedVersions == null ? NO_VERSION : ConfigRemapper.parseVersionRangeSpec(acceptedVersions);
        }
        catch (InvalidVersionSpecificationException ex) {
            throw new RuntimeException(ex);
        }
        this.acceptedVersionsComparator = acceptedVersions == null ? NO_VERSION : ConfigRemapper.parseVersionRangeComparable(acceptedVersions);
        this.outputVersion = outputVersion;
    }

    public abstract boolean remap(String var1, Property var2, Configuration var3);

    @Override
    public int compareTo(ConfigRemapper other) {
        if (this.acceptedVersionsComparator == NO_VERSION && other.acceptedVersionsComparator == NO_VERSION) {
            return 0;
        }
        if (this.acceptedVersionsComparator == NO_VERSION) {
            return -1;
        }
        if (other.acceptedVersionsComparator == NO_VERSION) {
            return 1;
        }
        return this.acceptedVersionsComparator.compareTo((Object)other.acceptedVersionsComparator);
    }
}

