/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.tile.ModelPurifier;
import thebetweenlands.common.block.container.BlockPurifier;
import thebetweenlands.common.tile.TileEntityPurifier;
import thebetweenlands.util.StatePropertyHelper;

@SideOnly(value=Side.CLIENT)
public class RenderPurifier
extends TileEntitySpecialRenderer<TileEntityPurifier> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/purifier.png");
    public static final ModelPurifier MODEL = new ModelPurifier();
    private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    public void render(TileEntityPurifier tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.func_147499_a(TEXTURE);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (tile == null || !tile.func_145830_o()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            MODEL.renderAll();
            GlStateManager.func_179121_F();
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        int rotation = StatePropertyHelper.getStatePropertySafely(tile, BlockPurifier.class, BlockPurifier.FACING, EnumFacing.NORTH).func_176736_b() * 90;
        GlStateManager.func_179114_b((float)(rotation - 180), (float)0.0f, (float)1.0f, (float)0.0f);
        MODEL.renderAll();
        if (tile.isPurifying() && tile.lightOn) {
            MODEL.renderFirePlate();
        }
        GlStateManager.func_179121_F();
        int amount = tile.waterTank.getFluidAmount();
        int capacity = tile.waterTank.getCapacity();
        float size = 1.0f / (float)capacity * (float)amount;
        if (!tile.func_70301_a(2).func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.27), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            int items = tile.func_70301_a(2).func_190916_E() / 4 + 1;
            Random rand = new Random(tile.func_174877_v().func_177986_g());
            for (int i = 0; i < items; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)rand.nextFloat() / 3.0 - 0.16666666666666666), (double)-0.25, (double)((double)rand.nextFloat() / 3.0 - 0.16666666666666666));
                GlStateManager.func_179114_b((float)(rand.nextFloat() * 30.0f - 15.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(rand.nextFloat() * 30.0f - 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)0.15f, (float)0.15f, (float)0.15f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(rand.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                ItemStack stack = tile.func_70301_a(2);
                this.renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
        if (amount >= 100) {
            Tessellator tesselator = Tessellator.func_178181_a();
            BufferBuilder buffer = tesselator.func_178180_c();
            TextureAtlasSprite waterIcon = Minecraft.func_71410_x().func_147117_R().func_110572_b("thebetweenlands:fluids/swamp_water_still");
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            float translationX = (float)x + 0.0f;
            float translationY = (float)(y + (double)0.35f + (double)(size * 0.5f));
            float translationZ = (float)z + 0.0f;
            buffer.func_178969_c((double)translationX, (double)translationY, (double)translationZ);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)0.1f, 0.0, (double)0.1f).func_187315_a((double)waterIcon.func_94209_e(), (double)waterIcon.func_94206_g()).func_181666_a(0.2f, 0.6f, 0.4f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)0.1f, 0.0, (double)0.9f).func_187315_a((double)waterIcon.func_94209_e(), (double)waterIcon.func_94210_h()).func_181666_a(0.2f, 0.6f, 0.4f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)0.9f, 0.0, (double)0.9f).func_187315_a((double)waterIcon.func_94212_f(), (double)waterIcon.func_94210_h()).func_181666_a(0.2f, 0.6f, 0.4f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)0.9f, 0.0, (double)0.1f).func_187315_a((double)waterIcon.func_94212_f(), (double)waterIcon.func_94206_g()).func_181666_a(0.2f, 0.6f, 0.4f, 1.0f).func_181675_d();
            tesselator.func_78381_a();
            buffer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }
}

