/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sky;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.util.glu.Sphere;
import thebetweenlands.api.sky.IRiftMaskRenderer;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.sky.RiftVariant;
import thebetweenlands.common.world.event.EventRift;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class RiftMaskRenderer
implements IRiftMaskRenderer {
    public static final ResourceLocation SKY_RIFT_MASK_BACK_TEXTURE = new ResourceLocation("thebetweenlands:textures/sky/rifts/sky_rift_mask_back.png");
    protected final int skyDomeDispList;
    private Sphere projectionSphere = new Sphere();

    public RiftMaskRenderer(int skyDomeDispList) {
        this.skyDomeDispList = skyDomeDispList;
        this.projectionSphere.setTextureFlag(false);
    }

    @Override
    public void renderMask(float partialTicks, WorldClient world, Minecraft mc, float skyBrightness) {
        TextureManager textureManager = mc.func_110434_K();
        EventRift rift = BetweenlandsWorldStorage.forWorld((World)world).getEnvironmentEventRegistry().rift;
        float[] riftAngles = rift.getRiftAngles(partialTicks);
        float scale = rift.getRiftScale(partialTicks);
        RiftVariant variant = rift.getVariant();
        textureManager.func_110577_a(SKY_RIFT_MASK_BACK_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)riftAngles[0], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)riftAngles[1], (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)riftAngles[2], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        GlStateManager.func_179148_o((int)this.skyDomeDispList);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        textureManager.func_110577_a(variant.getMaskTexture());
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)33071.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)33071.0f);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        int mirrorU = rift.getRiftMirrorU() ? -1 : 1;
        int mirrorV = rift.getRiftMirrorV() ? -1 : 1;
        GlStateManager.func_179109_b((float)((float)mirrorU * -0.5f / scale), (float)((float)mirrorV * -0.5f / scale), (float)0.0f);
        GlStateManager.func_179152_a((float)((float)mirrorU / scale), (float)((float)mirrorV / scale), (float)1.0f);
        GlStateManager.func_179109_b((float)((float)mirrorU * 0.5f * scale), (float)((float)mirrorV * 0.5f * scale), (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)riftAngles[0], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)riftAngles[1], (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)riftAngles[2], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179148_o((int)this.skyDomeDispList);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
    }

    @Override
    public void renderOverlay(float partialTicks, WorldClient world, Minecraft mc, float skyBrightness) {
        TextureManager textureManager = mc.func_110434_K();
        EventRift rift = BetweenlandsWorldStorage.forWorld((World)world).getEnvironmentEventRegistry().rift;
        float[] riftAngles = rift.getRiftAngles(partialTicks);
        float visibility = rift.getVisibility(partialTicks);
        float scale = rift.getRiftScale(partialTicks);
        RiftVariant variant = rift.getVariant();
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        int mirrorU = rift.getRiftMirrorU() ? -1 : 1;
        int mirrorV = rift.getRiftMirrorV() ? -1 : 1;
        GlStateManager.func_179109_b((float)((float)mirrorU * -0.5f / scale), (float)((float)mirrorV * -0.5f / scale), (float)0.0f);
        GlStateManager.func_179152_a((float)((float)mirrorU / scale), (float)((float)mirrorV / scale), (float)1.0f);
        GlStateManager.func_179109_b((float)((float)mirrorU * 0.5f * scale), (float)((float)mirrorV * 0.5f * scale), (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)riftAngles[0], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)riftAngles[1], (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)riftAngles[2], (float)0.0f, (float)1.0f, (float)0.0f);
        if (variant.getAltOverlayTexture() != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(visibility * skyBrightness));
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)visibility);
        }
        textureManager.func_110577_a(variant.getOverlayTexture());
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)33071.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)33071.0f);
        GlStateManager.func_179148_o((int)this.skyDomeDispList);
        if (variant.getAltOverlayTexture() != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(visibility * (1.0f - skyBrightness)));
            textureManager.func_110577_a(variant.getAltOverlayTexture());
            GlStateManager.func_187403_b((int)3553, (int)10242, (float)33071.0f);
            GlStateManager.func_187403_b((int)3553, (int)10243, (float)33071.0f);
            GlStateManager.func_179148_o((int)this.skyDomeDispList);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        textureManager.func_110577_a(variant.getOverlayTexture());
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
        if (variant.getAltOverlayTexture() != null) {
            textureManager.func_110577_a(variant.getAltOverlayTexture());
            GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
            GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
        }
    }

    @Override
    public void renderRiftProjection(float partialTicks, WorldClient world, Minecraft mc, float skyBrightness) {
        EventRift rift = BetweenlandsWorldStorage.forWorld((World)world).getEnvironmentEventRegistry().rift;
        float visibility = rift.getVisibility(partialTicks);
        float visibilitySq = visibility * visibility;
        GlStateManager.func_179131_c((float)visibilitySq, (float)visibilitySq, (float)visibilitySq, (float)visibility);
        GlStateManager.func_179127_m();
        GlStateManager.func_179102_b((float)(FogHandler.getCurrentFogStart() / 2.0f));
        GlStateManager.func_179153_c((float)(FogHandler.getCurrentFogEnd() / 2.0f));
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        this.projectionSphere.draw(55.0f, 8, 8);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
    }
}

