/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BatchedParticleRenderer {
    public static final BatchedParticleRenderer INSTANCE = new BatchedParticleRenderer();
    private final List<ParticleBatch> batches = new ArrayList<ParticleBatch>();
    private final List<ParticleBatch> renderedBatches = new ArrayList<ParticleBatch>();

    private BatchedParticleRenderer() {
    }

    public ParticleBatch registerBatchType(ParticleBatchType type) {
        return this.registerBatchType(type, true);
    }

    public ParticleBatch registerBatchType(ParticleBatchType type, boolean render) {
        ParticleBatch batch = new ParticleBatch(type);
        this.batches.add(batch);
        if (render) {
            this.renderedBatches.add(batch);
            Collections.sort(this.renderedBatches);
        }
        return batch;
    }

    public boolean addParticle(ParticleBatch batch, Particle particle) {
        if (batch.type.filter(particle)) {
            batch.queue.add(particle);
            return true;
        }
        return false;
    }

    public void update() {
        for (ParticleBatch batch : this.batches) {
            Particle particle;
            Iterator it = batch.particles.iterator();
            while (it.hasNext()) {
                particle = (Particle)it.next();
                particle.func_189213_a();
                if (particle.func_187113_k()) continue;
                it.remove();
            }
            if (batch.queue.isEmpty()) continue;
            particle = (Particle)batch.queue.poll();
            while (particle != null) {
                if (batch.particles.size() >= batch.type.maxParticles()) {
                    batch.particles.removeFirst();
                }
                batch.particles.add(particle);
                particle = (Particle)batch.queue.poll();
            }
        }
    }

    public void renderAll(Entity entity, float partialTicks) {
        for (ParticleBatch batch : this.renderedBatches) {
            this.renderBatch(batch, entity, partialTicks);
        }
    }

    public void renderBatch(ParticleBatch batch, Entity entity, float partialTicks) {
        this.renderBatchType(batch.type, batch.particles, entity, partialTicks);
    }

    public void renderBatchType(ParticleBatchType batchType, Collection<Particle> particles, Entity entity, float partialTicks) {
        if (!particles.isEmpty()) {
            float rx = ActiveRenderInfo.func_178808_b();
            float rz = ActiveRenderInfo.func_178803_d();
            float ryz = ActiveRenderInfo.func_178805_e();
            float rxy = ActiveRenderInfo.func_178807_f();
            float rxz = ActiveRenderInfo.func_178809_c();
            Particle.field_70556_an = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            Particle.field_70554_ao = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            Particle.field_70555_ap = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            Particle.field_190016_K = entity.func_70676_i(partialTicks);
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.004f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            final int batchSize = batchType.batchSize();
            int batches = particles.size() / batchSize + 1;
            final Iterator<Particle> it = particles.iterator();
            for (int i = 0; i < batches; ++i) {
                Iterable<Particle> batchView = new Iterable<Particle>(){
                    private int counter = 0;

                    @Override
                    public Iterator<Particle> iterator() {
                        return new Iterator<Particle>(){

                            @Override
                            public boolean hasNext() {
                                return counter < batchSize && it.hasNext();
                            }

                            @Override
                            public Particle next() {
                                counter++;
                                return (Particle)it.next();
                            }
                        };
                    }
                };
                batchType.preRender(tessellator, entity, partialTicks, rx, rxz, rz, ryz, rxy);
                batchType.render(batchView, tessellator, entity, partialTicks, rx, rxz, rz, ryz, rxy);
                batchType.postRender(tessellator, entity, partialTicks, rx, rxz, rz, ryz, rxy);
            }
            GlStateManager.func_179126_j();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
        }
    }

    public static final class ParticleBatch
    implements Comparable<ParticleBatch> {
        private final ParticleBatchType type;
        private final Queue<Particle> queue = new ArrayDeque<Particle>();
        private final Deque<Particle> particles = new ArrayDeque<Particle>();

        private ParticleBatch(ParticleBatchType type) {
            this.type = type;
        }

        public ParticleBatchType type() {
            return this.type;
        }

        public Collection<Particle> getParticles() {
            return Collections.unmodifiableCollection(this.particles);
        }

        public boolean isEmpty() {
            return this.particles.isEmpty();
        }

        @Override
        public int compareTo(ParticleBatch other) {
            return Integer.compare(this.type.priority(), other.type.priority());
        }
    }

    public static class ParticleBatchType {
        public int priority() {
            return 0;
        }

        public int maxParticles() {
            return 8192;
        }

        public int batchSize() {
            return this.maxParticles();
        }

        public boolean filter(Particle particle) {
            return true;
        }

        protected void render(Iterable<Particle> particles, Tessellator tessellator, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            BufferBuilder buffer = tessellator.func_178180_c();
            for (Particle particle : particles) {
                particle.func_180434_a(buffer, entity, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            }
        }

        protected void preRender(Tessellator tessellator, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }

        protected void postRender(Tessellator tessellator, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            tessellator.func_78381_a();
        }
    }
}

