/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.block;

import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IsolatedBlockModelRenderer {
    private OcclusionCuller culler;
    private AmbientOcclusionProvider ao;
    private LightingProvider lighting;
    private TintProvider tint;
    private boolean useRandomOffsets = true;

    public IsolatedBlockModelRenderer setOcclusionCuller(OcclusionCuller culler) {
        this.culler = culler;
        return this;
    }

    public IsolatedBlockModelRenderer setAmbientOcclusion(AmbientOcclusionProvider ao) {
        this.ao = ao;
        return this;
    }

    public IsolatedBlockModelRenderer setLighting(LightingProvider lighting) {
        this.lighting = lighting;
        return this;
    }

    public IsolatedBlockModelRenderer setTint(TintProvider tint) {
        this.tint = tint;
        return this;
    }

    public IsolatedBlockModelRenderer setUseRandomOffsets(boolean useRandomOffsets) {
        this.useRandomOffsets = useRandomOffsets;
        return this;
    }

    public boolean renderModel(BlockPos pos, IBakedModel model, IBlockState state, long rand, BufferBuilder buffer) {
        boolean useAO = Minecraft.func_71379_u() && state.func_185906_d() == 0 && model.func_177555_b() && this.ao != null;
        try {
            return useAO ? this.renderModelSmooth(pos, model, state, buffer, rand) : this.renderModelFlat(pos, model, state, buffer, rand);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (IBlockState)state);
            crashreportcategory.func_71507_a("Using AO", (Object)useAO);
            throw new ReportedException(crashreport);
        }
    }

    private boolean renderModelSmooth(BlockPos pos, IBakedModel model, IBlockState state, BufferBuilder buffer, long rand) {
        boolean flag = false;
        float[] blockBounds = new float[EnumFacing.field_82609_l.length * 2];
        BitSet bitset = new BitSet(3);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            List list = model.func_188616_a(state, facing, rand);
            if (list.isEmpty() || this.culler != null && !this.culler.shouldSideBeRendered(state, facing)) continue;
            this.renderQuadsSmooth(pos, state, buffer, list, blockBounds, bitset);
            flag = true;
        }
        return flag;
    }

    private boolean renderModelFlat(BlockPos pos, IBakedModel model, IBlockState state, BufferBuilder buffer, long rand) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            List list = model.func_188616_a(state, facing, rand);
            if (list.isEmpty() || this.culler != null && !this.culler.shouldSideBeRendered(state, facing)) continue;
            int i = this.lighting != null ? this.lighting.getPackedLightmapCoords(state, facing) : 0;
            this.renderQuadsFlat(state, pos, i, false, buffer, list, bitset, this.lighting);
            flag = true;
        }
        return flag;
    }

    private void renderQuadsSmooth(BlockPos pos, IBlockState state, BufferBuilder vertexBuffer, List<BakedQuad> quads, float[] blockBounds, BitSet blockBoundsState) {
        double blockX = 0.0;
        double blockY = 0.0;
        double blockZ = 0.0;
        Block block = state.func_177230_c();
        Block.EnumOffsetType offsetType = block.func_176218_Q();
        if (this.useRandomOffsets && offsetType != Block.EnumOffsetType.NONE) {
            long posRand = MathHelper.func_180186_a((Vec3i)pos);
            blockX += ((double)((float)(posRand >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            blockZ += ((double)((float)(posRand >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (offsetType == Block.EnumOffsetType.XYZ) {
                blockY += ((double)((float)(posRand >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        int j = quads.size();
        for (int l = 0; l < j; ++l) {
            BakedQuad bakedQuad = quads.get(l);
            this.fillQuadBounds(state, bakedQuad.func_178209_a(), bakedQuad.func_178210_d(), blockBounds, blockBoundsState);
            AmbientOcclusionFace aoFace = null;
            if (this.ao != null) {
                aoFace = this.ao.getAmbientOcclusion(state, bakedQuad.func_178210_d(), blockBounds, blockBoundsState);
            }
            if (aoFace == null) {
                aoFace = new AmbientOcclusionFace();
            }
            vertexBuffer.func_178981_a(bakedQuad.func_178209_a());
            vertexBuffer.func_178962_a(aoFace.vertexBrightness[0], aoFace.vertexBrightness[1], aoFace.vertexBrightness[2], aoFace.vertexBrightness[3]);
            if (bakedQuad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedQuad.func_178210_d());
                aoFace.vertexColorMultiplier[0] = aoFace.vertexColorMultiplier[0] * diffuse;
                aoFace.vertexColorMultiplier[1] = aoFace.vertexColorMultiplier[1] * diffuse;
                aoFace.vertexColorMultiplier[2] = aoFace.vertexColorMultiplier[2] * diffuse;
                aoFace.vertexColorMultiplier[3] = aoFace.vertexColorMultiplier[3] * diffuse;
            }
            if (bakedQuad.func_178212_b()) {
                int tint;
                int n = tint = this.tint != null ? this.tint.getBlockTint(state, bakedQuad.func_178211_c()) : 0xFFFFFF;
                if (EntityRenderer.field_78517_a) {
                    tint = TextureUtil.func_177054_c((int)tint);
                }
                float tintRed = (float)(tint >> 16 & 0xFF) / 255.0f;
                float tintGreen = (float)(tint >> 8 & 0xFF) / 255.0f;
                float tintBlue = (float)(tint & 0xFF) / 255.0f;
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[0] * tintRed, aoFace.vertexColorMultiplier[0] * tintGreen, aoFace.vertexColorMultiplier[0] * tintBlue, 4);
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[1] * tintRed, aoFace.vertexColorMultiplier[1] * tintGreen, aoFace.vertexColorMultiplier[1] * tintBlue, 3);
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[2] * tintRed, aoFace.vertexColorMultiplier[2] * tintGreen, aoFace.vertexColorMultiplier[2] * tintBlue, 2);
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[3] * tintRed, aoFace.vertexColorMultiplier[3] * tintGreen, aoFace.vertexColorMultiplier[3] * tintBlue, 1);
            } else {
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], 4);
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], 3);
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], 2);
                vertexBuffer.func_178978_a(aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], 1);
            }
            vertexBuffer.func_178987_a(blockX, blockY, blockZ);
        }
    }

    private void renderQuadsFlat(IBlockState state, BlockPos pos, int brightness, boolean updateBrightness, BufferBuilder vertexBuffer, List<BakedQuad> quads, BitSet blockBoundsState, @Nullable LightingProvider lighting) {
        double blockX = 0.0;
        double blockY = 0.0;
        double blockZ = 0.0;
        Block block = state.func_177230_c();
        Block.EnumOffsetType offsetType = block.func_176218_Q();
        if (this.useRandomOffsets && offsetType != Block.EnumOffsetType.NONE) {
            int randX = pos.func_177958_n();
            int randZ = pos.func_177952_p();
            long posRand = (long)(randX * 3129871) ^ (long)randZ * 116129781L;
            posRand = posRand * posRand * 42317861L + posRand * 11L;
            blockX += ((double)((float)(posRand >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            blockZ += ((double)((float)(posRand >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
            if (offsetType == Block.EnumOffsetType.XYZ) {
                blockY += ((double)((float)(posRand >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            }
        }
        int i1 = quads.size();
        for (int l = 0; l < i1; ++l) {
            BakedQuad bakedQuad = quads.get(l);
            if (updateBrightness) {
                this.fillQuadBounds(state, bakedQuad.func_178209_a(), bakedQuad.func_178210_d(), null, blockBoundsState);
                brightness = lighting.getPackedLightmapCoords(state, blockBoundsState.get(0) ? bakedQuad.func_178210_d() : null);
            }
            vertexBuffer.func_178981_a(bakedQuad.func_178209_a());
            vertexBuffer.func_178962_a(brightness, brightness, brightness, brightness);
            if (bakedQuad.func_178212_b()) {
                int tint;
                int n = tint = this.tint != null ? this.tint.getBlockTint(state, bakedQuad.func_178211_c()) : 0xFFFFFF;
                if (EntityRenderer.field_78517_a) {
                    tint = TextureUtil.func_177054_c((int)tint);
                }
                float tintRed = (float)(tint >> 16 & 0xFF) / 255.0f;
                float tintGreen = (float)(tint >> 8 & 0xFF) / 255.0f;
                float tintBlue = (float)(tint & 0xFF) / 255.0f;
                if (bakedQuad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((EnumFacing)bakedQuad.func_178210_d());
                    tintRed *= diffuse;
                    tintGreen *= diffuse;
                    tintBlue *= diffuse;
                }
                vertexBuffer.func_178978_a(tintRed, tintGreen, tintBlue, 4);
                vertexBuffer.func_178978_a(tintRed, tintGreen, tintBlue, 3);
                vertexBuffer.func_178978_a(tintRed, tintGreen, tintBlue, 2);
                vertexBuffer.func_178978_a(tintRed, tintGreen, tintBlue, 1);
            } else if (bakedQuad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedQuad.func_178210_d());
                vertexBuffer.func_178978_a(diffuse, diffuse, diffuse, 4);
                vertexBuffer.func_178978_a(diffuse, diffuse, diffuse, 3);
                vertexBuffer.func_178978_a(diffuse, diffuse, diffuse, 2);
                vertexBuffer.func_178978_a(diffuse, diffuse, diffuse, 1);
            }
            vertexBuffer.func_178987_a(blockX, blockY, blockZ);
        }
    }

    private void fillQuadBounds(IBlockState state, int[] vertexData, EnumFacing facing, @Nullable float[] blockBounds, BitSet blockBoundsState) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (blockBounds != null) {
            blockBounds[EnumFacing.WEST.func_176745_a()] = f;
            blockBounds[EnumFacing.EAST.func_176745_a()] = f3;
            blockBounds[EnumFacing.DOWN.func_176745_a()] = f1;
            blockBounds[EnumFacing.UP.func_176745_a()] = f4;
            blockBounds[EnumFacing.NORTH.func_176745_a()] = f2;
            blockBounds[EnumFacing.SOUTH.func_176745_a()] = f5;
            blockBounds[EnumFacing.WEST.func_176745_a() + EnumFacing.field_82609_l.length] = 1.0f - f;
            blockBounds[EnumFacing.EAST.func_176745_a() + EnumFacing.field_82609_l.length] = 1.0f - f3;
            blockBounds[EnumFacing.DOWN.func_176745_a() + EnumFacing.field_82609_l.length] = 1.0f - f1;
            blockBounds[EnumFacing.UP.func_176745_a() + EnumFacing.field_82609_l.length] = 1.0f - f4;
            blockBounds[EnumFacing.NORTH.func_176745_a() + EnumFacing.field_82609_l.length] = 1.0f - f2;
            blockBounds[EnumFacing.SOUTH.func_176745_a() + EnumFacing.field_82609_l.length] = 1.0f - f5;
        }
        switch (facing) {
            case DOWN: {
                blockBoundsState.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                blockBoundsState.set(0, (f1 < 1.0E-4f || state.func_185917_h()) && f1 == f4);
                break;
            }
            case UP: {
                blockBoundsState.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                blockBoundsState.set(0, (f4 > 0.9999f || state.func_185917_h()) && f1 == f4);
                break;
            }
            case NORTH: {
                blockBoundsState.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                blockBoundsState.set(0, (f2 < 1.0E-4f || state.func_185917_h()) && f2 == f5);
                break;
            }
            case SOUTH: {
                blockBoundsState.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                blockBoundsState.set(0, (f5 > 0.9999f || state.func_185917_h()) && f2 == f5);
                break;
            }
            case WEST: {
                blockBoundsState.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                blockBoundsState.set(0, (f < 1.0E-4f || state.func_185917_h()) && f == f3);
                break;
            }
            case EAST: {
                blockBoundsState.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                blockBoundsState.set(0, (f3 > 0.9999f || state.func_185917_h()) && f == f3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int vert0;
        private final int vert1;
        private final int vert2;
        private final int vert3;
        private static final VertexTranslations[] VALUES;

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.vert0 = p_i46234_3_;
            this.vert1 = p_i46234_4_;
            this.vert2 = p_i46234_5_;
            this.vert3 = p_i46234_6_;
        }

        public static VertexTranslations getVertexTranslations(EnumFacing p_178184_0_) {
            return VALUES[p_178184_0_.func_176745_a()];
        }

        static {
            VALUES = new VertexTranslations[6];
            VertexTranslations.VALUES[EnumFacing.DOWN.func_176745_a()] = DOWN;
            VertexTranslations.VALUES[EnumFacing.UP.func_176745_a()] = UP;
            VertexTranslations.VALUES[EnumFacing.NORTH.func_176745_a()] = NORTH;
            VertexTranslations.VALUES[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
            VertexTranslations.VALUES[EnumFacing.WEST.func_176745_a()] = WEST;
            VertexTranslations.VALUES[EnumFacing.EAST.func_176745_a()] = EAST;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Orientation {
        DOWN(EnumFacing.DOWN, false),
        UP(EnumFacing.UP, false),
        NORTH(EnumFacing.NORTH, false),
        SOUTH(EnumFacing.SOUTH, false),
        WEST(EnumFacing.WEST, false),
        EAST(EnumFacing.EAST, false),
        FLIP_DOWN(EnumFacing.DOWN, true),
        FLIP_UP(EnumFacing.UP, true),
        FLIP_NORTH(EnumFacing.NORTH, true),
        FLIP_SOUTH(EnumFacing.SOUTH, true),
        FLIP_WEST(EnumFacing.WEST, true),
        FLIP_EAST(EnumFacing.EAST, true);

        private final int shape;

        private Orientation(EnumFacing p_i46233_3_, boolean p_i46233_4_) {
            this.shape = p_i46233_3_.func_176745_a() + (p_i46233_4_ ? EnumFacing.field_82609_l.length : 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum EnumNeighborInfo {
        DOWN(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final EnumFacing[] corners;
        private final float shadeWeight;
        private final boolean doNonCubicWeight;
        private final Orientation[] vert0Weights;
        private final Orientation[] vert1Weights;
        private final Orientation[] vert2Weights;
        private final Orientation[] vert3Weights;
        private static final EnumNeighborInfo[] VALUES;

        private EnumNeighborInfo(EnumFacing[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.corners = p_i46236_3_;
            this.shadeWeight = p_i46236_4_;
            this.doNonCubicWeight = p_i46236_5_;
            this.vert0Weights = p_i46236_6_;
            this.vert1Weights = p_i46236_7_;
            this.vert2Weights = p_i46236_8_;
            this.vert3Weights = p_i46236_9_;
        }

        public static EnumNeighborInfo getNeighbourInfo(EnumFacing p_178273_0_) {
            return VALUES[p_178273_0_.func_176745_a()];
        }

        static {
            VALUES = new EnumNeighborInfo[6];
            EnumNeighborInfo.VALUES[EnumFacing.DOWN.func_176745_a()] = DOWN;
            EnumNeighborInfo.VALUES[EnumFacing.UP.func_176745_a()] = UP;
            EnumNeighborInfo.VALUES[EnumFacing.NORTH.func_176745_a()] = NORTH;
            EnumNeighborInfo.VALUES[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
            EnumNeighborInfo.VALUES[EnumFacing.WEST.func_176745_a()] = WEST;
            EnumNeighborInfo.VALUES[EnumFacing.EAST.func_176745_a()] = EAST;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class AmbientOcclusionFace {
        protected final float[] vertexColorMultiplier = new float[4];
        protected final int[] vertexBrightness = new int[4];

        public void updateVertexBrightness(IBlockAccess worldIn, IBlockState state, BlockPos centerPos, EnumFacing direction, float[] faceShape, BitSet shapeState) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            BlockPos blockpos = shapeState.get(0) ? centerPos.func_177972_a(direction) : centerPos;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
            EnumNeighborInfo blockmodelrenderer$enumneighborinfo = EnumNeighborInfo.getNeighbourInfo(direction);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.func_185342_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[0]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.func_185342_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[1]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos3 = BlockPos.PooledMutableBlockPos.func_185342_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[2]);
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos4 = BlockPos.PooledMutableBlockPos.func_185342_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[3]);
            int i = state.func_185889_a(worldIn, (BlockPos)blockpos$pooledmutableblockpos1);
            int j = state.func_185889_a(worldIn, (BlockPos)blockpos$pooledmutableblockpos2);
            int k = state.func_185889_a(worldIn, (BlockPos)blockpos$pooledmutableblockpos3);
            int l = state.func_185889_a(worldIn, (BlockPos)blockpos$pooledmutableblockpos4);
            float f = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos1).func_185892_j();
            float f1 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos2).func_185892_j();
            float f2 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos3).func_185892_j();
            float f3 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos4).func_185892_j();
            boolean flag = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos1).func_189536_c(direction)).func_185895_e();
            boolean flag1 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos2).func_189536_c(direction)).func_185895_e();
            boolean flag2 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos3).func_189536_c(direction)).func_185895_e();
            boolean flag3 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos4).func_189536_c(direction)).func_185895_e();
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos1 = blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos1).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[2]);
                f4 = worldIn.func_180495_p((BlockPos)blockpos1).func_185892_j();
                i1 = state.func_185889_a(worldIn, (BlockPos)blockpos1);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                BlockPos.PooledMutableBlockPos blockpos2 = blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos1).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[3]);
                f5 = worldIn.func_180495_p((BlockPos)blockpos2).func_185892_j();
                j1 = state.func_185889_a(worldIn, (BlockPos)blockpos2);
            }
            if (!flag2 && !flag1) {
                f6 = f1;
                k1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos3 = blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos2).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[2]);
                f6 = worldIn.func_180495_p((BlockPos)blockpos3).func_185892_j();
                k1 = state.func_185889_a(worldIn, (BlockPos)blockpos3);
            }
            if (!flag3 && !flag1) {
                f7 = f1;
                l1 = j;
            } else {
                BlockPos.PooledMutableBlockPos blockpos4 = blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos$pooledmutableblockpos2).func_189536_c(blockmodelrenderer$enumneighborinfo.corners[3]);
                f7 = worldIn.func_180495_p((BlockPos)blockpos4).func_185892_j();
                l1 = state.func_185889_a(worldIn, (BlockPos)blockpos4);
            }
            int i3 = state.func_185889_a(worldIn, centerPos);
            if (shapeState.get(0) || !worldIn.func_180495_p(centerPos.func_177972_a(direction)).func_185914_p()) {
                i3 = state.func_185889_a(worldIn, centerPos.func_177972_a(direction));
            }
            float f8 = shapeState.get(0) ? worldIn.func_180495_p(blockpos).func_185892_j() : worldIn.func_180495_p(centerPos).func_185892_j();
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.getVertexTranslations(direction);
            blockpos$pooledmutableblockpos.func_185344_t();
            blockpos$pooledmutableblockpos1.func_185344_t();
            blockpos$pooledmutableblockpos2.func_185344_t();
            blockpos$pooledmutableblockpos3.func_185344_t();
            blockpos$pooledmutableblockpos4.func_185344_t();
            if (shapeState.get(1) && blockmodelrenderer$enumneighborinfo.doNonCubicWeight) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[1].shape];
                float f14 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[3].shape];
                float f15 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[5].shape];
                float f16 = faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert0Weights[7].shape];
                float f17 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[1].shape];
                float f18 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[3].shape];
                float f19 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[5].shape];
                float f20 = faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert1Weights[7].shape];
                float f21 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[1].shape];
                float f22 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[3].shape];
                float f23 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[5].shape];
                float f24 = faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert2Weights[7].shape];
                float f25 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[0].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[1].shape];
                float f26 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[2].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[3].shape];
                float f27 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[4].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[5].shape];
                float f28 = faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[6].shape] * faceShape[blockmodelrenderer$enumneighborinfo.vert3Weights[7].shape];
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int i2 = this.getAoBrightness(l, i, j1, i3);
                int j2 = this.getAoBrightness(k, i, i1, i3);
                int k2 = this.getAoBrightness(k, j, k1, i3);
                int l2 = this.getAoBrightness(l, j, l1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = this.getVertexBrightness(i2, j2, k2, l2, f13, f14, f15, f16);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = this.getVertexBrightness(i2, j2, k2, l2, f17, f18, f19, f20);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = this.getVertexBrightness(i2, j2, k2, l2, f21, f22, f23, f24);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = this.getVertexBrightness(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = this.getAoBrightness(l, i, j1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = this.getAoBrightness(k, i, i1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = this.getAoBrightness(k, j, k1, i3);
                this.vertexBrightness[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = this.getAoBrightness(l, j, l1, i3);
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert0] = f9;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert1] = f10;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert2] = f11;
                this.vertexColorMultiplier[((VertexTranslations)blockmodelrenderer$vertextranslations).vert3] = f12;
            }
        }

        protected int getAoBrightness(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        protected int getVertexBrightness(int p_178203_1_, int p_178203_2_, int p_178203_3_, int p_178203_4_, float p_178203_5_, float p_178203_6_, float p_178203_7_, float p_178203_8_) {
            int i = (int)((float)(p_178203_1_ >> 16 & 0xFF) * p_178203_5_ + (float)(p_178203_2_ >> 16 & 0xFF) * p_178203_6_ + (float)(p_178203_3_ >> 16 & 0xFF) * p_178203_7_ + (float)(p_178203_4_ >> 16 & 0xFF) * p_178203_8_) & 0xFF;
            int j = (int)((float)(p_178203_1_ & 0xFF) * p_178203_5_ + (float)(p_178203_2_ & 0xFF) * p_178203_6_ + (float)(p_178203_3_ & 0xFF) * p_178203_7_ + (float)(p_178203_4_ & 0xFF) * p_178203_8_) & 0xFF;
            return i << 16 | j;
        }
    }

    public static interface TintProvider {
        public int getBlockTint(IBlockState var1, int var2);
    }

    public static interface LightingProvider {
        public int getPackedLightmapCoords(IBlockState var1, @Nullable EnumFacing var2);
    }

    public static interface AmbientOcclusionProvider {
        public AmbientOcclusionFace getAmbientOcclusion(IBlockState var1, @Nullable EnumFacing var2, float[] var3, BitSet var4);
    }

    public static interface OcclusionCuller {
        public boolean shouldSideBeRendered(IBlockState var1, EnumFacing var2);
    }
}

