/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.network.serverbound.MessageConnectCavingRope;
import thebetweenlands.common.network.serverbound.MessageOpenPouch;
import thebetweenlands.common.network.serverbound.MessageUpdatePuppeteerState;
import thebetweenlands.common.network.serverbound.MessageUpdateSummoningState;
import thebetweenlands.common.registries.KeyBindRegistry;

public class InputHandler {
    private static boolean wasConnectRopeButtonPressed = false;
    private static boolean wasDisconnectRopeButtonPressed = false;
    private static boolean wasUseButtonPressed = false;
    private static boolean wasRingUseButtonPressed = false;
    private static boolean wasPouchButtonPressed = false;

    private InputHandler() {
    }

    @SubscribeEvent
    public static void onInput(InputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            InputHandler.updateRopeConnectButtonState();
            InputHandler.updateUseButtonState();
            InputHandler.updateRingUseButtonState();
            InputHandler.updatePouchButtonState();
        }
    }

    private static void updateRopeConnectButtonState() {
        if (!wasConnectRopeButtonPressed && KeyBindRegistry.CONNECT_CAVING_ROPE.func_151470_d()) {
            wasConnectRopeButtonPressed = true;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageConnectCavingRope());
        } else if (wasConnectRopeButtonPressed && !KeyBindRegistry.CONNECT_CAVING_ROPE.func_151470_d()) {
            wasConnectRopeButtonPressed = false;
        }
    }

    private static void updatePouchButtonState() {
        if (!wasPouchButtonPressed && KeyBindRegistry.OPEN_POUCH.func_151470_d()) {
            wasPouchButtonPressed = true;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageOpenPouch());
        } else if (wasPouchButtonPressed && !KeyBindRegistry.OPEN_POUCH.func_151470_d()) {
            wasPouchButtonPressed = false;
        }
    }

    private static void updateUseButtonState() {
        if (!wasUseButtonPressed && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            wasUseButtonPressed = true;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageUpdatePuppeteerState(true));
        } else if (wasUseButtonPressed && !Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            wasUseButtonPressed = false;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageUpdatePuppeteerState(false));
        }
    }

    private static void updateRingUseButtonState() {
        if (!wasRingUseButtonPressed && KeyBindRegistry.USE_RING.func_151470_d()) {
            wasRingUseButtonPressed = true;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageUpdateSummoningState(true));
        } else if (wasRingUseButtonPressed && !KeyBindRegistry.USE_RING.func_151470_d()) {
            wasRingUseButtonPressed = false;
            TheBetweenlands.networkWrapper.sendToServer((IMessage)new MessageUpdateSummoningState(false));
        }
    }
}

