/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementText;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.elements.ElementTinkerItem;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

@SideOnly(value=Side.CLIENT)
public class ContentSingleStatMultMaterial
extends TinkerPage {
    public static final String ID = "single_stat_material";
    private transient List<Material> materials;
    @SerializedName(value="materials")
    public String[] materialNames;
    public String materialType;

    public ContentSingleStatMultMaterial(List<Material> materials, String materialType) {
        this.materials = ImmutableList.copyOf(materials);
        this.materialNames = (String[])materials.stream().map(Material::getIdentifier).toArray(String[]::new);
        this.materialType = materialType;
    }

    public void load() {
        if (this.materials == null) {
            this.materials = Stream.of(this.materialNames).map(TinkerRegistry::getMaterial).collect(Collectors.toList());
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int yStep = GuiBook.PAGE_HEIGHT / 3;
        for (int i = 0; i < this.materials.size(); ++i) {
            Material material = this.materials.get(i);
            int y = yStep * i;
            this.addTitle(list, material.getLocalizedNameColored(), true, y);
            int col_margin = 22;
            int top = 15;
            int left = rightSide ? 0 : col_margin;
            int x = left + 10;
            int w = GuiBook.PAGE_WIDTH / 2 - 10;
            LinkedHashSet<ITrait> allTraits = new LinkedHashSet<ITrait>();
            this.addStatsDisplay(x, y += 20, w, list, material, allTraits, this.materialType);
        }
    }

    private void addStatsDisplay(int x, int y, int w, ArrayList<BookElement> list, Material material, LinkedHashSet<ITrait> allTraits, String stattype) {
        Object stats = material.getStats(stattype);
        if (stats == null) {
            return;
        }
        int x1 = 10;
        int x2 = 30;
        int x3 = 120;
        List<ITrait> traits = material.getAllTraitsForStats(stats.getIdentifier());
        LinkedList parts = Lists.newLinkedList();
        parts.addAll(TinkerRegistry.getToolParts().stream().filter(part -> part.hasUseForStat(stats.getIdentifier())).map(part -> part.getItemstackWithMaterial(material)).collect(Collectors.toList()));
        if (parts.size() > 0) {
            ElementTinkerItem display = new ElementTinkerItem(x1, y + 1, 1.0f, parts);
            list.add((BookElement)display);
        }
        List<TextData> lineData = ContentMaterial.getStatLines(stats);
        List<TextData> traitLineData = ContentMaterial.getTraitLines(traits, material);
        list.add((BookElement)new ElementText(x2, y, w, GuiBook.PAGE_HEIGHT, lineData));
        if (!traitLineData.isEmpty()) {
            list.add((BookElement)new ElementText(x3, y, w, GuiBook.PAGE_HEIGHT, traitLineData));
        }
    }
}

