/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot;

import com.mmyzd.nmsot.rule.RuleSet;
import java.util.LinkedList;

public class IntegerRange {
    public static final int INVALID_INT = -1000000007;
    public static final int MIN_INT = 999999999;
    public static final int MAX_INT = 999999999;
    public int lhs = 999999999;
    public int rhs = 999999999;

    public IntegerRange(LinkedList<Character> s) throws Exception {
        char c = RuleSet.skipSpace(s);
        if (c == '*') {
            s.removeFirst();
        } else {
            int data = IntegerRange.getInteger(s);
            c = RuleSet.skipSpace(s);
            if (c == '-') {
                s.removeFirst();
                this.lhs = data;
                this.rhs = IntegerRange.getInteger(s);
                if (this.lhs > this.rhs) {
                    int tmp = this.lhs;
                    this.lhs = this.rhs;
                    this.rhs = tmp;
                }
            } else {
                this.lhs = data;
                this.rhs = data;
            }
        }
    }

    public static int getInteger(LinkedList<Character> source) throws Exception {
        LinkedList<Character> s = new LinkedList<Character>(source);
        char c = RuleSet.skipSpace(s);
        if ((c < '0' || c > '9') && c != '-' && c != '+') {
            throw new Exception("Invalid integer");
        }
        int sign = 1;
        if (c == '+' || c == '-') {
            sign = c == '+' ? 1 : -1;
            s.removeFirst();
            c = RuleSet.skipSpace(s);
        }
        int result = 0;
        int length = 0;
        while (c >= '0' && c <= '9') {
            if (++length > 9) {
                throw new Exception("Too many numbers in the integer");
            }
            result = result * 10 + c - 48;
            s.removeFirst();
            c = s.getFirst().charValue();
        }
        if (length < 1) {
            throw new Exception("Invalid integer");
        }
        while (source.size() != s.size()) {
            source.removeFirst();
        }
        return result * sign;
    }
}

