/*
 * Decompiled with CFR 0.152.
 */
package com.matt_r__.ConfigChecker;

import com.matt_r__.ConfigChecker.Event;
import com.matt_r__.ConfigChecker.ModConfig;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FilenameUtils;
import util.Config;

@Mod(modid="concheckrmd", name="Config Checker", version="1.8.1", acceptedMinecraftVersions="[1.12, 1.12.2]", dependencies="before:*")
public class Main {
    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.printf("\n=========================================================================================\n\n[MODPACK CONFIGURATION CHECKER] NO DISPLAY DETECTED\n\n Modpack Configuration Checker can not check configuration in this enviroment. \n\n=========================================================================================\n", new Object[0]);
        } else {
            this.runChecks();
        }
    }

    @SideOnly(value=Side.SERVER)
    @Mod.EventHandler
    public void preInitServer(FMLPreInitializationEvent event) {
        System.out.printf("\n=========================================================================================\n\n[MODPACK CONFIGURATION CHECKER] SERVER DETECTED\n\n Modpack Configuration Checker can not check configuration in this enviroment. \n\n=========================================================================================\n", new Object[0]);
    }

    public void runChecks() {
        Main.previousversion();
        if (Main.previousversion()) {
            JFrame jf = new JFrame();
            jf.isAlwaysOnTop();
            int action = JOptionPane.showConfirmDialog(jf, "An older Config Checker configuration file has been detected. Your settings can be moved to the new version. Would you like to transfer your settings?");
            if (action == 0) {
                Main.transferoldconfig();
            } else {
                try {
                    new File("config/Config Checker.cfg").renameTo(new File("config/Config Checker.cfg.old"));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(jf, "Unable to delete old file. Please delete it manually from 'Config/Config Checker.cfg'." + e.getMessage());
                }
            }
        }
        Main.cleanfile();
        Main.LoadConfig();
        Config.gamebooting = true;
        this.checkadditionals();
        this.filedatecheck();
        this.meetsrequiredram();
        this.meetsrecommendedram();
        this.launchwebpage();
        this.displaycustommessage();
        MinecraftForge.EVENT_BUS.register((Object)new Event());
        this.gamelaunchtimout();
    }

    public static void LoadConfig() {
        Configuration config = new Configuration(new File("concheckrmd"));
        config.load();
        Config.ramrecommendedinmbonload = ModConfig.ramlaunch.launchrecommendedraminmb;
        Config.checkRecommendedRAM = ModConfig.ramlaunch.launchcheckrecommendedram;
        Config.RecommendedRAMPopupTopmost = ModConfig.ramlaunch.launchdisplayrammessageboxtopmost;
        Config.DisplayCustomMessageBoxRecommendations = ModConfig.ramlaunch.launchcustomrecommendedtext;
        Config.CustomRAMRecommendationsMessageBox = ModConfig.ramlaunch.messageboxtext;
        Config.ramrecommendedinmbingame = ModConfig.ramgame.chatrecommendedraminmb;
        Config.showrecommendedramingame = ModConfig.ramgame.chatcheckrecommendedram;
        Config.showrecommendedramingamecustommessage = ModConfig.ramgame.chatcustomrecommendedtext;
        Config.recommendedramingamecustommessage = ModConfig.ramgame.chatramcustomtext;
        Config.ramrequiredinmb = ModConfig.reqram.requiredraminmb;
        Config.checkRequiredRAM = ModConfig.reqram.checkrequiredram;
        Config.RequiredRAMPopupTopmost = ModConfig.reqram.ramreqmessageboxtopmost;
        Config.DisplayCustomMessageBoxRequirements = ModConfig.reqram.customrequiredtext;
        Config.CustomRAMRequirementsMessageBox = ModConfig.reqram.requiredramcustomtext;
        Config.displaygreetingmessageingame = ModConfig.customg.displaychatgreeting;
        Config.greetingmessagetext = ModConfig.customg.greetingmessagetext;
        Config.launchtimeoutinseconds = ModConfig.launchtimeout.launchtimeoutinseconds;
        Config.checklaunchtimeout = ModConfig.launchtimeout.checklaunchtimeout;
        Config.launchtimeoutmessageboxtopmost = ModConfig.launchtimeout.launchtimeoutmessageboxtopmost;
        Config.displaycustomlaunchtimeoutmessagebox = ModConfig.launchtimeout.displaycustomlaunchtimeoutmessagebox;
        Config.customlaunchtimeoutmessageboxtext = ModConfig.launchtimeout.customlaunchtimeoutmessageboxtext;
        Config.filecheckdebugmode = ModConfig.filechecking.filecheckdebug;
        Config.checkfiledate1 = ModConfig.filechecking.filedate1.checkfiledate1;
        Config.datetimeformatstring1 = ModConfig.filechecking.filedate1.datetimeformatstring1;
        Config.datetimefilepath1 = ModConfig.filechecking.filedate1.filepath1;
        Config.minimumdatetime1 = ModConfig.filechecking.filedate1.mindatetime;
        Config.filedatetopmost1 = ModConfig.filechecking.filedate1.messageboxtopmost;
        Config.custommessagefiledate1 = ModConfig.filechecking.filedate1.displaycustommessagebox;
        Config.custommessagefiledate1text = ModConfig.filechecking.filedate1.custommessageboxtext;
        Config.datetimechecknewerorolder1 = ModConfig.filechecking.filedate1.datetimenewerorolder.toString();
        Config.checkfilehash1 = ModConfig.filechecking.filehash1.checkfilehash1;
        Config.hashalgorithm1 = ModConfig.filechecking.filehash1.filehash1.toString();
        Config.hashfilepath1 = ModConfig.filechecking.filehash1.filepath1;
        Config.hashvalue1 = ModConfig.filechecking.filehash1.filehashtarget1;
        Config.hashtopmost1 = ModConfig.filechecking.filehash1.messageboxtopmost;
        Config.custommessagefilehash1 = ModConfig.filechecking.filehash1.displaycustommessagebox;
        Config.custommessagefilehashtext1 = ModConfig.filechecking.filehash1.custommessageboxtext;
        Config.webpageURL = ModConfig.webpage.websiteurl;
        Config.launchwebpage = ModConfig.webpage.displaywebsite;
        Config.displaylaunchmessage = ModConfig.custommb.displaymessagebox;
        Config.launchmessagetext = ModConfig.custommb.messageboxtext;
        Config.launchmessagetopmost = ModConfig.custommb.displaymessageboxtopmost;
        if (new File("config/concheckrmd.lock").exists()) {
            Config.lockconfig = true;
        }
        config.save();
    }

    private static void cleanfile() {
        try {
            Object jf;
            FileWriter writer;
            Path filePath = new File("config/concheckrmd.cfg").toPath();
            List<String> configfile = Files.readAllLines(filePath);
            if (configfile.get(98).contains("S:\"5) Chat Colour\"=") && configfile.get(100).contains("colorchat {") && configfile.get(101).contains("}")) {
                configfile.set(98, "");
                configfile.set(100, "");
                configfile.set(101, "");
                writer = new FileWriter("config/concheckrmd.cfg");
                for (String str : configfile) {
                    writer.write(str + System.lineSeparator());
                }
                writer.close();
                jf = new JFrame();
                ((Window)jf).setAlwaysOnTop(true);
                JOptionPane.showMessageDialog((Component)jf, "An older Modpack Configuration Checker configuration file has been detected. The game will now be closed to apply these settings. Please launch the game again. ", "Restart Required", 0);
                FMLCommonHandler.instance().exitJava(0, false);
            }
            if (configfile.get(105).contains("S:\"5) Chat Colour\"=") && configfile.get(107).contains("colorchat {") && configfile.get(108).contains("}")) {
                configfile.set(105, "");
                configfile.set(107, "");
                configfile.set(108, "");
                writer = new FileWriter("config/concheckrmd.cfg");
                for (String str : configfile) {
                    writer.write(str + System.lineSeparator());
                }
                writer.close();
                jf = new JFrame();
                ((Window)jf).setAlwaysOnTop(true);
                JOptionPane.showMessageDialog((Component)jf, "An older Modpack Configuration Checker configuration file has been detected. The game will now beclosed to apply these settings. Please launch the game again. ", "Restart Required", 0);
                FMLCommonHandler.instance().exitJava(0, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean previousversion() {
        return new File("config/Config Checker.cfg").exists();
    }

    public static void transferoldconfig() {
        try {
            Configuration config = new Configuration(new File("config/Config Checker.cfg"));
            config.load();
            ModConfig.ramlaunch.launchrecommendedraminmb = config.get("RAM Recommendation", "1. Ram Recommended (IN MB)", 2048).getInt();
            ModConfig.ramlaunch.launchcheckrecommendedram = config.get("RAM Recommendation", "2. Check RAM meets recommendation?", true).getBoolean();
            ModConfig.ramlaunch.launchdisplayrammessageboxtopmost = config.get("RAM Recommendation", "3. Display message box on top of all other windows?", true).getBoolean();
            ModConfig.ramlaunch.launchcustomrecommendedtext = config.get("RAM Recommendation", "4. Display custom text in message box if RAM recommendations not met?", false).getBoolean();
            ModConfig.ramlaunch.messageboxtext = config.getString("5. Custom recommendation text", "RAM Recommendation", "You should add more RAM.", "Enter custom text to be shown if RAM recommendation not met. Will only display if 'Display custom text in message box if RAM recommendation not met?' equals true");
            ModConfig.ramgame.chatrecommendedraminmb = config.get("RAM Recommendation", "1. Ram Recommended (IN MB)", 2048).getInt();
            ModConfig.ramgame.chatcheckrecommendedram = config.get("RAM Recommendation", "6. Display warning in game chat if RAM recommendation not met?", true).getBoolean();
            ModConfig.ramgame.chatcustomrecommendedtext = config.get("RAM Recommendation", "7. Customise game chat RAM recommendation message?", false).getBoolean();
            ModConfig.ramgame.chatramcustomtext = config.getString("8. Custom chat message", "RAM Recommendation", "[WARNING] You should assign more RAM to this modpack.", "Enter custom text to be shown in game chat if RAM recommendation not met. Will only display if 'Customise game chat RAM recommendation message?\"' equals true");
            ModConfig.reqram.requiredraminmb = config.get("RAM Requirement", "1. Ram Required (IN MB)", 1024).getInt();
            ModConfig.reqram.checkrequiredram = config.get("RAM Requirement", "2. Check RAM meets requirement?", false).getBoolean();
            ModConfig.reqram.ramreqmessageboxtopmost = config.get("RAM Requirement", "3. Display message box on top of all other windows?", true).getBoolean();
            ModConfig.reqram.customrequiredtext = config.get("RAM Requirement", "4. Display custom text in message box if RAM requirement not met?", false).getBoolean();
            ModConfig.reqram.requiredramcustomtext = config.getString("5. Custom requirement text", "RAM Requirement", "You need more RAM.", "Enter custom text to be shown if RAM requirement not met. Will only display if 'Display custom text in message box if RAM requirement not met?' equals true");
            ModConfig.customg.displaychatgreeting = config.get("Custom Greeting Message", "1. Display custom greeting message when joining a world?", false).getBoolean();
            ModConfig.customg.greetingmessagetext = config.getString("2. Custom greeting message text", "Custom Greeting Message", "Hello there! Welcome to my modpack.", "A message that will be displayed in chat when a game is loaded. Will only display if 'Display custom greeting message when joining a world?' equals true");
            ModConfig.webpage.websiteurl = config.getString("2. URL to webpage", "Display Webpage", "http://minecraft.curseforge.com/projects/config-checker", "Enter URL to be launched. Will only display if 'Open web browser to URL when game loads?' equals true");
            ModConfig.webpage.displaywebsite = config.get("Display Webpage", "1. Open web browser to URL when game loads?", false).getBoolean();
            ModConfig.custommb.messageboxtext = config.getString("3. Custom Messagebox text", "Custom Messagebox", "Hello World!!", "Enter popup text. Will only display if 'Show custom messagebox when game loads?' equals true");
            ModConfig.custommb.displaymessagebox = config.get("Custom Messagebox", "1. Show custom messagebox when game loads?", false).getBoolean();
            ModConfig.custommb.displaymessageboxtopmost = config.get("Custom Messagebox", "2. Display message box on top of all other windows?", true).getBoolean();
            config.save();
            ModConfig.updatemanually();
            JFrame jf = new JFrame();
            jf.setAlwaysOnTop(true);
            try {
                new File("config/Config Checker.cfg").renameTo(new File("config/Config Checker.cfg.old"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(jf, "Unable to delete old file. Please delete it manually from 'Config/Config Checker.cfg'." + e.getMessage());
            }
        }
        catch (Exception error) {
            JFrame jf = new JFrame();
            jf.setAlwaysOnTop(true);
            int action = JOptionPane.showConfirmDialog(jf, "Error transferring settings. Please make sure you do not have the file open in notepad. " + error.getMessage() + ". Would you like to try again?", "Error Transferring Settings", 0);
            if (action == 0) {
                Main.transferoldconfig();
            }
            try {
                new File("config/Config Checker.cfg").renameTo(new File("config/Config Checker.cfg.old"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(jf, "Unable to delete old file. Please delete it manually from 'Config/Config Checker.cfg'." + e.getMessage());
            }
        }
    }

    public void filedatecheck() {
        JFrame topframe = new JFrame();
        topframe.setAlwaysOnTop(true);
        if (Config.checkfiledate1.booleanValue()) {
            if (new File(Config.datetimefilepath1).exists()) {
                this.filedatecheck1();
            } else if (Config.filecheckdebugmode) {
                JOptionPane.showMessageDialog(topframe, "File: " + new File(Config.datetimefilepath1).getName() + " does not exist. Unable to check the file version.", "File does not exist", 2);
            }
        }
        if (Config.checkfilehash1.booleanValue()) {
            if (new File(Config.hashfilepath1).exists()) {
                this.filehashcheck1();
            } else if (Config.filecheckdebugmode) {
                JOptionPane.showMessageDialog(topframe, "File: " + new File(Config.hashfilepath1).getName() + " does not exist. Unable to check the file hash.", "File does not exist", 2);
            }
        }
    }

    public void filedatecheck1() {
        JFrame topframe = new JFrame();
        topframe.setAlwaysOnTop(true);
        try {
            JFrame jf;
            SimpleDateFormat sdf = null;
            try {
                sdf = new SimpleDateFormat(Config.datetimeformatstring1);
            }
            catch (Exception e) {
                if (Config.filecheckdebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error parsing date format string: " + Config.datetimeformatstring1 + ". Date format strings should follow a structure similar to 'dd/MM/yyyy', 'MM/dd/yy' etc.", "Error parsing date format string", 2);
                }
                return;
            }
            Calendar reqcal = Calendar.getInstance();
            try {
                reqcal.setTimeInMillis(sdf.parse(Config.minimumdatetime1).getTime());
            }
            catch (Exception e) {
                if (Config.filecheckdebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error parsing minimum date: " + Config.minimumdatetime1 + ". This date should follow the format of the date string: " + Config.datetimeformatstring1, "Error parsing date format string", 2);
                }
                return;
            }
            Calendar filecal = Calendar.getInstance();
            try {
                FileReader fileReader = new FileReader(Config.datetimefilepath1);
                fileReader.read();
                fileReader.close();
                filecal.setTimeInMillis(new File(Config.datetimefilepath1).lastModified());
            }
            catch (Exception e) {
                if (Config.filecheckdebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error detecting last modified date of file: " + new File(Config.datetimefilepath1).getName() + ". This is probably due to insufficient access rights on the file. ", "Error detecting last modified", 2);
                }
                return;
            }
            if (filecal.compareTo(reqcal) == -1 && Config.datetimechecknewerorolder1 == "FileOlder") {
                jf = new JFrame();
                if (Config.filedatetopmost1.booleanValue()) {
                    jf.setAlwaysOnTop(true);
                }
                if (Config.custommessagefiledate1.booleanValue()) {
                    JOptionPane.showMessageDialog(jf, Config.custommessagefiledate1text, "File out of date", 2);
                } else {
                    JOptionPane.showMessageDialog(jf, "The file " + FilenameUtils.getName((String)Config.datetimefilepath1) + " is out of date and should be updated. Please contact the modpack author to download an updated version.", "File out of date", 2);
                }
            }
            if (filecal.compareTo(reqcal) == 1 && Config.datetimechecknewerorolder1 == "FileNewer") {
                jf = new JFrame();
                if (Config.filedatetopmost1.booleanValue()) {
                    jf.setAlwaysOnTop(true);
                }
                if (Config.custommessagefiledate1.booleanValue()) {
                    JOptionPane.showMessageDialog(jf, Config.custommessagefiledate1text, "File Too New", 2);
                } else {
                    JOptionPane.showMessageDialog(jf, "The file " + FilenameUtils.getName((String)Config.datetimefilepath1) + " has been modified too recently. Please contact the modpack author to download an older version. ", "File Too New", 2);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(topframe, "Something went wrong while checking file date. Error Message says: " + e.getMessage(), "Error detecting last modified", 2);
        }
    }

    public void filehashcheck1() {
        block15: {
            JFrame topframe = new JFrame();
            topframe.setAlwaysOnTop(true);
            try {
                String currenthash;
                block14: {
                    try {
                        FileReader fileReader = new FileReader(Config.hashfilepath1);
                        fileReader.read();
                        fileReader.close();
                        if (Config.hashalgorithm1 == "MD5") {
                            currenthash = Main.toHex(Hash.MD5.checksum(new File(Config.hashfilepath1)));
                            break block14;
                        }
                        if (Config.hashalgorithm1 == "SHA1") {
                            currenthash = Main.toHex(Hash.SHA1.checksum(new File(Config.hashfilepath1)));
                            break block14;
                        }
                        if (Config.hashalgorithm1 == "SHA256") {
                            currenthash = Main.toHex(Hash.SHA256.checksum(new File(Config.hashfilepath1)));
                            break block14;
                        }
                        if (Config.hashalgorithm1 == "SHA512") {
                            currenthash = Main.toHex(Hash.SHA512.checksum(new File(Config.hashfilepath1)));
                            break block14;
                        }
                        if (Config.filecheckdebugmode) {
                            JOptionPane.showMessageDialog(topframe, "Something went wrong while determining the file hash algorithm to use, unable to find: " + Config.hashalgorithm1, "Error detecting hash algorithm", 2);
                        }
                        return;
                    }
                    catch (Exception e) {
                        if (Config.filecheckdebugmode) {
                            JOptionPane.showMessageDialog(topframe, "Error detecting hash of file: " + new File(Config.hashfilepath1).getName() + ". This is probably due to insufficient access rights on the file.", "Error detecting hash", 2);
                        }
                        return;
                    }
                }
                if (!currenthash.toUpperCase().equals(Config.hashvalue1.toUpperCase())) {
                    JFrame jf = new JFrame();
                    if (Config.hashtopmost1.booleanValue()) {
                        jf.setAlwaysOnTop(true);
                    }
                    if (Config.custommessagefilehash1.booleanValue()) {
                        JOptionPane.showMessageDialog(jf, Config.custommessagefilehashtext1, "File Modified", 2);
                    } else {
                        JOptionPane.showMessageDialog(jf, "The file " + FilenameUtils.getName((String)Config.hashfilepath1) + " has been modified in a way that is not supported by the modpack author. Please revert changes or download a new version of this file.", "File Modified", 2);
                    }
                }
            }
            catch (Exception e) {
                if (!Config.filecheckdebugmode) break block15;
                JOptionPane.showMessageDialog(topframe, "Something went wrong while checking file hash. Error Message says: " + e.getMessage(), "Error detecting file hash", 2);
            }
        }
    }

    private static String toHex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    public void gamelaunchtimout() {
        if (Config.checklaunchtimeout) {
            Timer timer = new Timer();
            final JFrame jf = new JFrame();
            final long launchtimeout = TimeUnit.SECONDS.toMillis(Config.launchtimeoutinseconds);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Config.gamebooting) {
                        if (Config.launchtimeoutmessageboxtopmost) {
                            jf.setAlwaysOnTop(true);
                        }
                        if (Config.displaycustomlaunchtimeoutmessagebox) {
                            JOptionPane.showMessageDialog(jf, Config.customlaunchtimeoutmessageboxtext, "Time Limit Exceeded", 0);
                        } else {
                            JOptionPane.showMessageDialog(jf, "The modpack author has set the launch timeout to " + Main.calculateTime(launchtimeout) + ". This time limit has now been reached. The game will now close.", "Launch Time Limit Exceeded", 0);
                        }
                        FMLCommonHandler.instance().exitJava(1, false);
                    }
                }
            }, launchtimeout);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String calculateTime(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (days == 1L) {
            sb.append(days);
            sb.append(" day ");
        } else if (days != 0L) {
            sb.append(days);
            sb.append(" days ");
        }
        if (hours == 1L) {
            sb.append(hours);
            sb.append(" hour ");
        } else if (hours != 0L) {
            sb.append(hours);
            sb.append(" hours ");
        }
        if (minutes == 1L) {
            sb.append(minutes);
            sb.append(" minute ");
        } else if (minutes != 0L) {
            sb.append(minutes);
            sb.append(" minutes ");
        }
        if (seconds == 1L) {
            sb.append(seconds);
            sb.append(" second ");
        } else if (seconds != 0L) {
            sb.append(seconds);
            sb.append(" seconds ");
        }
        return sb.toString();
    }

    public void launchwebpage() {
        if (Config.launchwebpage) {
            Desktop desktop = Desktop.getDesktop();
            try {
                if (Config.webpageURL.startsWith("http")) {
                    desktop.browse(URI.create(Config.webpageURL));
                } else {
                    desktop.browse(URI.create("http://" + Config.webpageURL));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JFrame jf = new JFrame();
                jf.setAlwaysOnTop(true);
                JOptionPane.showMessageDialog(jf, "Error opening webpage. The error is: " + e.getMessage(), "Error Opening Webpage", 0);
            }
        }
    }

    public void displaycustommessage() {
        if (Config.displaylaunchmessage) {
            JFrame jf = new JFrame();
            if (Config.launchmessagetopmost) {
                jf.setAlwaysOnTop(true);
            }
            JOptionPane.showMessageDialog(jf, Config.launchmessagetext, "Message from Modpack Author", 1);
        }
    }

    public void meetsrecommendedram() {
        int currentraminmb;
        if (Config.checkRecommendedRAM && Config.ramrecommendedinmbonload > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.coulddowithmoreram();
        }
    }

    public void coulddowithmoreram() {
        long RamRecommendedinbytes = Config.ramrecommendedinmbonload * 1024;
        JFrame jf = new JFrame();
        if (Config.RecommendedRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if (Config.DisplayCustomMessageBoxRecommendations) {
            JOptionPane.showMessageDialog(jf, Config.CustomRAMRecommendationsMessageBox, "Memory Warning", 2);
        } else {
            JOptionPane.showMessageDialog(jf, "You have " + Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true) + " of RAM set up for this modpack but the modpack author recommends at least " + Main.humanReadableByteCount(RamRecommendedinbytes * 1024L, true) + ". You may have performance issues unless you change this.", "Memory Warning", 2);
        }
    }

    public void meetsrequiredram() {
        int currentraminmb;
        if (Config.checkRequiredRAM && Config.ramrequiredinmb > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.needmoreram();
        }
    }

    public void needmoreram() {
        long RamRequiredinbytes = Config.ramrequiredinmb * 1024;
        JFrame jf = new JFrame();
        if (Config.RequiredRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if (Config.DisplayCustomMessageBoxRequirements) {
            JOptionPane.showMessageDialog(jf, Config.CustomRAMRequirementsMessageBox, "Memory Error", 0);
        } else {
            JOptionPane.showMessageDialog(jf, "You have " + Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true) + " of RAM set up for this modpack but the modpack author claims at least " + Main.humanReadableByteCount(RamRequiredinbytes * 1024L, true) + " is required for the modpack to run. The game will now close.", "Memory Error", 0);
        }
        FMLCommonHandler.instance().exitJava(1, false);
    }

    public void checkadditionals() {
        if (Config.craftsaddle) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("Saddle_top"), (ResourceLocation)new ResourceLocation("recipes"), (ItemStack)new ItemStack(Items.field_151141_av, 1), (Object[])new Object[]{"LLL", "T T", "   ", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('T'), Blocks.field_150479_bC});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("Saddle_bottom"), (ResourceLocation)new ResourceLocation("recipes"), (ItemStack)new ItemStack(Items.field_151141_av, 1), (Object[])new Object[]{"   ", "LLL", "T T", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('T'), Blocks.field_150479_bC});
        }
    }

    public static enum Hash {
        MD5("MD5"),
        SHA1("SHA1"),
        SHA256("SHA-256"),
        SHA512("SHA-512");

        private String name;

        private Hash(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] checksum(File input) {
            try (FileInputStream in = new FileInputStream(input);){
                int length;
                MessageDigest digest = MessageDigest.getInstance(this.getName());
                byte[] block = new byte[4096];
                while ((length = ((InputStream)in).read(block)) > 0) {
                    digest.update(block, 0, length);
                }
                byte[] byArray = digest.digest();
                return byArray;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

