/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class IndicatorLight
extends PanelComponent
implements IConfigurableComponent {
    @Nonnull
    private ControlPanelNetwork.RSChannel inputChannel = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;
    private int colorA = 65280;
    private byte rsInput;
    private static final float size = 0.0625f;
    private Consumer<ControlPanelNetwork.RSChannelState> handler = state -> {
        if (state.getStrength() != this.rsInput) {
            this.rsInput = state.getStrength();
            this.panel.func_70296_d();
            this.panel.triggerRenderUpdate();
        }
    };

    public IndicatorLight() {
        super("indicator_light");
    }

    public IndicatorLight(@Nonnull ControlPanelNetwork.RSChannel input, int color) {
        this();
        this.colorA = color;
        this.inputChannel = input;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        nbt.func_74768_a("rsId", this.inputChannel.getController());
        nbt.func_74774_a("rsChannel", this.inputChannel.getColor());
        nbt.func_74768_a("color", this.colorA);
        if (!toItem) {
            nbt.func_74768_a("rsInput", (int)this.rsInput);
        }
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        int rsController = nbt.func_74762_e("rsId");
        byte rsColor = nbt.func_74771_c("rsChannel");
        this.inputChannel = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        this.colorA = nbt.func_74762_e("color");
        this.rsInput = nbt.func_74771_c("rsInput");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        float[] color = new float[4];
        color[3] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            color[i] = (float)(this.colorA >> 8 * (2 - i) & 0xFF) / 255.0f * ((float)this.rsInput + 15.0f) / 30.0f;
        }
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>(1);
        PanelUtils.addColoredQuad(ret, new Vector3f(), new Vector3f(0.0f, 0.0f, 0.0625f), new Vector3f(0.0625f, 0.0f, 0.0625f), new Vector3f(0.0625f, 0.0f, 0.0f), EnumFacing.UP, color);
        if (this.rsInput > 0) {
            ((RawQuad)ret.get((int)(ret.size() - 1))).light = 1044735;
        }
        return ret;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        IndicatorLight ret = new IndicatorLight(this.inputChannel, this.colorA);
        ret.rsInput = this.rsInput;
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + 0.0625f), 0.0, (double)(this.y + 0.0625f));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRelative, EntityPlayerMP player) {
    }

    @Override
    public void update() {
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        net.addListener(this, this.handler, this.inputChannel);
    }

    @Override
    public float getHeight() {
        return 0.0f;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndicatorLight that = (IndicatorLight)o;
        if (this.colorA != that.colorA) {
            return false;
        }
        return this.rsInput == that.rsInput;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.colorA;
        result = 31 * result + this.rsInput;
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        this.renderInGUIDefault(gui, this.colorA);
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case RS_CHANNEL: {
                if (id != 0) break;
                this.inputChannel = this.inputChannel.withColor(value);
                break;
            }
            case INT: {
                if (id != 0) break;
                this.inputChannel = this.inputChannel.withController(value);
                break;
            }
            case FLOAT: {
                this.colorA = PanelUtils.setColor(this.colorA, id, value);
            }
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return null;
            }
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)"industrialwires.desc.rschannel_info", (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)"industrialwires.desc.rsid_info", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.inputChannel.getColor())};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 45, this.inputChannel.getController(), 2, false)};
    }

    @Override
    public IConfigurableComponent.FloatConfig[] getFloatOptions() {
        float[] color = PanelUtils.getFloatColor(true, this.colorA);
        int x = 70;
        int yOffset = 10;
        return new IConfigurableComponent.FloatConfig[]{new IConfigurableComponent.FloatConfig("red", x, yOffset, Float.valueOf(color[0]), 60), new IConfigurableComponent.FloatConfig("green", x, yOffset + 20, Float.valueOf(color[1]), 60), new IConfigurableComponent.FloatConfig("blue", x, yOffset + 40, Float.valueOf(color[2]), 60)};
    }

    @Override
    public int getColor() {
        return this.colorA;
    }
}

