/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityHelper {
    public static boolean isFluidContainer(ItemStack stack, EnumFacing facing) {
        return !stack.func_190926_b() && (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing) || stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing));
    }

    @Nullable
    public static IFluidHandler getFluidHandler(ItemStack stack, EnumFacing facing) {
        IFluidHandler handler = null;
        if (CapabilityHelper.isFluidContainer(stack, facing) && (handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing)) == null) {
            handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        }
        return handler;
    }

    public static boolean isFluidContainer(TileEntity tile, EnumFacing facing) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    @Nullable
    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing facing) {
        return CapabilityHelper.isFluidContainer(tile, facing) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) : null;
    }

    public static boolean isItemContainer(TileEntity tile, EnumFacing facing) {
        return tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    @Nullable
    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing facing) {
        return CapabilityHelper.isItemContainer(tile, facing) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) : null;
    }

    public static int getComparatorInputOverride(IItemHandler handler) {
        if (handler != null) {
            int itemCount = 0;
            float fullness = 0.0f;
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                fullness += (float)stack.func_190916_E() / (float)Math.min(handler.getSlotLimit(slot), stack.func_77976_d());
                ++itemCount;
            }
            return MathHelper.func_76141_d((float)((fullness /= (float)handler.getSlots()) * 14.0f)) + (itemCount > 0 ? 1 : 0);
        }
        return 0;
    }

    public static int getComparatorInputOverride(IFluidHandler handler) {
        if (handler != null) {
            int fluidCount = 0;
            float fullness = 0.0f;
            IFluidTankProperties[] tankProperties = handler.getTankProperties();
            if (tankProperties != null && tankProperties.length > 0) {
                for (IFluidTankProperties tank : tankProperties) {
                    FluidStack stack;
                    if (tank == null || (stack = tank.getContents()) == null || stack.amount <= 0) continue;
                    fullness += (float)stack.amount / (float)tank.getCapacity();
                    ++fluidCount;
                }
                return MathHelper.func_76141_d((float)((fullness /= (float)tankProperties.length) * 14.0f)) + (fluidCount > 0 ? 1 : 0);
            }
        }
        return 0;
    }

    public static int getComparatorInputOverride(TileEntity tile) {
        IFluidHandler fluidHandler;
        int counter = 0;
        float value = 0.0f;
        IItemHandler itemHandler = CapabilityHelper.getItemHandler(tile, null);
        if (itemHandler != null) {
            value += (float)CapabilityHelper.getComparatorInputOverride(itemHandler) / 15.0f;
            ++counter;
        }
        if ((fluidHandler = CapabilityHelper.getFluidHandler(tile, null)) != null) {
            value += (float)CapabilityHelper.getComparatorInputOverride(fluidHandler) / 15.0f;
            ++counter;
        }
        if (counter > 0) {
            return MathHelper.func_76141_d((float)(value / (float)counter * 14.0f)) + (value > 0.0f ? 1 : 0);
        }
        return 0;
    }
}

