/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.custom;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.recipe.IngredientRecipeHelpers;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;

public abstract class RecipeHandlerMachine<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
implements IRecipeHandler {
    private final M machine;
    private final Set<IngredientComponent<?, ?>> recipeInputComponents;
    private final Set<IngredientComponent<?, ?>> recipeOutputComponents;

    public RecipeHandlerMachine(M machine, Set<IngredientComponent<?, ?>> recipeInputComponents, Set<IngredientComponent<?, ?>> recipeOutputComponents) {
        this.machine = machine;
        this.recipeInputComponents = recipeInputComponents;
        this.recipeOutputComponents = recipeOutputComponents;
    }

    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return this.recipeInputComponents;
    }

    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return this.recipeOutputComponents;
    }

    public Collection<IRecipeDefinition> getRecipes() {
        return Lists.transform(this.machine.getRecipeRegistry().allRecipes(), this.getRecipeTransformer());
    }

    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        IRecipe recipe = this.machine.getRecipeRegistry().findRecipeByInput(this.inputIngredientsToRecipeInput(input));
        if (recipe == null) {
            return null;
        }
        return ((IRecipeDefinition)this.getRecipeTransformer().apply(recipe)).getOutput();
    }

    protected Function<IRecipe<I, O, P>, IRecipeDefinition> getRecipeTransformer() {
        return recipe -> new RecipeDefinition(IngredientRecipeHelpers.toRecipeDefinitionInput(recipe.getInput()), IngredientRecipeHelpers.toRecipeDefinitionOutput(recipe.getOutput()));
    }

    protected abstract I inputIngredientsToRecipeInput(IMixedIngredients var1);
}

