/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.IApiCompat;
import org.cyclops.cyclopscore.modcompat.IExternalCompat;
import org.cyclops.cyclopscore.modcompat.IModCompat;

public class ModCompatLoader
implements IInitListener {
    private static final String CONFIG_CATEGORY = "mod compat";
    protected final ModBase mod;
    protected final List<IExternalCompat> compats = Lists.newLinkedList();
    protected final Set<String> crashedcompats = Sets.newHashSet();

    public ModCompatLoader(ModBase mod) {
        this.mod = mod;
    }

    public void addModCompat(IModCompat modCompat) {
        this.compats.add(modCompat);
    }

    public void addApiCompat(IApiCompat apiCompat) {
        this.compats.add(apiCompat);
    }

    @Override
    public void onInit(IInitListener.Step step) {
        if (step == IInitListener.Step.PREINIT && !this.compats.isEmpty()) {
            this.mod.getConfigHandler().addCategory(CONFIG_CATEGORY);
        }
        for (IExternalCompat compat : this.compats) {
            if (!this.shouldLoadExternalCompat(compat)) continue;
            String id = this.getId(compat);
            try {
                compat.onInit(step);
            }
            catch (RuntimeException e) {
                this.mod.log(Level.ERROR, "The compatibility for " + id + " has crashed! Report this crash clog to the mod author or try updating the conflicting mods.");
                if (this.mod.getReferenceValue(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH).booleanValue()) {
                    throw e;
                }
                e.printStackTrace();
                this.crashedcompats.add(id);
            }
        }
    }

    protected String getId(IExternalCompat compat) {
        if (compat instanceof IModCompat) {
            return ((IModCompat)compat).getModID();
        }
        if (compat instanceof IApiCompat) {
            return ((IApiCompat)compat).getApiID();
        }
        return null;
    }

    public boolean shouldLoadExternalCompat(IExternalCompat compat) {
        return compat instanceof IModCompat && this.shouldLoadModCompat((IModCompat)compat) || compat instanceof IApiCompat && this.shouldLoadApiCompat((IApiCompat)compat);
    }

    public boolean shouldLoadModCompat(IModCompat modCompat) {
        return this.isModLoaded(modCompat) && this.isEnabled(modCompat, modCompat.getModID()) && this.isNotCrashed(modCompat.getModID());
    }

    public boolean shouldLoadApiCompat(IApiCompat apiCompat) {
        return ModAPIManager.INSTANCE.hasAPI(apiCompat.getApiID()) && this.isEnabled(apiCompat, apiCompat.getApiID()) && this.isNotCrashed(apiCompat.getApiID());
    }

    private boolean isModLoaded(IModCompat modCompat) {
        return "Minecraft".equals(modCompat.getModID()) || Loader.isModLoaded((String)modCompat.getModID());
    }

    private boolean isEnabled(IExternalCompat compat, String id) {
        Configuration config = this.mod.getConfigHandler().getConfig();
        Property property = config.get(CONFIG_CATEGORY, id, compat.isEnabled());
        property.setRequiresMcRestart(true);
        property.setComment(compat.getComment());
        property.setLanguageKey("config." + this.mod.getModId() + "." + id.replaceAll("\\s", ""));
        boolean enabled = property.getBoolean(true);
        if (config.hasChanged()) {
            config.save();
        }
        return enabled;
    }

    private boolean isNotCrashed(String id) {
        return !this.crashedcompats.contains(id);
    }
}

