/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.registry;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.module.proxy.VLProxyClient;
import com.valkyrieofnight.vlib.module.proxy.VLProxyCommon;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="valkyrielib3")
public class VLGameRegistry {
    private static List<VLProxyCommon> MOD_PROXIES = Lists.newArrayList();
    private static VLGameRegistry INST;

    public static VLGameRegistry getInstance() {
        if (INST == null) {
            INST = new VLGameRegistry();
            MinecraftForge.EVENT_BUS.register((Object)INST);
        }
        return INST;
    }

    public void registerProxy(VLProxyCommon proxy) {
        if (proxy != null) {
            MOD_PROXIES.add(proxy);
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        System.out.println("TESTREGISTERING_BLOCKS");
        for (VLProxyCommon commonProxy : MOD_PROXIES) {
            commonProxy.registerEventBlocks(event);
        }
    }

    @SubscribeEvent
    public void registerItemBlocks(RegistryEvent.Register<Item> event) {
        System.out.println("TESTREGISTERING_ITEMS");
        for (VLProxyCommon commonProxy : MOD_PROXIES) {
            commonProxy.registerEventItems(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        System.out.println("TESTREGISTERING_MODELS");
        for (VLProxyCommon commonProxy : MOD_PROXIES) {
            if (!(commonProxy instanceof VLProxyClient)) continue;
            System.out.println("    " + commonProxy.getInfo().getModID());
            VLProxyClient client = (VLProxyClient)commonProxy;
            client.registerEventModels(event);
        }
    }
}

