/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandler;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandlerRegistry;

public class FluidStorageBlockWrapper
implements IIngredientComponentStorage<FluidStack, Integer> {
    private final WorldServer world;
    private final BlockPos pos;
    private final EnumFacing side;
    private final boolean blockUpdate;
    private final IIngredientComponentStorage<FluidStack, Integer> targetStorage;

    public FluidStorageBlockWrapper(WorldServer world, BlockPos pos, EnumFacing side, boolean blockUpdate) {
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.blockUpdate = blockUpdate;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)side);
        this.targetStorage = fluidHandler != null ? this.getComponent().getStorageWrapperHandler(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).wrapComponentStorage((Object)fluidHandler) : null;
    }

    protected void sendBlockUpdate() {
        this.world.func_190524_a(this.pos, Blocks.field_150350_a, this.pos);
    }

    protected IBlockBreakHandler getBlockBreakHandler(IBlockState blockState, World world, BlockPos pos, EntityPlayer player) {
        return ((IBlockBreakHandlerRegistry)IntegratedTunnels._instance.getRegistryManager().getRegistry(IBlockBreakHandlerRegistry.class)).getHandler(blockState, world, pos, player);
    }

    protected void postInsert(FluidStack moved) {
        if (moved != null && GeneralConfig.worldInteractionEvents) {
            SoundEvent soundevent = moved.getFluid().getEmptySound(moved);
            this.world.func_184133_a(null, this.pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (this.blockUpdate) {
            this.sendBlockUpdate();
        }
    }

    protected void postExtract(FluidStack moved) {
        if (moved != null && GeneralConfig.worldInteractionEvents) {
            SoundEvent soundevent = moved.getFluid().getFillSound(moved);
            this.world.func_184133_a(null, this.pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public IngredientComponent<FluidStack, Integer> getComponent() {
        return IngredientComponent.FLUIDSTACK;
    }

    public Iterator<FluidStack> iterator() {
        return this.targetStorage.iterator();
    }

    public Iterator<FluidStack> iterator(@Nonnull FluidStack prototype, Integer matchCondition) {
        return this.targetStorage.iterator((Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 1000L;
    }

    public FluidStack insert(@Nonnull FluidStack stack, boolean simulate) {
        if (this.targetStorage != null) {
            return stack;
        }
        Fluid fluid = stack.getFluid();
        if (this.world.field_73011_w.func_177500_n() && fluid.doesVaporize(stack)) {
            return null;
        }
        Block block = fluid.getBlock();
        Object handler = block instanceof IFluidBlock ? new FluidBlockWrapper((IFluidBlock)block, (World)this.world, this.pos) : (block instanceof BlockLiquid ? new BlockLiquidWrapper((BlockLiquid)block, (World)this.world, this.pos) : new BlockWrapper(block, (World)this.world, this.pos));
        int filled = handler.fill(stack, !simulate);
        int remaining = FluidHelpers.getAmount((FluidStack)stack) - filled;
        if (!simulate && filled > 0) {
            this.postInsert(stack);
        }
        if (remaining == 0) {
            return null;
        }
        return new FluidStack(stack, remaining);
    }

    public FluidStack extract(@Nonnull FluidStack prototype, Integer matchCondition, boolean simulate) {
        FluidStack extracted = (FluidStack)this.targetStorage.extract((Object)prototype, (Object)matchCondition, simulate);
        if (!simulate) {
            this.postExtract(extracted);
        }
        return extracted;
    }

    public FluidStack extract(long maxQuantity, boolean simulate) {
        FluidStack extracted = (FluidStack)this.targetStorage.extract(maxQuantity, simulate);
        if (!simulate) {
            this.postExtract(extracted);
        }
        return extracted;
    }
}

