/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.gui.necronomicon;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.structure.IPlaceOfPower;
import com.shinoow.abyssalcraft.api.energy.structure.StructureHandler;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomicon;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonHome;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonNextPage;
import com.shinoow.abyssalcraft.client.handlers.AbyssalCraftClientEventHooks;
import com.shinoow.abyssalcraft.client.lib.MultiblockRenderData;
import com.shinoow.abyssalcraft.lib.NecronomiconResources;
import com.shinoow.abyssalcraft.lib.NecronomiconText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Keyboard;

public class GuiNecronomiconPlacesOfPower
extends GuiNecronomicon {
    private ButtonNextPage buttonNextPage;
    private ButtonNextPage buttonNextPageLong;
    private ButtonNextPage buttonPreviousPage;
    private ButtonNextPage buttonPreviousPageLong;
    private GuiButton buttonDone;
    private ButtonHome buttonHome;
    private GuiNecronomicon parent;
    private List<IPlaceOfPower> places = new ArrayList<IPlaceOfPower>();
    private int ticksInBook;
    private boolean showMultiblock = false;
    private MultiblockRenderData multiblockObj = new MultiblockRenderData();
    private final transient Set<TileEntity> erroredTiles = Collections.newSetFromMap(new WeakHashMap());

    public GuiNecronomiconPlacesOfPower(int bookType, GuiNecronomicon gui) {
        super(bookType);
        this.parent = gui;
        this.isInfo = true;
    }

    @Override
    public GuiNecronomicon withBookType(int par1) {
        return super.withBookType(par1);
    }

    @Override
    public void func_73866_w_() {
        if (this.isInvalid) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
        }
        currentNecro = this;
        if (this.places.isEmpty()) {
            this.initStuff();
        }
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        int i = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonNextPageLong = new ButtonNextPage(2, i + 203, b0 + 167, true, true);
        this.field_146292_n.add(this.buttonNextPageLong);
        this.buttonPreviousPage = new ButtonNextPage(3, i + 18, b0 + 154, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonPreviousPageLong = new ButtonNextPage(4, i + 23, b0 + 167, false, true);
        this.field_146292_n.add(this.buttonPreviousPageLong);
        this.buttonHome = new ButtonHome(5, i + 118, b0 + 167);
        this.field_146292_n.add(this.buttonHome);
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currTurnup < this.getTurnupLimit() - 1;
        this.buttonNextPageLong.field_146125_m = this.currTurnup < this.getTurnupLimit() - 5;
        this.buttonPreviousPage.field_146125_m = true;
        this.buttonPreviousPageLong.field_146125_m = this.currTurnup > 4;
        this.buttonDone.field_146125_m = true;
        this.buttonHome.field_146125_m = true;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.currTurnup < this.getTurnupLimit() - 1) {
                    ++this.currTurnup;
                }
            } else if (button.field_146127_k == 2) {
                if (this.currTurnup < this.getTurnupLimit() - 5) {
                    this.currTurnup += 5;
                }
            } else if (button.field_146127_k == 3) {
                if (this.currTurnup == 0) {
                    this.isInfo = false;
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
                } else if (this.currTurnup > 0) {
                    --this.currTurnup;
                }
            } else if (button.field_146127_k == 4) {
                if (this.currTurnup > 4) {
                    this.currTurnup -= 5;
                }
            } else if (button.field_146127_k == 5) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomicon(this.getBookType()));
            }
        }
        this.updateButtons();
    }

    @Override
    protected void drawInformationText(int x, int y) {
        this.drawPage(this.places.get(this.currTurnup), x, y);
    }

    @Override
    public void func_73876_c() {
        if (!GuiNecronomiconPlacesOfPower.func_146272_n()) {
            ++this.ticksInBook;
        }
        if (this.ticksInBook % 40 == 0) {
            this.showMultiblock = !this.showMultiblock;
        }
        super.func_73876_c();
    }

    private void drawPage(IPlaceOfPower place, int x, int y) {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String title = this.localize(NecronomiconText.LABEL_STRUCTURES);
        this.field_146289_q.func_78279_b(title, k + 20, b0 + 16, 116, 0xC40000);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.PLACE_OF_POWER);
        this.func_73729_b(k, b0, 0, 0, 256, 256);
        this.multiblockObj.calculateData(place.getRenderData());
        this.writeText(1, "Height: " + this.multiblockObj.sizeY + " blocks", 127);
        this.writeText(1, "Width: " + this.multiblockObj.sizeX + " blocks", 137);
        this.writeText(1, "Depth: " + this.multiblockObj.sizeZ + " blocks", 147);
        this.writeText(2, "Range amplifier: " + place.getAmplifier(EnergyEnum.AmplifierType.RANGE));
        this.writeText(2, "Duration amplifier: " + place.getAmplifier(EnergyEnum.AmplifierType.DURATION), 38);
        this.writeText(2, "Power amplifier: " + place.getAmplifier(EnergyEnum.AmplifierType.POWER), 48);
        this.writeText(2, place.getDescription(), 64);
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(this.multiblockObj.sizeX * this.multiblockObj.sizeX + this.multiblockObj.sizeZ * this.multiblockObj.sizeZ);
        float height = this.multiblockObj.sizeY;
        float scaleX = maxX / diag;
        float scaleY = maxY / height;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = k + 65;
        int yPos = (int)(73.0f - (height - 3.0f) * 10.0f / Math.max(1.0f, height - 3.0f));
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)100.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)(-((float)this.multiblockObj.sizeX) / 2.0f), (float)(-((float)this.multiblockObj.sizeY) / 2.0f), (float)0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.setIdentity();
        GlStateManager.func_179114_b((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        rotMat.rotX((float)Math.toRadians(30.0));
        float offX = (float)(-this.multiblockObj.sizeX) / 2.0f;
        float offZ = (float)(-this.multiblockObj.sizeZ) / 2.0f + 1.0f;
        float time = (float)this.ticksInBook * 0.5f;
        if (!GuiScreen.func_146272_n()) {
            time += AbyssalCraftClientEventHooks.partialTicks;
        }
        GlStateManager.func_179109_b((float)(-offX), (float)0.0f, (float)(-offZ));
        GlStateManager.func_179114_b((float)time, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.rotY((float)Math.toRadians(-time));
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.rotY((float)Math.toRadians(-45.0));
        GlStateManager.func_179109_b((float)offX, (float)0.0f, (float)offZ);
        rotMat.transform((Tuple4f)eye);
        this.renderElements(this.multiblockObj, BlockPos.func_177975_b((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(this.multiblockObj.sizeX - 1, this.multiblockObj.sizeY - 1, this.multiblockObj.sizeZ - 1)), eye, place.getActivationPointForRender());
        GlStateManager.func_179121_F();
    }

    private void renderElements(MultiblockRenderData mb, Iterable<? extends BlockPos> blocks, Vector4f eye, BlockPos activationPoint) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = eye.x;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = eye.y;
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = eye.z;
        TileEntityRendererDispatcher.field_147554_b = eye.x;
        TileEntityRendererDispatcher.field_147555_c = eye.y;
        TileEntityRendererDispatcher.field_147552_d = eye.z;
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (layer == BlockRenderLayer.TRANSLUCENT) {
                this.doTileEntityRenderPass(mb, blocks, 0);
            }
            this.doWorldRenderPass(mb, blocks, layer, eye, activationPoint);
            if (layer != BlockRenderLayer.TRANSLUCENT) continue;
            this.doTileEntityRenderPass(mb, blocks, 1);
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        ForgeHooksClient.setRenderPass((int)-1);
        this.setGlStateForPass(0);
        this.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179121_F();
    }

    private void doWorldRenderPass(MultiblockRenderData mb, Iterable<? extends BlockPos> blocks, @Nonnull BlockRenderLayer layer, Vector4f eye, BlockPos activationPoint) {
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        this.setGlStateForPass(layer);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockPos blockPos : blocks) {
            IBlockState bs = mb.func_180495_p(blockPos);
            Block block = bs.func_177230_c();
            if (blockPos.equals((Object)activationPoint)) {
                if (!block.canRenderInLayer(bs, layer)) continue;
                this.renderBlock(this.showMultiblock ? ACBlocks.multi_block.func_176223_P() : bs, blockPos, mb, Tessellator.func_178181_a().func_178180_c());
                continue;
            }
            if (!block.canRenderInLayer(bs, layer)) continue;
            this.renderBlock(bs, blockPos, mb, Tessellator.func_178181_a().func_178180_c());
        }
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            wr.func_181674_a(eye.x, eye.y, eye.z);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public void renderBlock(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull MultiblockRenderData mb, @Nonnull BufferBuilder worldRendererIn) {
        try {
            BlockRendererDispatcher blockrendererdispatcher = this.field_146297_k.func_175602_ab();
            EnumBlockRenderType type = state.func_185901_i();
            if (type != EnumBlockRenderType.MODEL) {
                blockrendererdispatcher.func_175018_a(state, pos, (IBlockAccess)mb, worldRendererIn);
                return;
            }
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)mb, pos);
            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)mb, ibakedmodel, state, pos, worldRendererIn, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doTileEntityRenderPass(MultiblockRenderData mb, Iterable<? extends BlockPos> blocks, int pass) {
        mb.setWorld((World)this.field_146297_k.field_71441_e);
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        ForgeHooksClient.setRenderPass((int)1);
        this.setGlStateForPass(1);
        for (BlockPos blockPos : blocks) {
            TileEntity te = mb.func_175625_s(blockPos);
            BlockPos relPos = new BlockPos((Entity)this.field_146297_k.field_71439_g);
            if (te == null || this.erroredTiles.contains(te) || !te.shouldRenderInPass(pass)) continue;
            te.func_145834_a((World)this.field_146297_k.field_71441_e);
            te.func_174878_a(relPos.func_177971_a((Vec3i)blockPos));
            try {
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), AbyssalCraftClientEventHooks.partialTicks);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                e.printStackTrace();
            }
        }
        ForgeHooksClient.setRenderPass((int)-1);
        RenderHelper.func_74518_a();
    }

    private void setGlStateForPass(@Nonnull BlockRenderLayer layer) {
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        this.setGlStateForPass(pass);
    }

    private void setGlStateForPass(int layer) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (layer == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    private void initStuff() {
        for (IPlaceOfPower place : StructureHandler.instance().getStructures()) {
            if (!this.isUnlocked(place.getUnlockCondition()) || place.getBookType() > this.getBookType()) continue;
            this.places.add(place);
        }
        this.setTurnupLimit(this.places.size());
    }
}

