/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.necronomicon.condition.caps;

import com.shinoow.abyssalcraft.api.necronomicon.condition.ConditionProcessorRegistry;
import com.shinoow.abyssalcraft.api.necronomicon.condition.IUnlockCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.INecroDataCapability;
import com.shinoow.abyssalcraft.api.necronomicon.condition.caps.NecroDataCapabilityProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class NecroDataCapability
implements INecroDataCapability {
    List<String> biome_triggers = new ArrayList<String>();
    List<String> entity_triggers = new ArrayList<String>();
    List<Integer> dimension_triggers = new ArrayList<Integer>();
    List<String> artifact_triggers = new ArrayList<String>();
    List<String> page_triggers = new ArrayList<String>();
    List<String> whisper_triggers = new ArrayList<String>();
    List<String> misc_triggers = new ArrayList<String>();
    boolean hasAllKnowledge;
    long lastSyncTime = 0L;
    int syncTimer = 0;

    public static INecroDataCapability getCap(EntityPlayer player) {
        return (INecroDataCapability)player.getCapability(NecroDataCapabilityProvider.NECRO_DATA_CAP, null);
    }

    @Override
    public boolean isUnlocked(IUnlockCondition cond, EntityPlayer player) {
        if (cond.getType() == -1 || this.hasAllKnowledge) {
            return true;
        }
        return ConditionProcessorRegistry.instance().getProcessor(cond.getType()).processUnlock(cond, this, player);
    }

    @Override
    public void triggerEntityUnlock(String name) {
        if (name != null && !this.entity_triggers.contains(name) && name.contains(":")) {
            this.entity_triggers.add(name);
        }
    }

    @Override
    public void triggerBiomeUnlock(String name) {
        if (name != null && !this.biome_triggers.contains(name)) {
            this.biome_triggers.add(name);
        }
    }

    @Override
    public void triggerDimensionUnlock(int id) {
        if (!this.dimension_triggers.contains(id)) {
            this.dimension_triggers.add(id);
        }
    }

    @Override
    public void triggerArtifactUnlock(String name) {
        if (name != null && !this.artifact_triggers.contains(name)) {
            this.artifact_triggers.add(name);
        }
    }

    @Override
    public void triggerPageUnlock(String name) {
        if (name != null && !this.page_triggers.contains(name)) {
            this.page_triggers.add(name);
        }
    }

    @Override
    public void triggerWhisperUnlock(String name) {
        if (name != null && !this.page_triggers.contains(name)) {
            this.page_triggers.add(name);
        }
    }

    @Override
    public void triggerMiscUnlock(String name) {
        if (name != null && !this.misc_triggers.contains(name)) {
            this.misc_triggers.add(name);
        }
    }

    @Override
    public void unlockAllKnowledge(boolean unlock) {
        this.hasAllKnowledge = unlock;
    }

    @Override
    public void setLastSyncTime(long time) {
        this.lastSyncTime = time;
    }

    @Override
    public List<String> getBiomeTriggers() {
        return this.biome_triggers;
    }

    @Override
    public List<String> getEntityTriggers() {
        return this.entity_triggers;
    }

    @Override
    public List<Integer> getDimensionTriggers() {
        return this.dimension_triggers;
    }

    @Override
    public List<String> getArtifactTriggers() {
        return this.artifact_triggers;
    }

    @Override
    public List<String> getPageTriggers() {
        return this.page_triggers;
    }

    @Override
    public List<String> getWhisperTriggers() {
        return this.whisper_triggers;
    }

    @Override
    public List<String> getMiscTriggers() {
        return this.misc_triggers;
    }

    @Override
    public boolean hasUnlockedAllKnowledge() {
        return this.hasAllKnowledge;
    }

    @Override
    public long getLastSyncTime() {
        return this.lastSyncTime;
    }

    @Override
    public void incrementSyncTimer() {
        ++this.syncTimer;
    }

    @Override
    public void resetSyncTimer() {
        this.syncTimer = 0;
    }

    @Override
    public int getSyncTimer() {
        return this.syncTimer;
    }

    @Override
    public void copy(INecroDataCapability cap) {
        this.biome_triggers = cap.getBiomeTriggers();
        this.entity_triggers = cap.getEntityTriggers();
        this.dimension_triggers = cap.getDimensionTriggers();
        this.artifact_triggers = cap.getArtifactTriggers();
        this.page_triggers = cap.getPageTriggers();
        this.whisper_triggers = cap.getWhisperTriggers();
        this.misc_triggers = cap.getMiscTriggers();
        this.hasAllKnowledge = cap.hasUnlockedAllKnowledge();
        this.lastSyncTime = cap.getLastSyncTime();
    }
}

