/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectItemModification;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EffectPriest
extends EffectItemModification {
    public static final EffectPriest INSTANCE = new EffectPriest("priest", 100.0f);

    public EffectPriest(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    @Override
    @Nonnull
    public IEffectData doFX(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        World world = housing.getWorldObj();
        BlockPos pos = housing.getCoordinates();
        List<TileFlowerPedastal> frameList = this.getPlantFrames(genome, housing, world, pos, IEffectSettingsHolder.DEFAULT_INSTANCE);
        Random rand = world.field_73012_v;
        int num = 1;
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = pos.func_177982_a(i, k, j);
                    if (!(ForgeHooks.getEnchantPower((World)world, (BlockPos)blockpos) > 0.0f)) continue;
                    if (!world.func_175623_d(pos.func_177982_a(i / 2, 0, j / 2))) continue block1;
                    ++num;
                    world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 1.0f), (double)((float)j + rand.nextFloat()) - 0.5, new int[0]);
                }
            }
        }
        for (TileFlowerPedastal tileFlowerPedastal : frameList) {
            BlockPos p = tileFlowerPedastal.func_174877_v();
            for (int i = 0; i < num; ++i) {
                world.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, (double)((float)(pos.func_177958_n() - p.func_177958_n()) + rand.nextFloat()) - 0.5, (double)((float)(pos.func_177956_o() - p.func_177956_o()) + rand.nextFloat()) - 0.5, (double)((float)(pos.func_177952_p() - p.func_177952_p()) + rand.nextFloat()) - 0.5, new int[0]);
            }
        }
        return super.doFX(genome, storedData, housing);
    }

    @Override
    @Nullable
    public ItemStack modifyStack(IBeeGenome genome, ItemStack stack, @Nullable IBeeHousing housing) {
        Random rand;
        float power = 0.0f;
        if (housing != null) {
            World world = housing.getWorldObj();
            BlockPos position = housing.getCoordinates();
            rand = world.field_73012_v;
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (j == 0 && k == 0 || !world.func_175623_d(position.func_177982_a(k, 0, j)) || !world.func_175623_d(position.func_177982_a(k, 1, j))) continue;
                    power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(k * 2, 0, j * 2));
                    power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(k * 2, 1, j * 2));
                    if (k == 0 || j == 0) continue;
                    power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(k * 2, 0, j));
                    power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(k * 2, 1, j));
                    power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(k, 0, j * 2));
                    power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(k, 1, j * 2));
                }
            }
        } else {
            rand = new Random();
        }
        int n = EnchantmentHelper.func_77514_a((Random)rand, (int)rand.nextInt(3), (int)((int)power), (ItemStack)stack);
        return EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)stack, (int)n, (boolean)true);
    }

    @Override
    public boolean acceptItemStack(ItemStack stack) {
        return stack.func_77984_f() && stack.func_77956_u() && !stack.func_77948_v();
    }
}

