/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EffectButcher
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectEntity {
    public static final EffectButcher INSTANCE = new EffectButcher();
    private static final Comparator<EntityAnimal> entityAnimalComparator = Comparator.comparingInt(a -> Math.abs(a.func_70874_b())).reversed().thenComparing(EntityAnimal::func_70880_s).thenComparingDouble(EntityLivingBase::func_110143_aJ).thenComparingInt(System::identityHashCode);

    public EffectButcher() {
        super("butcher", 20.0f);
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        AxisAlignedBB aabb = EffectButcher.getAABB(genome, housing);
        List animals = world.func_175647_a(EntityAnimal.class, aabb, t -> t != null && !t.func_70631_g_());
        if (animals.size() < 2) {
            return;
        }
        animals.sort(entityAnimalComparator);
        for (EntityAnimal victim : animals) {
            int b = 0;
            for (EntityAnimal animal : animals) {
                if (animal == victim || animal.getClass() != victim.getClass() || (b = (int)((byte)(b + 1))) < 2) continue;
                victim.func_70097_a(DamageSource.field_76367_g, 100.0f);
                return;
            }
        }
    }

    @Override
    public boolean canHandleEntity(Entity livingBase, @Nonnull IBeeGenome genome) {
        return livingBase instanceof EntityAnimal;
    }

    @Override
    public boolean handleEntityLiving(Entity livingBase, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        if (livingBase instanceof EntityAnimal) {
            ((EntityAnimal)livingBase).func_70097_a(DamageSource.field_76367_g, 100.0f);
            return true;
        }
        return false;
    }
}

