/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.Lists;
import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EffectBaseEntity<T extends Entity>
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectEntity {
    private final Predicate<T> entityPredicate;
    private final Class<T> entityClazz;

    public EffectBaseEntity(String name, float baseTicksBetweenProcessing, Predicate<T> entityAnimalPredicate, Class<T> entityClazz) {
        this(name, baseTicksBetweenProcessing, 1.0f, entityAnimalPredicate, entityClazz);
    }

    public EffectBaseEntity(String name, float baseTicksBetweenProcessing, Class<T> entityClazz) {
        this(name, baseTicksBetweenProcessing, 1.0f, entityClazz);
    }

    public EffectBaseEntity(String name, float baseTicksBetweenProcessing, float chanceOfProcessing, Class<T> entityClazz) {
        this(name, baseTicksBetweenProcessing, chanceOfProcessing, arg_0 -> ((com.google.common.base.Predicate)EntitySelectors.field_94557_a).test(arg_0), entityClazz);
    }

    public EffectBaseEntity(String name, float baseTicksBetweenProcessing, float chanceOfProcessing, Predicate<T> entityAnimalPredicate, Class<T> entityClazz) {
        this(name, false, false, baseTicksBetweenProcessing, chanceOfProcessing, entityAnimalPredicate, entityClazz);
    }

    public EffectBaseEntity(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing, Predicate<T> entityAnimalPredicate, Class<T> entityClazz) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
        this.entityPredicate = entityAnimalPredicate;
        this.entityClazz = entityClazz;
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        AxisAlignedBB aabb = EffectBaseEntity.getAABB(genome, housing);
        List entities = world.func_175647_a(this.entityClazz, aabb, this.entityPredicate::test);
        if (!entities.isEmpty()) {
            this.workOnEntities(entities, genome, housing, random, settings);
        }
    }

    protected abstract void workOnEntities(List<T> var1, IBeeGenome var2, IBeeHousing var3, Random var4, IEffectSettingsHolder var5);

    @Override
    public boolean canHandleEntity(Entity livingBase, @Nonnull IBeeGenome genome) {
        return this.entityClazz.isInstance(livingBase) && this.entityPredicate.test(this.entityClazz.cast(livingBase));
    }

    @Override
    public boolean handleEntityLiving(Entity livingBase, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        if (this.entityClazz.isInstance(livingBase)) {
            Entity cast = (Entity)this.entityClazz.cast(livingBase);
            if (this.entityPredicate.test(cast)) {
                ArrayList list = Lists.newArrayList((Object[])new Entity[]{cast});
                this.workOnEntities(list, genome, housing, housing.getWorldObj().field_73012_v, this.getSettings(housing));
            }
            return true;
        }
        return false;
    }
}

