/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import crafttweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.Fluid;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.compatmod.crafttweaker.CraftTweakerCompat;
import techreborn.compatmod.crafttweaker.ZenDocumentation;

@ZenClass(value="mods.techreborn.fluidGen")
public class CTFluidGen {
    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid, int energyPerMb")
    public static void addThermalFluid(ILiquidStack fluid, int energyPerMb) {
        CTFluidGen.addFluid(EFluidGenerator.THERMAL, fluid, energyPerMb);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid, int energyPerMb")
    public static void addGasFluid(ILiquidStack fluid, int energyPerMb) {
        CTFluidGen.addFluid(EFluidGenerator.GAS, fluid, energyPerMb);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid, int energyPerMb")
    public static void addSemiFluid(ILiquidStack fluid, int energyPerMb) {
        CTFluidGen.addFluid(EFluidGenerator.SEMIFLUID, fluid, energyPerMb);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid, int energyPerMb")
    public static void addDieselFluid(ILiquidStack fluid, int energyPerMb) {
        CTFluidGen.addFluid(EFluidGenerator.DIESEL, fluid, energyPerMb);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid, int energyPerMb")
    public static void addPlasmaFluid(ILiquidStack fluid, int energyPerMb) {
        CTFluidGen.addFluid(EFluidGenerator.PLASMA, fluid, energyPerMb);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid")
    public static void removeThermalFluid(ILiquidStack fluid) {
        CTFluidGen.removeFluid(EFluidGenerator.THERMAL, fluid);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid")
    public static void removeGasFluid(ILiquidStack fluid) {
        CTFluidGen.removeFluid(EFluidGenerator.GAS, fluid);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid")
    public static void removeSemiFluid(ILiquidStack fluid) {
        CTFluidGen.removeFluid(EFluidGenerator.SEMIFLUID, fluid);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid")
    public static void removeDieselFluid(ILiquidStack fluid) {
        CTFluidGen.removeFluid(EFluidGenerator.DIESEL, fluid);
    }

    @ZenMethod
    @ZenDocumentation(value="ILiquidStack fluid")
    public static void removePlasmaFluid(ILiquidStack fluid) {
        CTFluidGen.removeFluid(EFluidGenerator.PLASMA, fluid);
    }

    private static void addFluid(EFluidGenerator type, ILiquidStack fluid, int energyPerMb) {
        GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)type, (Fluid)CraftTweakerCompat.toFluidStack(fluid).getFluid(), (int)energyPerMb);
    }

    private static void removeFluid(EFluidGenerator type, ILiquidStack fluid) {
        GeneratorRecipeHelper.removeFluidRecipe((EFluidGenerator)type, (Fluid)CraftTweakerCompat.toFluidStack(fluid).getFluid());
    }
}

