/*
 * Decompiled with CFR 0.152.
 */
package com.astro.discordsuite.rpc;

import com.astro.discordsuite.integration.Image;
import com.astro.discordsuite.rpc.DiscordRichPresence;

public class RichPresenceBuilder {
    private String state;
    private String details;
    private long startTimestamp;
    private long endTimestamp;
    private String largeImageKey;
    private String largeImageText;
    private String smallImageKey;
    private String smallImageText;
    private String partyId;
    private int partySize;
    private int partyMax;
    private String matchSecret;
    private String joinSecret;
    private String spectateSecret;
    private byte instance;

    public String getState() {
        return this.state;
    }

    public RichPresenceBuilder withState(String state) {
        this.state = state;
        return this;
    }

    public String getDetails() {
        return this.details;
    }

    public RichPresenceBuilder withDetails(String details) {
        this.details = details;
        return this;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public RichPresenceBuilder withStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
        return this;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public RichPresenceBuilder withEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
        return this;
    }

    public String getLargeImageKey() {
        return this.largeImageKey;
    }

    public RichPresenceBuilder withLargeImageKey(String largeImageKey) {
        this.largeImageKey = largeImageKey;
        return this;
    }

    public String getLargeImageText() {
        return this.largeImageText;
    }

    public RichPresenceBuilder withLargeImageText(String largeImageText) {
        this.largeImageText = largeImageText;
        return this;
    }

    public String getSmallImageKey() {
        return this.smallImageKey;
    }

    public RichPresenceBuilder withSmallImageKey(String smallImageKey) {
        this.smallImageKey = smallImageKey;
        return this;
    }

    public String getSmallImageText() {
        return this.smallImageText;
    }

    public RichPresenceBuilder withSmallImageText(String smallImageText) {
        this.smallImageText = smallImageText;
        return this;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public RichPresenceBuilder withPartyId(String partyId) {
        this.partyId = partyId;
        return this;
    }

    public int getPartySize() {
        return this.partySize;
    }

    public RichPresenceBuilder withPartySize(int partySize) {
        this.partySize = partySize;
        return this;
    }

    public int getPartyMax() {
        return this.partyMax;
    }

    public RichPresenceBuilder withPartyMax(int partyMax) {
        this.partyMax = partyMax;
        return this;
    }

    public String getMatchSecret() {
        return this.matchSecret;
    }

    public RichPresenceBuilder withMatchSecret(String matchSecret) {
        this.matchSecret = matchSecret;
        return this;
    }

    public String getJoinSecret() {
        return this.joinSecret;
    }

    public RichPresenceBuilder withJoinSecret(String joinSecret) {
        this.joinSecret = joinSecret;
        return this;
    }

    public String getSpectateSecret() {
        return this.spectateSecret;
    }

    public RichPresenceBuilder withSpectateSecret(String spectateSecret) {
        this.spectateSecret = spectateSecret;
        return this;
    }

    public byte getInstance() {
        return this.instance;
    }

    public RichPresenceBuilder withInstance(byte instance) {
        this.instance = instance;
        return this;
    }

    public RichPresenceBuilder withImage(Image image) {
        if (image.getSize().isLarge()) {
            this.withLargeImageKey(image.getKey());
            this.withLargeImageText(image.getText());
        } else {
            this.withSmallImageKey(image.getKey());
            this.withSmallImageText(image.getText());
        }
        return this;
    }

    public DiscordRichPresence build() {
        return new DiscordRichPresence(this.getState(), this.getDetails(), this.getStartTimestamp(), this.getEndTimestamp(), this.getLargeImageKey(), this.getLargeImageText(), this.getSmallImageKey(), this.getSmallImageText(), this.getPartyId(), this.getPartySize(), this.getPartyMax(), this.getMatchSecret(), this.getJoinSecret(), this.getSpectateSecret(), this.getInstance());
    }
}

