/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.block.BlockMetaVariants;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.block.BlockQuarkStairs;
import vazkii.quark.base.handler.BiomeTypeConfigHandler;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockBiomeBrick;
import vazkii.quark.world.block.BlockBiomeCobblestone;
import vazkii.quark.world.block.BlockElderPrismarine;
import vazkii.quark.world.block.BlockElderSeaLantern;
import vazkii.quark.world.block.BlockGlowcelium;
import vazkii.quark.world.block.BlockGlowshroom;
import vazkii.quark.world.block.BlockHugeGlowshroom;
import vazkii.quark.world.block.slab.BlockBasicStoneSlab;
import vazkii.quark.world.world.UndergroundBiomeGenerator;
import vazkii.quark.world.world.underground.UndergroundBiome;
import vazkii.quark.world.world.underground.UndergroundBiomeGlowshroom;
import vazkii.quark.world.world.underground.UndergroundBiomeIcy;
import vazkii.quark.world.world.underground.UndergroundBiomeLava;
import vazkii.quark.world.world.underground.UndergroundBiomeLush;
import vazkii.quark.world.world.underground.UndergroundBiomeOvergrown;
import vazkii.quark.world.world.underground.UndergroundBiomePrismarine;
import vazkii.quark.world.world.underground.UndergroundBiomeSandstone;
import vazkii.quark.world.world.underground.UndergroundBiomeSlime;
import vazkii.quark.world.world.underground.UndergroundBiomeSpiderNest;

public class UndergroundBiomes
extends Feature {
    public static List<UndergroundBiomeGenerator> biomes;
    public static BlockMod biome_cobblestone;
    public static BlockMod biome_brick;
    public static BlockMod glowcelium;
    public static Block glowshroom;
    public static Block glowshroom_block;
    public static BlockMetaVariants<BlockElderPrismarine.Variants> elder_prismarine;
    public static Block elder_sea_lantern;
    public static int glowshroomGrowthRate;
    public static IBlockState firestoneState;
    public static IBlockState icystoneState;
    public static boolean firestoneEnabled;
    public static boolean icystoneEnabled;
    public static boolean glowceliumEnabled;
    public static boolean bigGlowshroomsEnabled;
    public static boolean elderPrismarineEnabled;
    public static boolean enableStairsAndSlabs;
    public static boolean enableWalls;
    public static boolean allowCraftingElderPrismarine;
    private static UndergroundBiomeGenerator prismarineBiomeGen;

    @Override
    public void setupConfig() {
        biomes = new ArrayList<UndergroundBiomeGenerator>();
        firestoneEnabled = this.loadPropBool("Enable Firestone", "", true);
        icystoneEnabled = this.loadPropBool("Enable Froststone", "", true);
        glowceliumEnabled = this.loadPropBool("Enable Glowcelium and Glowshrooms", "", true);
        bigGlowshroomsEnabled = this.loadPropBool("Enable Big Glowshrooms", "", true);
        elderPrismarineEnabled = this.loadPropBool("Enable Elder Prismarine", "", true);
        enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true) && GlobalConfig.enableVariants;
        enableWalls = this.loadPropBool("Enable walls", "", true) && GlobalConfig.enableVariants;
        allowCraftingElderPrismarine = this.loadPropBool("Allow crafting Elder Prismarine", "", true);
        glowshroomGrowthRate = this.loadPropInt("Glowshroom Growth Rate", "The smaller, the faster glowshrooms will spread. Vanilla mushroom speed is 25.", 20);
        biomes.add(this.loadUndergroundBiomeInfo("Lush", new UndergroundBiomeLush(), 80, BiomeDictionary.Type.JUNGLE));
        biomes.add(this.loadUndergroundBiomeInfo("Sandstone", new UndergroundBiomeSandstone(), 80, BiomeDictionary.Type.SANDY));
        biomes.add(this.loadUndergroundBiomeInfo("Slime", new UndergroundBiomeSlime(), 120, BiomeDictionary.Type.SWAMP));
        prismarineBiomeGen = this.loadUndergroundBiomeInfo("Prismarine", new UndergroundBiomePrismarine(), 100, BiomeDictionary.Type.OCEAN);
        biomes.add(prismarineBiomeGen);
        biomes.add(this.loadUndergroundBiomeInfo("Spider", new UndergroundBiomeSpiderNest(), 80, BiomeDictionary.Type.PLAINS));
        biomes.add(this.loadUndergroundBiomeInfo("Overgrown", new UndergroundBiomeOvergrown(), 80, BiomeDictionary.Type.FOREST));
        biomes.add(this.loadUndergroundBiomeInfo("Icy", new UndergroundBiomeIcy(), 80, BiomeDictionary.Type.COLD));
        biomes.add(this.loadUndergroundBiomeInfo("Lava", new UndergroundBiomeLava(), 80, BiomeDictionary.Type.MESA));
        biomes.add(this.loadUndergroundBiomeInfo("Glowshroom", new UndergroundBiomeGlowshroom(), 80, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MUSHROOM));
        if (elder_prismarine != null) {
            ((UndergroundBiomePrismarine)UndergroundBiomes.prismarineBiomeGen.info.biome).update();
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (firestoneEnabled || icystoneEnabled) {
            biome_cobblestone = new BlockBiomeCobblestone();
            biome_brick = new BlockBiomeBrick();
        }
        if (elderPrismarineEnabled) {
            elder_prismarine = new BlockElderPrismarine();
            elder_sea_lantern = new BlockElderSeaLantern();
        }
        ((UndergroundBiomePrismarine)UndergroundBiomes.prismarineBiomeGen.info.biome).update();
        if (enableStairsAndSlabs) {
            if (firestoneEnabled) {
                BlockBasicStoneSlab.initSlab((Block)biome_cobblestone, 0, "fire_stone_slab");
                BlockModStairs.initStairs((Block)biome_cobblestone, (int)0, (BlockStairs)new BlockQuarkStairs("fire_stone_stairs", biome_cobblestone.func_176223_P()));
                BlockBasicStoneSlab.initSlab((Block)biome_brick, 0, "fire_stone_brick_slab");
                BlockModStairs.initStairs((Block)biome_brick, (int)0, (BlockStairs)new BlockQuarkStairs("fire_stone_brick_stairs", biome_brick.func_176223_P()));
            }
            if (icystoneEnabled) {
                BlockBasicStoneSlab.initSlab((Block)biome_cobblestone, 1, "icy_stone_slab");
                BlockModStairs.initStairs((Block)biome_cobblestone, (int)1, (BlockStairs)new BlockQuarkStairs("icy_stone_stairs", biome_cobblestone.func_176223_P().func_177226_a(biome_cobblestone.getVariantProp(), (Comparable)((Object)BlockBiomeCobblestone.Variants.ICY_STONE))));
                BlockBasicStoneSlab.initSlab((Block)biome_brick, 1, "icy_stone_brick_slab");
                BlockModStairs.initStairs((Block)biome_brick, (int)1, (BlockStairs)new BlockQuarkStairs("icy_stone_brick_stairs", biome_brick.func_176223_P().func_177226_a(biome_brick.getVariantProp(), (Comparable)((Object)BlockBiomeBrick.Variants.ICY_STONE_BRICK))));
            }
            if (elderPrismarineEnabled) {
                for (BlockElderPrismarine.Variants v : BlockElderPrismarine.Variants.values()) {
                    BlockBasicStoneSlab.initSlab(elder_prismarine, v.ordinal(), v.func_176610_l() + "_slab");
                    BlockModStairs.initStairs(elder_prismarine, (int)v.ordinal(), (BlockStairs)new BlockQuarkStairs(v.func_176610_l() + "_stairs", elder_prismarine.func_176223_P().func_177226_a(elder_prismarine.getVariantProp(), (Comparable)((Object)v))));
                }
            }
        }
        VanillaWalls.add("fire_stone", (Block)biome_cobblestone, 0, enableWalls && firestoneEnabled);
        VanillaWalls.add("icy_stone", (Block)biome_cobblestone, 1, enableWalls && icystoneEnabled);
        VanillaWalls.add("fire_stone_brick", (Block)biome_brick, 0, enableWalls && firestoneEnabled);
        VanillaWalls.add("icy_stone_brick", (Block)biome_brick, 1, enableWalls && icystoneEnabled);
        for (BlockElderPrismarine.Variants v : BlockElderPrismarine.Variants.values()) {
            VanillaWalls.add(v.func_176610_l(), elder_prismarine, v.ordinal(), enableWalls && elderPrismarineEnabled);
        }
        if (glowceliumEnabled) {
            glowcelium = new BlockGlowcelium();
            glowshroom = new BlockGlowshroom();
            if (bigGlowshroomsEnabled) {
                glowshroom_block = new BlockHugeGlowshroom();
            }
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)new ItemStack(Items.field_151009_A), (Object[])new Object[]{"mushroomAny", "mushroomAny", new ItemStack(Items.field_151054_z)});
        }
        if (firestoneEnabled) {
            firestoneState = biome_cobblestone.func_176223_P().func_177226_a(biome_cobblestone.getVariantProp(), (Comparable)((Object)BlockBiomeCobblestone.Variants.FIRE_STONE));
        }
        if (icystoneEnabled) {
            icystoneState = biome_cobblestone.func_176223_P().func_177226_a(biome_cobblestone.getVariantProp(), (Comparable)((Object)BlockBiomeCobblestone.Variants.ICY_STONE));
        }
        this.addOreDict();
    }

    @Override
    public void postPreInit() {
        if (firestoneEnabled) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)biome_brick, (int)4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), "stoneBrimstone"});
        }
        if (icystoneEnabled) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)biome_brick, (int)4, (int)1), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), "stonePermafrost"});
        }
        if (elderPrismarineEnabled) {
            if (allowCraftingElderPrismarine) {
                RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack(elder_prismarine, (int)2), (Object[])new Object[]{"blockPrismarineElder", "blockPrismarine"});
            }
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack(elder_prismarine, (int)4, (int)1), (Object[])new Object[]{"PPP", "PPP", "PPP", Character.valueOf('P'), "blockPrismarineElder"});
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack(elder_prismarine, (int)1, (int)2), (Object[])new Object[]{"PPP", "PBP", "PPP", Character.valueOf('P'), "blockPrismarineElder", Character.valueOf('B'), "dyeBlack"});
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)elder_sea_lantern), (Object[])new Object[]{"blockPrismarineElder", ProxyRegistry.newStack((Block)Blocks.field_180398_cJ)});
        }
    }

    private void addOreDict() {
        if (glowceliumEnabled) {
            UndergroundBiomes.addOreDict("mushroomAny", (Block)Blocks.field_150337_Q);
            UndergroundBiomes.addOreDict("mushroomAny", (Block)Blocks.field_150338_P);
            UndergroundBiomes.addOreDict("mushroomAny", glowshroom);
        }
        if (firestoneEnabled) {
            UndergroundBiomes.addOreDict("stoneBrimstone", ProxyRegistry.newStack((Block)biome_cobblestone));
            UndergroundBiomes.addOreDict("stoneBrimstonePolished", ProxyRegistry.newStack((Block)biome_brick));
        }
        if (icystoneEnabled) {
            UndergroundBiomes.addOreDict("stonePermafrost", ProxyRegistry.newStack((Block)biome_cobblestone, (int)1, (int)1));
            UndergroundBiomes.addOreDict("stonePermafrostPolished", ProxyRegistry.newStack((Block)biome_cobblestone, (int)1, (int)1));
        }
        if (elderPrismarineEnabled) {
            UndergroundBiomes.addOreDict("blockPrismarineElder", ProxyRegistry.newStack(elder_prismarine));
            UndergroundBiomes.addOreDict("blockPrismarine", ProxyRegistry.newStack(elder_prismarine));
            UndergroundBiomes.addOreDict("blockPrismarineElderBrick", ProxyRegistry.newStack(elder_prismarine, (int)1, (int)1));
            UndergroundBiomes.addOreDict("blockPrismarineBrick", ProxyRegistry.newStack(elder_prismarine, (int)1, (int)1));
            UndergroundBiomes.addOreDict("blockPrismarineElderDark", ProxyRegistry.newStack(elder_prismarine, (int)1, (int)2));
            UndergroundBiomes.addOreDict("blockPrismarineDark", ProxyRegistry.newStack(elder_prismarine, (int)1, (int)2));
        }
    }

    @SubscribeEvent
    public void onOreGenerate(OreGenEvent.GenerateMinable event) {
        if (event.getType() == OreGenEvent.GenerateMinable.EventType.DIRT) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            Chunk chunk = world.func_175726_f(pos);
            for (UndergroundBiomeGenerator gen : biomes) {
                gen.generate(chunk.field_76635_g, chunk.field_76647_h, world);
            }
        }
    }

    @Override
    public boolean hasOreGenSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    private UndergroundBiomeGenerator loadUndergroundBiomeInfo(String name, UndergroundBiome biome, int rarity, BiomeDictionary.Type ... biomes) {
        String category = this.configCategory + "." + name;
        UndergroundBiomeInfo info = new UndergroundBiomeInfo(category, biome, rarity, biomes);
        return new UndergroundBiomeGenerator(info);
    }

    public static class UndergroundBiomeInfo {
        public final boolean enabled;
        public final UndergroundBiome biome;
        public final DimensionConfig dims;
        public final List<BiomeDictionary.Type> types;
        public final int rarity;
        public final int minXSize;
        public final int minYSize;
        public final int minZSize;
        public final int xVariation;
        public final int yVariation;
        public final int zVariation;
        public final int minY;
        public final int maxY;

        private UndergroundBiomeInfo(String category, UndergroundBiome biome, int rarity, BiomeDictionary.Type ... biomes) {
            this.enabled = ModuleLoader.config.getBoolean("Enabled", category, true, "");
            this.biome = biome;
            this.types = BiomeTypeConfigHandler.parseBiomeTypeArrayConfig("Allowed Biome Types", category, biomes);
            this.rarity = ModuleLoader.config.getInt("Rarity", category, rarity, 0, Integer.MAX_VALUE, "This biome will spawn in 1 of X valid chunks");
            this.dims = new DimensionConfig(category);
            this.minY = ModuleLoader.config.getInt("Minimum Y Level", category, 10, 0, 255, "");
            this.maxY = ModuleLoader.config.getInt("Maximum Y Level", category, 40, 0, 255, "");
            this.minXSize = ModuleLoader.config.getInt("X Minimum", category, 26, 0, Integer.MAX_VALUE, "");
            this.minYSize = ModuleLoader.config.getInt("Y Minimum", category, 12, 0, Integer.MAX_VALUE, "");
            this.minZSize = ModuleLoader.config.getInt("Z Minimum", category, 26, 0, Integer.MAX_VALUE, "");
            this.xVariation = ModuleLoader.config.getInt("X Variation", category, 14, 0, Integer.MAX_VALUE, "");
            this.yVariation = ModuleLoader.config.getInt("Y Variation", category, 6, 0, Integer.MAX_VALUE, "");
            this.zVariation = ModuleLoader.config.getInt("Z Variation", category, 14, 0, Integer.MAX_VALUE, "");
            biome.setupBaseConfig(category);
        }
    }
}

