/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.sounds.QuarkSounds;
import vazkii.quark.world.base.EnumStonelingVariant;
import vazkii.quark.world.entity.EntityFrog;
import vazkii.quark.world.entity.ai.EntityAIActWary;
import vazkii.quark.world.entity.ai.EntityAIFavorBlock;
import vazkii.quark.world.entity.ai.EntityAIRunAndPoof;
import vazkii.quark.world.feature.Frogs;
import vazkii.quark.world.feature.Stonelings;

public class EntityStoneling
extends EntityCreature {
    public static final ResourceLocation CARRY_LOOT_TABLE = new ResourceLocation("quark", "entities/stoneling_carry");
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("quark", "entities/stoneling");
    private static final DataParameter<ItemStack> CARRYING_ITEM = EntityDataManager.func_187226_a(EntityStoneling.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(EntityStoneling.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> HOLD_ANGLE = EntityDataManager.func_187226_a(EntityStoneling.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final String TAG_CARRYING_ITEM = "carryingItem";
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_HOLD_ANGLE = "itemAngle";
    private static final String TAG_PLAYER_MADE = "playerMade";
    private EntityAIActWary waryTask;
    private boolean isTame;

    public EntityStoneling(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.9f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRYING_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(HOLD_ANGLE, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.2, 0.98f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFavorBlock((EntityCreature)this, 0.2, Blocks.field_150482_ag));
        if (Stonelings.enableDiamondHeart || Stonelings.tamableStonelings) {
            int priority = Stonelings.tamableStonelings ? 0 : 3;
            this.field_70714_bg.func_75776_a(priority, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.6, Items.field_151045_i, false));
        }
        this.field_70714_bg.func_75776_a(2, new EntityAIRunAndPoof<EntityPlayer>(this, EntityPlayer.class, 4.0f, 0.5, 0.5));
        this.waryTask = new EntityAIActWary(this, 0.1, 6.0, Stonelings.cautiousStonelings);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.waryTask);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && !this.isTame) {
            this.func_70106_y();
        }
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
    }

    public boolean isCreatureType(@Nonnull EnumCreatureType type, boolean forSpawnCount) {
        if (this.isTame) {
            return type == EnumCreatureType.CREATURE;
        }
        return type == EnumCreatureType.MONSTER;
    }

    protected boolean func_70692_ba() {
        return !this.isTame;
    }

    private static boolean fitsOreKey(ItemStack stack, String key) {
        if (stack.func_190926_b()) {
            return false;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        int oreKey = OreDictionary.getOreID((String)key);
        for (int id : ids) {
            if (id != oreKey) continue;
            return true;
        }
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151057_cb) {
            stack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nonnull
    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack playerItem = player.func_184586_b(hand);
            if (!this.field_70170_p.field_72995_K) {
                if (this.isPlayerMade()) {
                    if (!player.func_70093_af() && !playerItem.func_190926_b()) {
                        EnumStonelingVariant currentVariant = this.getVariant();
                        EnumStonelingVariant targetVariant = null;
                        for (EnumStonelingVariant variant : EnumStonelingVariant.values()) {
                            if (!EntityStoneling.fitsOreKey(playerItem, variant.getOreKey())) continue;
                            targetVariant = variant;
                        }
                        if (targetVariant != null) {
                            if (this.field_70170_p instanceof WorldServer) {
                                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.HEART, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 1, 0.1, 0.1, 0.1, 0.1, new int[0]);
                                if (targetVariant != currentVariant) {
                                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 16, 0.1, 0.1, 0.1, 0.25, new int[]{Block.func_176210_f((IBlockState)targetVariant.getDisplayState())});
                                }
                            }
                            if (targetVariant != currentVariant) {
                                this.func_184185_a(QuarkSounds.ENTITY_STONELING_EAT, 1.0f, 1.0f);
                                this.field_70180_af.func_187227_b(VARIANT, (Object)targetVariant.getIndex());
                            }
                            this.func_184185_a(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + this.field_70170_p.field_73012_v.nextFloat() * 1.0f);
                            this.func_70691_i(1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                playerItem.func_190918_g(1);
                            }
                            return EnumActionResult.SUCCESS;
                        }
                        return EnumActionResult.PASS;
                    }
                    ItemStack stonelingItem = (ItemStack)this.field_70180_af.func_187225_a(CARRYING_ITEM);
                    if (!stonelingItem.func_190926_b() || !playerItem.func_190926_b()) {
                        player.func_184611_a(hand, stonelingItem.func_77946_l());
                        this.field_70180_af.func_187227_b(CARRYING_ITEM, (Object)playerItem.func_77946_l());
                        if (playerItem.func_190926_b()) {
                            this.func_184185_a(QuarkSounds.ENTITY_STONELING_GIVE, 1.0f, 1.0f);
                        } else {
                            this.func_184185_a(QuarkSounds.ENTITY_STONELING_TAKE, 1.0f, 1.0f);
                        }
                    }
                } else if (Stonelings.tamableStonelings && EntityStoneling.fitsOreKey(playerItem, "gemDiamond")) {
                    this.func_70691_i(8.0f);
                    this.func_184185_a(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + this.field_70170_p.field_73012_v.nextFloat() * 1.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        playerItem.func_190918_g(1);
                    }
                    if (this.field_70170_p instanceof WorldServer) {
                        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.HEART, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v, 4, 0.1, 0.1, 0.1, 0.1, new int[0]);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        byte variant = data instanceof EnumStonelingVariant ? ((EnumStonelingVariant)data).getIndex() : (byte)this.field_70170_p.field_73012_v.nextInt(EnumStonelingVariant.values().length);
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.field_70180_af.func_187227_b(HOLD_ANGLE, (Object)Float.valueOf(this.field_70170_p.field_73012_v.nextFloat() * 90.0f - 45.0f));
        if (!this.isTame && !this.field_70170_p.field_72995_K) {
            if (ModuleLoader.isFeatureEnabled(Frogs.class) && this.field_70146_Z.nextDouble() < 0.01) {
                EntityFrog frog = new EntityFrog(this.field_70170_p, 0.75f);
                frog.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)frog);
                frog.func_184220_m((Entity)this);
            } else {
                List items = this.field_70170_p.func_184146_ak().func_186521_a(CARRY_LOOT_TABLE).func_186462_a(this.field_70146_Z, new LootContext.Builder((WorldServer)this.field_70170_p).func_186471_a());
                if (!items.isEmpty()) {
                    this.field_70180_af.func_187227_b(CARRYING_ITEM, items.get(0));
                }
            }
        }
        return super.func_180482_a(difficulty, data);
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return source == DamageSource.field_76367_g || source.func_76352_a() || super.func_180431_b(source);
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_70665_d(@Nonnull DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        if (!this.isPlayerMade() && damageSrc.func_76346_g() instanceof EntityPlayer) {
            this.waryTask.startle();
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        ItemStack stack = this.getCarryingItem();
        if (!stack.func_190926_b()) {
            this.func_70099_a(stack, 0.0f);
        }
    }

    protected ResourceLocation func_184647_J() {
        return Stonelings.enableDiamondHeart ? LOOT_TABLE : null;
    }

    public void setPlayerMade(boolean value) {
        this.isTame = value;
    }

    public ItemStack getCarryingItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(CARRYING_ITEM);
    }

    public EnumStonelingVariant getVariant() {
        return EnumStonelingVariant.byIndex((Byte)this.field_70180_af.func_187225_a(VARIANT));
    }

    public float getItemAngle() {
        return ((Float)this.field_70180_af.func_187225_a(HOLD_ANGLE)).floatValue();
    }

    public boolean isPlayerMade() {
        return this.isTame;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(TAG_CARRYING_ITEM, 10)) {
            NBTTagCompound itemCmp = compound.func_74775_l(TAG_CARRYING_ITEM);
            ItemStack stack = new ItemStack(itemCmp);
            this.field_70180_af.func_187227_b(CARRYING_ITEM, (Object)stack);
        }
        this.field_70180_af.func_187227_b(VARIANT, (Object)compound.func_74771_c(TAG_VARIANT));
        this.field_70180_af.func_187227_b(HOLD_ANGLE, (Object)Float.valueOf(compound.func_74760_g(TAG_HOLD_ANGLE)));
        this.setPlayerMade(compound.func_74767_n(TAG_PLAYER_MADE));
    }

    public boolean func_70685_l(Entity entityIn) {
        Vec3d origin = new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
        Vec3d targetBase = new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
        float otherEyes = entityIn.func_70047_e();
        for (float height = 0.0f; height <= otherEyes; height += otherEyes / 8.0f) {
            if (this.field_70170_p.func_147447_a(origin, targetBase.func_72441_c(0.0, (double)height, 0.0), false, true, false) != null) continue;
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a(TAG_CARRYING_ITEM, (NBTBase)this.getCarryingItem().serializeNBT());
        compound.func_74774_a(TAG_VARIANT, this.getVariant().getIndex());
        compound.func_74776_a(TAG_HOLD_ANGLE, this.getItemAngle());
        compound.func_74757_a(TAG_PLAYER_MADE, this.isPlayerMade());
    }

    public boolean func_70601_bi() {
        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        if (state.func_185904_a() != Material.field_151576_e) {
            return false;
        }
        return Stonelings.dimensions.canSpawnHere(this.field_70170_p) && this.field_70163_u < (double)Stonelings.maxYLevel && this.isValidLightLevel() && super.func_70601_bi();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_STONELING_CRY;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return QuarkSounds.ENTITY_STONELING_DIE;
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) != 0) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }
}

