/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.feature;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import vazkii.arl.recipe.BlacklistOreIngredient;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.handler.RecipeProcessor;
import vazkii.quark.base.module.Feature;
import vazkii.quark.decoration.block.BlockCustomChest;
import vazkii.quark.decoration.client.render.RenderTileCustomChest;
import vazkii.quark.decoration.tile.TileCustomChest;
import vazkii.quark.oddities.client.bakery.WrapperWithParticleTexture;

public class VariedChests
extends Feature {
    public static final BlockChest.Type CUSTOM_TYPE_QUARK = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"QUARK", (Class[])new Class[0], (Object[])new Object[0]);
    public static final BlockChest.Type CUSTOM_TYPE_QUARK_TRAP = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"QUARK_TRAP", (Class[])new Class[0], (Object[])new Object[0]);
    public static BlockCustomChest custom_chest;
    public static BlockCustomChest custom_chest_trap;
    public static boolean renameVanillaChests;
    public static boolean addLogRecipe;
    public static boolean reversionRecipe;
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static Method initHorseChest;
    private static Method playChestEquipSound;
    private static ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;
    private static boolean fixedTrappedChest;

    @Override
    public void setupConfig() {
        renameVanillaChests = this.loadPropBool("Rename vanilla chests to Oak (Trapped) Chest", "", true);
        addLogRecipe = this.loadPropBool("Add recipe to craft chests using Logs (makes 4 chests)", "", true);
        reversionRecipe = this.loadPropBool("Enable Conversion to Vanilla Chests", "Set this to true to add a recipe to convert any Quark chest to a vanilla one.\nUse this if some of your mods don't work with the ore dictionary key \"chestWood\".", false);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        custom_chest = new BlockCustomChest("custom_chest", CUSTOM_TYPE_QUARK);
        custom_chest_trap = new BlockCustomChest("custom_chest_trap", CUSTOM_TYPE_QUARK_TRAP);
        VariedChests.registerTile(TileCustomChest.class, "quark_chest");
        ModIntegrationHandler.addCharsetCarry((Block)custom_chest);
        ModIntegrationHandler.addCharsetCarry((Block)custom_chest_trap);
        this.addOreDict();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        this.overrideModel(custom_chest.getRegistryName(), event);
        this.overrideModel(custom_chest_trap.getRegistryName(), event);
    }

    @SideOnly(value=Side.CLIENT)
    private void overrideModel(ResourceLocation keyName, ModelBakeEvent event) {
        ModelResourceLocation key = new ModelResourceLocation(keyName, "normal");
        IBakedModel originalModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)key);
        event.getModelRegistry().func_82595_a((Object)key, (Object)new WrapperWithParticleTexture(event.getModelManager().func_174952_b().func_110572_b("minecraft:blocks/planks_oak"), originalModel));
    }

    @SubscribeEvent
    public void onClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        AbstractChestHorse horse;
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (!held.func_190926_b() && target instanceof AbstractChestHorse && !(horse = (AbstractChestHorse)target).func_190695_dh() && held.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            int oreId = OreDictionary.getOreID((String)"chestWood");
            for (int checkAgainst : OreDictionary.getOreIDs((ItemStack)held)) {
                if (oreId != checkAgainst) continue;
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
                if (!target.field_70170_p.field_72995_K) {
                    ItemStack copy = held.func_77946_l();
                    copy.func_190920_e(1);
                    held.func_190918_g(1);
                    horse.getEntityData().func_74782_a(DONK_CHEST, (NBTBase)copy.serializeNBT());
                    horse.func_110207_m(true);
                    if (initHorseChest == null) {
                        initHorseChest = ObfuscationReflectionHelper.findMethod(AbstractHorse.class, (String)"func_110226_cD", Void.TYPE, (Class[])new Class[0]);
                    }
                    if (playChestEquipSound == null) {
                        playChestEquipSound = ObfuscationReflectionHelper.findMethod(AbstractChestHorse.class, (String)"func_190697_dk", Void.TYPE, (Class[])new Class[0]);
                    }
                    try {
                        initHorseChest.invoke((Object)horse, new Object[0]);
                        playChestEquipSound.invoke((Object)horse, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        AbstractChestHorse horse;
        ItemStack chest;
        EntityLivingBase target = event.getEntityLiving();
        if (target instanceof AbstractChestHorse && !(chest = new ItemStack((horse = (AbstractChestHorse)target).getEntityData().func_74775_l(DONK_CHEST))).func_190926_b() && horse.func_190695_dh()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (target instanceof EntityItem && ((EntityItem)target).func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.func_190926_b()) {
                ((EntityItem)target).func_92058_a(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileCustomChest.class, (TileEntitySpecialRenderer)new RenderTileCustomChest());
        ProxyRegistry.getItemMapping((Block)custom_chest).setTileEntityItemStackRenderer(new TileEntityItemStackRenderer(){
            private final TileCustomChest chest = new TileCustomChest(CUSTOM_TYPE_QUARK);

            public void func_192838_a(ItemStack stack, float partialTicks) {
                this.chest.chestType = custom_chest.getCustomType(stack);
                TileEntityRendererDispatcher.field_147556_a.func_192855_a((TileEntity)this.chest, 0.0, 0.0, 0.0, 0.0f, partialTicks);
            }
        });
        ProxyRegistry.getItemMapping((Block)custom_chest_trap).setTileEntityItemStackRenderer(new TileEntityItemStackRenderer(){
            private final TileCustomChest chest = new TileCustomChest(CUSTOM_TYPE_QUARK_TRAP);

            public void func_192838_a(ItemStack stack, float partialTicks) {
                this.chest.chestType = custom_chest_trap.getCustomType(stack);
                TileEntityRendererDispatcher.field_147556_a.func_192855_a((TileEntity)this.chest, 0.0, 0.0, 0.0, 0.0f, partialTicks);
            }
        });
    }

    @Override
    public void postPreInit() {
        if (renameVanillaChests) {
            Blocks.field_150486_ae.func_149663_c("oak_chest");
            Blocks.field_150447_bR.func_149663_c("oak_chest_trap");
        }
        RecipeProcessor.addWoodReplacements(new Block[]{Blocks.field_150486_ae});
        RecipeProcessor.addConsumer(VariedChests::fixTrappedChestRecipe);
        if (addLogRecipe) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150486_ae, (int)4), (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), ProxyRegistry.newStack((Block)Blocks.field_150364_r)});
        }
        int i = 1;
        for (ChestType type : ChestType.VALID_TYPES) {
            ItemStack out = ProxyRegistry.newStack((Block)custom_chest);
            custom_chest.setCustomType(out, type);
            RecipeHandler.addOreDictRecipe((ItemStack)out.func_77946_l(), (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), ProxyRegistry.newStack((Block)Blocks.field_150344_f, (int)1, (int)i)});
            if (addLogRecipe) {
                ItemStack outFour = out.func_77946_l();
                outFour.func_190920_e(4);
                RecipeHandler.addOreDictRecipe((ItemStack)outFour, (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), ProxyRegistry.newStack((Block)(i > 3 ? Blocks.field_150363_s : Blocks.field_150364_r), (int)1, (int)(i % 4))});
            }
            ItemStack outTrap = ProxyRegistry.newStack((Block)custom_chest_trap);
            custom_chest.setCustomType(outTrap, type);
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)outTrap, (Object[])new Object[]{out.func_77946_l(), ProxyRegistry.newStack((Block)Blocks.field_150479_bC)});
            ++i;
        }
        BlacklistOreIngredient wood = new BlacklistOreIngredient("plankWood", stack -> stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f));
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150486_ae), (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), wood});
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150438_bZ), (Object[])new Object[]{"I I", "ICI", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), "chestWood"});
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_190987_dv), (Object[])new Object[]{"S", "C", "S", Character.valueOf('S'), ProxyRegistry.newStack((Item)Items.field_190930_cZ), Character.valueOf('C'), "chest"});
        if (reversionRecipe) {
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)new ItemStack((Block)Blocks.field_150486_ae), (Object[])new Object[]{"chestWood"});
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)new ItemStack(Blocks.field_150447_bR), (Object[])new Object[]{"chestTrapped"});
        }
    }

    private void addOreDict() {
        VariedChests.addOreDict("chest", ProxyRegistry.newStack((Block)custom_chest, (int)1, (int)Short.MAX_VALUE));
        VariedChests.addOreDict("chest", ProxyRegistry.newStack((Block)custom_chest_trap, (int)1, (int)Short.MAX_VALUE));
        VariedChests.addOreDict("chest", (Block)Blocks.field_150486_ae);
        VariedChests.addOreDict("chest", Blocks.field_150447_bR);
        VariedChests.addOreDict("chestWood", ProxyRegistry.newStack((Block)custom_chest, (int)1, (int)Short.MAX_VALUE));
        VariedChests.addOreDict("chestWood", (Block)Blocks.field_150486_ae);
        VariedChests.addOreDict("chestTrapped", ProxyRegistry.newStack((Block)custom_chest_trap, (int)1, (int)Short.MAX_VALUE));
        VariedChests.addOreDict("chestTrapped", Blocks.field_150447_bR);
    }

    private static void fixTrappedChestRecipe(IRecipe recipe) {
        if (fixedTrappedChest) {
            return;
        }
        if (Objects.toString(recipe.getRegistryName()).equals("minecraft:trapped_chest")) {
            NonNullList ingredients = recipe.func_192400_c();
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (!(ingredient instanceof OreIngredient)) continue;
                BlacklistOreIngredient chest = new BlacklistOreIngredient("chestWood", stack -> stack.func_77973_b() == Item.func_150898_a((Block)custom_chest));
                ingredients.set(i, chest);
                break;
            }
            fixedTrappedChest = true;
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
        fixedTrappedChest = false;
    }

    public static enum ChestType {
        NONE(""),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak");

        public final String name;
        public final ResourceLocation nrmTex;
        public final ResourceLocation dblTex;
        public final ResourceLocation nrmTrapTex;
        public final ResourceLocation dblTrapTex;
        public static final ChestType[] VALID_TYPES;
        public static final Map<String, ChestType> NAME_TO_TYPE;

        private ChestType(String name) {
            this.name = name;
            this.nrmTex = new ResourceLocation("quark:textures/blocks/chests/" + name + ".png");
            this.dblTex = new ResourceLocation("quark:textures/blocks/chests/" + name + "_double.png");
            this.nrmTrapTex = new ResourceLocation("quark:textures/blocks/chests/" + name + "_trap.png");
            this.dblTrapTex = new ResourceLocation("quark:textures/blocks/chests/" + name + "_trap_double.png");
        }

        public static ChestType getType(String type) {
            return NAME_TO_TYPE.getOrDefault(type, NONE);
        }

        static {
            VALID_TYPES = new ChestType[]{SPRUCE, BIRCH, JUNGLE, ACACIA, DARK_OAK};
            NAME_TO_TYPE = new HashMap<String, ChestType>();
            for (ChestType type : VALID_TYPES) {
                NAME_TO_TYPE.put(type.name, type);
            }
        }
    }
}

