/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RfUtils {
    public static int transferPower(@Nullable IEnergyStorage source, @Nullable IEnergyStorage destination, int maxAmount, boolean simulate) {
        if (source == null || destination == null) {
            return 0;
        }
        int amount = source.extractEnergy(destination.receiveEnergy(maxAmount, true), true);
        return destination.receiveEnergy(source.extractEnergy(amount, simulate), simulate);
    }

    public static <T> List<T> getConnectedCapabilities(Capability<T> capability, World world, BlockPos pos) {
        ArrayList<Object> capabilities = new ArrayList<Object>();
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(side));
            if (tile == null || tile.func_145837_r() || !tile.hasCapability(capability, side.func_176734_d())) continue;
            capabilities.add(tile.getCapability(capability, side.func_176734_d()));
        }
        return capabilities;
    }

    public static int distributePowerToFaces(IEnergyStorage source, World world, BlockPos pos, int amountPerFace, boolean simulated) {
        int consumedPower = 0;
        for (EnumFacing dir : EnumFacing.values()) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            if (tile == null || tile.func_145837_r() || !tile.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())) continue;
            consumedPower += RfUtils.transferPower(source, (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()), amountPerFace, simulated);
        }
        return consumedPower;
    }

    public static int consumePowerFromFaces(IEnergyStorage source, World world, BlockPos pos, int amountPerFace, boolean simulated) {
        int receivedPower = 0;
        for (EnumFacing dir : EnumFacing.values()) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            if (tile == null || tile.func_145837_r() || !tile.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())) continue;
            receivedPower += RfUtils.transferPower((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()), source, amountPerFace, simulated);
        }
        return receivedPower;
    }

    public static boolean isPoweredItem(ItemStack stack) {
        return stack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    public static double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        double max = storage.getMaxEnergyStored();
        double diff = max - (double)storage.getEnergyStored();
        return diff / max;
    }

    public static String addPowerTooltip(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return storage.getEnergyStored() + " / " + storage.getMaxEnergyStored();
    }

    public static boolean isItemFull(ItemStack stack) {
        if (RfUtils.isPoweredItem(stack)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return storage.getEnergyStored() == storage.getMaxEnergyStored();
        }
        return false;
    }

    public static void chargeItem(ItemStack stack, IEnergyStorage storage) {
        if (RfUtils.isPoweredItem(stack) && !RfUtils.isItemFull(stack)) {
            IEnergyStorage storageItem = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            int amount2send = storageItem.receiveEnergy(1000, true);
            if (storage.getEnergyStored() >= amount2send) {
                storageItem.receiveEnergy(amount2send, false);
                storage.extractEnergy(amount2send, false);
            }
        }
    }

    public static int dischargeItem(ItemStack stack, int amount, boolean sim) {
        if (RfUtils.isPoweredItem(stack)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return storage.extractEnergy(amount, sim);
        }
        return 0;
    }
}

