/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.logistics.api.core.tiles.misc.signaller.IRedstoneSignaller;
import sonar.logistics.base.utils.ListPacket;
import sonar.logistics.core.tiles.misc.signaller.RedstoneSignallerStatement;

public class PacketEmitterStatement
extends PacketMultipart {
    public RedstoneSignallerStatement statement;
    public ListPacket packetType;

    public PacketEmitterStatement() {
    }

    public PacketEmitterStatement(int slotID, BlockPos pos, ListPacket packetType) {
        super(slotID, pos);
        this.packetType = packetType;
    }

    public PacketEmitterStatement(int slotID, BlockPos pos, ListPacket packetType, RedstoneSignallerStatement filter) {
        super(slotID, pos);
        this.statement = filter;
        this.packetType = packetType;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.statement = (RedstoneSignallerStatement)NBTHelper.instanceNBTSyncable(RedstoneSignallerStatement.class, (NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        }
        this.packetType = ListPacket.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.statement != null);
        if (this.statement != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.statement.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        }
        buf.writeInt(this.packetType.ordinal());
    }

    public static class Handler
    extends PacketMultipartHandler<PacketEmitterStatement> {
        public IMessage processMessage(PacketEmitterStatement message, EntityPlayer player, World world, IMultipartTile part, MessageContext ctx) {
            if (player == null || player.func_130014_f_().field_72995_K || !(part instanceof IRedstoneSignaller)) {
                return null;
            }
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                IRedstoneSignaller tile = (IRedstoneSignaller)part;
                SyncNBTAbstractList<RedstoneSignallerStatement> filters = tile.getStatements();
                switch (message.packetType) {
                    case ADD: {
                        for (RedstoneSignallerStatement filter : filters.getObjects()) {
                            if (!filter.equals(message.statement)) continue;
                            filter.readData(message.statement.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE), NBTHelper.SyncType.SAVE);
                            filters.markChanged();
                            return;
                        }
                        filters.addObject((INBTSyncable)message.statement);
                        break;
                    }
                    case MOVE_DOWN: {
                        int listPos = -1;
                        for (int i = 0; i < filters.objs.size(); ++i) {
                            RedstoneSignallerStatement filter = (RedstoneSignallerStatement)filters.getObjects().get(i);
                            if (!filter.equals(message.statement)) continue;
                            listPos = i;
                        }
                        if (listPos + 1 <= 0 || listPos + 1 >= filters.objs.size()) break;
                        Collections.swap(filters.objs, listPos, listPos + 1);
                        filters.markChanged();
                        break;
                    }
                    case MOVE_UP: {
                        int listPos = -1;
                        for (int i = 0; i < filters.objs.size(); ++i) {
                            RedstoneSignallerStatement filter = (RedstoneSignallerStatement)filters.getObjects().get(i);
                            if (!filter.equals(message.statement)) continue;
                            listPos = i;
                        }
                        if (listPos - 1 < 0 || listPos - 1 >= filters.objs.size()) break;
                        Collections.swap(filters.objs, listPos, listPos - 1);
                        filters.markChanged();
                        break;
                    }
                    case REMOVE: {
                        filters.removeObject((INBTSyncable)message.statement);
                        break;
                    }
                    case CLEAR: {
                        filters.objs.clear();
                        filters.markChanged();
                        break;
                    }
                }
            });
            return null;
        }
    }
}

