/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.ScrollerOrientation;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.logistics.base.gui.GuiLogistics;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.base.requests.colour.CustomColourButton;
import sonar.logistics.base.requests.colour.GuiColourSelection;
import sonar.logistics.base.requests.colour.SpecialFormatButton;
import sonar.logistics.base.requests.colour.TextColourButton;
import sonar.logistics.base.requests.hyperlink.GuiHyperlinkAdd;
import sonar.logistics.base.requests.hyperlink.HyperlinkRequest;
import sonar.logistics.base.requests.hyperlink.IHyperlinkRequirementGui;
import sonar.logistics.base.requests.reference.GuiInfoReferenceSource;
import sonar.logistics.base.requests.reference.IInfoReferenceRequirementGui;
import sonar.logistics.base.requests.reference.InfoReferenceRequest;
import sonar.logistics.core.tiles.displays.gsi.interaction.actions.ClickHyperlink;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.info.references.InfoReference;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.gui.GuiStyledStringFunctions;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.GuiActions;
import sonar.logistics.core.tiles.displays.info.types.text.gui.hotkeys.HotKeyFunctions;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledInfo;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringEditor;
import sonar.logistics.core.tiles.displays.info.types.text.utils.TextSelection;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public abstract class GuiEditStyledStrings
extends GuiStyledStringFunctions
implements IInfoReferenceRequirementGui,
IHyperlinkRequirementGui {
    public long lastCursorClick = -1L;
    public boolean isDragging = false;

    public GuiEditStyledStrings(StyledTextElement text, TileAbstractDisplay display) {
        super(text, display);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + 198, this.field_147009_r + 150, 176, 0, "Align Left", "Aligns the element to the left"));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + 198 + 20, this.field_147009_r + 150, 176, 16, "Align Centre", "Aligns the element to the centre"));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 2, this.field_147003_i + 198 + 40, this.field_147009_r + 150, 176, 32, "Align Right", "Aligns the element to the right"));
        this.field_146292_n.add(new SpecialFormatButton(this, TextFormatting.BOLD, 3, this.field_147003_i + 198, this.field_147009_r + 150 + 20, 176, 48, "Bold", "Make the selected text bold"));
        this.field_146292_n.add(new SpecialFormatButton(this, TextFormatting.ITALIC, 4, this.field_147003_i + 198 + 20, this.field_147009_r + 150 + 20, 176, 64, "Italic", "Italicize the selected text"));
        this.field_146292_n.add(new SpecialFormatButton(this, TextFormatting.UNDERLINE, 5, this.field_147003_i + 198 + 40, this.field_147009_r + 150 + 20, 176, 80, "Underline", "Underline the selected text"));
        this.field_146292_n.add(new SpecialFormatButton(this, TextFormatting.STRIKETHROUGH, 6, this.field_147003_i + 198, this.field_147009_r + 150 + 40, 176, 96, "Strikethrough", "Draw a line through the middle of the selected text"));
        this.field_146292_n.add(new SpecialFormatButton(this, TextFormatting.OBFUSCATED, 7, this.field_147003_i + 198 + 20, this.field_147009_r + 150 + 40, 32, 80, "Obfuscate", "Obfuscates the selected text"));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 8, this.field_147003_i + 198 + 40, this.field_147009_r + 150 + 40, 176, 112, "Font Colour", "Change the colour of the selected text"));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 9, this.field_147003_i + 198 - 20, this.field_147009_r + 150, 176, 160, "Add Info", "Add a reference to a info"));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 10, this.field_147003_i + 198 - 20, this.field_147009_r + 150 + 20, 176, 192, "Add Hyperlink", "Add a hyperlink to the selected text"));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 11, this.field_147003_i + 198 - 20, this.field_147009_r + 150 + 40, 176, 208, "Add Action", "Add an action to the selected text"));
        for (int i = 0; i < 16; ++i) {
            TextFormatting format = TextFormatting.values()[i];
            this.field_146292_n.add(new TextColourButton((GuiSonar)this, 16 + i, this.field_147003_i + 2 + i * 14, this.field_147009_r + 210, format){

                @Override
                public boolean isSelected() {
                    return GuiLogistics.getCurrentColour() == this.colourRGB;
                }
            });
        }
        this.field_146292_n.add(new CustomColourButton(this, 15, this.field_147003_i + 8 + 224, this.field_147009_r + 210, "Configure Custom Colour"){

            @Override
            public boolean isSelected() {
                return false;
            }
        });
        this.scaling_scroller = new SonarScroller(this.field_147003_i + 90, this.field_147009_r + 151, 16, 80);
        this.scaling_scroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.setScalingScroller((float)this.c.percentageScale);
        this.spacing_scroller = new SonarScroller(this.field_147003_i + 90, this.field_147009_r + 151 + 20, 16, 80);
        this.spacing_scroller.setOrientation(ScrollerOrientation.HORIZONTAL);
        this.scaling_field = new SonarTextField(0, this.field_146289_q, 20, 153, 40, 11);
        this.scaling_field.setDigitsOnly(true);
        this.scaling_field.func_146203_f(3);
        this.scaling_field.func_146180_a(String.valueOf((int)(this.scaling_scroller.currentScroll * 100.0f)));
        this.fieldList.add(this.scaling_field);
        this.spacing_field = new SonarTextField(1, this.field_146289_q, 20, 173, 40, 11);
        this.spacing_field.setDigitsOnly(true);
        this.spacing_field.func_146203_f(3);
        this.spacing_field.func_146180_a(String.valueOf((int)(this.spacing_scroller.currentScroll * 100.0f)));
        this.fieldList.add(this.spacing_field);
        this.setSpacingScroller(this.text.spacing / 50);
        this.cursorPosition.setYToLast(this.text);
        this.cursorPosition.setXToLast(this.text);
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof TextColourButton) {
            this.changeSelectedColour(((TextColourButton)button).colour);
            return;
        }
        if (button instanceof CustomColourButton) {
            FMLCommonHandler.instance().showGuiScreen((Object)IGuiOrigin.withOrigin((IGuiOrigin)new GuiColourSelection(this.field_147002_h, this.entity), (Object)this));
            return;
        }
        if (button instanceof SpecialFormatButton) {
            this.toggleSpecialFormatting(((SpecialFormatButton)button).specialFormat);
            return;
        }
        if (button instanceof LogisticsButton) {
            ArrayList select = this.getAllSelections();
            if (select.isEmpty()) {
                select = Lists.newArrayList((Object[])new TextSelection[]{this.getTypeBox()});
            }
            switch (button.field_146127_k) {
                case 0: {
                    this.formatSelectedLines(select, line -> {
                        line.setAlign(WidthAlignment.LEFT);
                        return line;
                    });
                    break;
                }
                case 1: {
                    this.formatSelectedLines(select, line -> {
                        line.setAlign(WidthAlignment.CENTERED);
                        return line;
                    });
                    break;
                }
                case 2: {
                    this.formatSelectedLines(select, line -> {
                        line.setAlign(WidthAlignment.RIGHT);
                        return line;
                    });
                    break;
                }
                case 8: {
                    this.setTextColourOnSelected(GuiLogistics.getCurrentColour());
                    break;
                }
                case 9: {
                    if (!this.cursorPosition.validPosition()) break;
                    FMLClientHandler.instance().showGuiScreen((Object)new GuiInfoReferenceSource(new InfoReferenceRequest((GuiScreen)this, 1), this.text.getGSI(), this.field_147002_h));
                    break;
                }
                case 10: {
                    if (!this.cursorPosition.validPosition()) break;
                    FMLClientHandler.instance().showGuiScreen((Object)new GuiHyperlinkAdd(new HyperlinkRequest((GuiScreen)this), this.text.getGSI(), this.field_147002_h));
                    break;
                }
            }
        }
    }

    @Override
    public void setSpacingScroller(float scaling) {
    }

    @Override
    public void onReferenceRequirementCompleted(List<InfoReference> selected) {
        if (selected.isEmpty()) {
            return;
        }
        ArrayList<IStyledString> newStrings = new ArrayList<IStyledString>();
        selected.forEach(ref -> newStrings.add(new StyledInfo(ref.uuid, ref.refType, this.createStylingFromEnabled())));
        StyledStringEditor.addStyledStrings(this.text, this.cursorPosition, newStrings);
    }

    @Override
    public void onHyperlinkRequirementCompleted(String hyperlink) {
        int id = this.text.addAction(new ClickHyperlink(hyperlink));
        this.formatSelections((line, string) -> {
            string.getStyle().setActionID(id);
            return string;
        });
    }

    @Override
    public boolean doDisplayScreenClick(double clickX, double clickY, int key) {
        if (this.isDoubleClick()) {
            GuiActions.SELECT_ALL.trigger(this);
            this.lastCursorClick = -1L;
        } else {
            if (!GuiScreen.func_146272_n()) {
                if (GuiScreen.func_146271_m() && this.cursorPosition.validPosition() && this.selectPosition.validPosition()) {
                    TextSelection.addWithCombine(this.savedSelections, new TextSelection(this.cursorPosition, this.selectPosition));
                } else {
                    this.savedSelections.clear();
                }
                this.selectPosition.removeCursor();
            }
            this.cursorPosition.setCursor(this.getDragPositionFromContainerXY(clickX, clickY));
            this.lastCursorClick = Minecraft.func_71386_F();
        }
        return true;
    }

    @Override
    public void func_146976_a(float partialTicks, int x, int y) {
        boolean setTextDrag = true;
        Tuple<Boolean, double[]> canClick = this.canClickContainer(x, y);
        if (((Boolean)canClick.func_76341_a()).booleanValue() && this.lastCursorClick != -1L) {
            if (this.isDragging) {
                boolean canContinue = Mouse.isButtonDown((int)0);
                if (!canContinue) {
                    this.isDragging = false;
                } else {
                    this.cursorPosition.setCursor(this.getDragPositionFromMouseXY(x, y));
                }
            } else if (this.lastCursorClick + 100L < Minecraft.func_71386_F()) {
                this.isDragging = Mouse.isButtonDown((int)0);
                this.lastCursorClick = Minecraft.func_71386_F();
                if (this.isDragging) {
                    this.selectPosition.setCursor(this.cursorPosition.x, this.cursorPosition.y);
                }
            }
        }
        super.func_146976_a(partialTicks, x, y);
    }

    @Override
    protected void func_73869_a(char c, int i) throws IOException {
        StyledStringLine ss = this.cursorPosition.validPosition() ? this.cursorPosition.getTypingLine(this.text) : null;
        boolean triggered = HotKeyFunctions.checkFunction(this, ss, c, i);
        GuiActions.UPDATE_TEXT_SCALING.trigger(this);
        if (triggered) {
            return;
        }
        super.func_73869_a(c, i);
    }
}

