/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.fluids;

import net.minecraftforge.fluids.FluidStack;
import sonar.logistics.api.asm.ASMMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.lists.EnumListChange;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;

@ASMMonitoredValue(id="fluid_count", modid="practicallogistics2")
public class FluidCount
implements IMonitoredValue<InfoNetworkFluid> {
    public static final String id = "fluid_count";
    public InfoNetworkFluid fluid;
    public long stored_old = 0L;
    public long capacity_old = 0L;
    public boolean isNew;

    public FluidCount(InfoNetworkFluid stack) {
        this.reset(stack);
        this.isNew = true;
    }

    @Override
    public EnumListChange getChange() {
        if (this.isNew) {
            return EnumListChange.NEW_VALUE;
        }
        EnumListChange final_change = EnumListChange.getChange(this.fluid.getStoredStack().stored, this.stored_old);
        if (!final_change.shouldDelete() && !final_change.shouldUpdate()) {
            final_change = EnumListChange.getChange(this.fluid.getStoredStack().capacity, this.capacity_old);
        }
        return final_change;
    }

    @Override
    public void resetChange() {
        this.stored_old = this.fluid.getStoredStack().stored;
        this.capacity_old = this.fluid.getStoredStack().capacity;
        this.fluid.getStoredStack().stored = 0L;
        this.fluid.getStoredStack().capacity = 0L;
        this.isNew = false;
    }

    @Override
    public void combine(InfoNetworkFluid combine) {
        this.fluid.getStoredStack().stored += combine.getStoredStack().stored;
        this.fluid.getStoredStack().capacity += combine.getStoredStack().capacity;
    }

    public void combine(long stored, long capacity) {
        this.fluid.getStoredStack().stored += stored;
        this.fluid.getStoredStack().capacity += capacity;
    }

    @Override
    public boolean canCombine(InfoNetworkFluid combine) {
        return this.fluid.getStoredStack().equalStack(combine.getStoredStack().fluid);
    }

    @Override
    public boolean canCombine(FluidStack combine) {
        return this.fluid.getStoredStack().equalStack(combine);
    }

    @Override
    public boolean isValid(Object info) {
        return info instanceof InfoNetworkFluid;
    }

    @Override
    public InfoNetworkFluid getSaveableInfo() {
        return this.fluid;
    }

    @Override
    public void reset(InfoNetworkFluid fullInfo) {
        this.fluid = fullInfo.copy();
    }

    @Override
    public void setNew() {
        this.isNew = true;
    }

    @Override
    public boolean shouldDelete(EnumListChange change) {
        return change.shouldDelete() || this.fluid == null || this.fluid.getStored() == 0L;
    }
}

