/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.interaction;

import com.google.common.collect.Lists;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.readers.fluids.handling.DummyFluidHandler;
import sonar.logistics.core.tiles.readers.items.handling.ItemHelper;
import sonar.logistics.network.packets.PacketItemInteractionText;

public class GSIInteractionHelper {
    public static double getGridXScale(DisplayGSI gsi) {
        if (gsi.display.getWidth() < 0.5) {
            return gsi.display.getWidth() / 4.0;
        }
        return gsi.display.getWidth() / 8.0;
    }

    public static double getGridYScale(DisplayGSI gsi) {
        if (gsi.display.getHeight() < 0.5) {
            return gsi.display.getHeight() / 4.0;
        }
        return gsi.display.getHeight() / 8.0;
    }

    public static double getGridXPosition(DisplayGSI gsi, double x) {
        return DisplayElementHelper.toNearestMultiple(x, gsi.getDisplayScaling()[0], GSIInteractionHelper.getGridXScale(gsi));
    }

    public static double getGridYPosition(DisplayGSI gsi, double y) {
        return DisplayElementHelper.toNearestMultiple(y, gsi.getDisplayScaling()[1], GSIInteractionHelper.getGridYScale(gsi));
    }

    public static boolean withinX(double x, double[] clickBox) {
        return x >= Math.min(clickBox[0], clickBox[2]) && x <= Math.max(clickBox[0], clickBox[2]);
    }

    public static boolean withinY(double y, double[] clickBox) {
        return y >= Math.min(clickBox[1], clickBox[3]) && y <= Math.max(clickBox[1], clickBox[3]);
    }

    public static boolean checkClick(double x, double y, double[] clickBox) {
        return GSIInteractionHelper.withinX(x, clickBox) && GSIInteractionHelper.withinY(y, clickBox);
    }

    public static Pair<Integer, ItemInteractionType> getItemsToRemove(BlockInteractionType type) {
        switch (type) {
            case LEFT: {
                return new Pair((Object)1, (Object)ItemInteractionType.REMOVE);
            }
            case RIGHT: {
                return new Pair((Object)64, (Object)ItemInteractionType.ADD);
            }
            case SHIFT_LEFT: {
                return new Pair((Object)64, (Object)ItemInteractionType.REMOVE);
            }
        }
        return new Pair((Object)0, (Object)ItemInteractionType.ADD);
    }

    public static void screenItemStackClicked(int networkID, StoredItemStack storedItemStack, DisplayScreenClick click, EntityPlayer player, NBTTagCompound clickTag) {
        Pair<Integer, ItemInteractionType> toRemove = GSIInteractionHelper.getItemsToRemove(click.type);
        ILogisticsNetwork network = LogisticsNetworkHandler.instance().getNetwork(networkID);
        if ((Integer)toRemove.a != 0 && network.isValid()) {
            switch ((ItemInteractionType)((Object)toRemove.b)) {
                case ADD: {
                    ItemStack stack = player.func_184586_b(player.func_184600_cs()).func_77946_l();
                    if (stack.func_190926_b()) break;
                    long prev = ItemHelper.getItemCount(stack, network);
                    if (!click.doubleClick) {
                        player.func_184611_a(player.func_184600_cs(), ItemHelper.insertItemStack(network, stack, 64));
                    } else {
                        ItemHelper.transferPlayerInventoryToNetwork(player, network, IS -> StoredItemStack.isEqualStack((ItemStack)IS, (ItemStack)stack), Integer.MAX_VALUE);
                    }
                    long after = ItemHelper.getItemCount(stack, network);
                    if (prev == after) break;
                    PL2.network.sendTo((IMessage)new PacketItemInteractionText(stack, after, after - prev), (EntityPlayerMP)player);
                    InfoPacketHelper.createRapidItemUpdate(Lists.newArrayList((Object[])new ItemStack[]{stack}), networkID);
                    break;
                }
                case REMOVE: {
                    if (storedItemStack == null) break;
                    long prev = ItemHelper.getItemCount(storedItemStack.getItemStack(), network);
                    ItemHelper.transferNetworkInventoryToPlayer(player, network, IS -> storedItemStack.equalStack(IS), (Integer)toRemove.a);
                    long after = ItemHelper.getItemCount(storedItemStack.getItemStack(), network);
                    if (prev == after) break;
                    PL2.network.sendTo((IMessage)new PacketItemInteractionText(storedItemStack.getItemStack(), after, -(prev - after)), (EntityPlayerMP)player);
                    InfoPacketHelper.createRapidItemUpdate(Lists.newArrayList((Object[])new ItemStack[]{storedItemStack.getItemStack()}), networkID);
                    break;
                }
            }
        }
    }

    public static void onScreenFluidStackClicked(int networkID, StoredFluidStack fluidStack, DisplayScreenClick click, EntityPlayer player, NBTTagCompound clickTag) {
        ILogisticsNetwork network = LogisticsNetworkHandler.instance().getNetwork(networkID);
        if (network.isValid()) {
            FluidStack toUpdate;
            DummyFluidHandler handler = new DummyFluidHandler(network, fluidStack);
            EnumHand hand = player.func_184600_cs();
            ItemStack heldItem = player.func_184586_b(hand);
            FluidActionResult result = FluidActionResult.FAILURE;
            FluidStack fluidStack2 = toUpdate = fluidStack == null ? FluidUtil.getFluidContained((ItemStack)heldItem) : fluidStack.getFullStack();
            if (click.type == BlockInteractionType.RIGHT) {
                result = FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
            } else if (fluidStack != null && click.type == BlockInteractionType.LEFT) {
                result = FluidUtil.tryFillContainer((ItemStack)heldItem, (IFluidHandler)handler, (int)((int)Math.min(1000L, fluidStack.stored)), (EntityPlayer)player, (boolean)true);
            } else if (fluidStack != null && click.type == BlockInteractionType.SHIFT_LEFT) {
                result = FluidUtil.tryFillContainer((ItemStack)heldItem, (IFluidHandler)handler, (int)((int)Math.min(Integer.MAX_VALUE, fluidStack.stored)), (EntityPlayer)player, (boolean)true);
            }
            if (result.isSuccess()) {
                player.func_184611_a(hand, result.getResult());
                if (toUpdate != null) {
                    InfoPacketHelper.createRapidFluidUpdate(Lists.newArrayList((Object[])new FluidStack[]{toUpdate}), networkID);
                }
            }
        }
    }

    public static enum ItemInteractionType {
        ADD,
        REMOVE;

    }
}

