/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FunctionHelper;
import sonar.core.helpers.ListHelper;
import sonar.core.listener.ISonarListener;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.guidance.errors.ErrorDestroyed;
import sonar.logistics.base.guidance.errors.ErrorDisconnected;
import sonar.logistics.base.guidance.errors.ErrorHelper;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.base.utils.PL2RemovalType;
import sonar.logistics.core.tiles.displays.DisplayHelper;
import sonar.logistics.core.tiles.displays.DisplayViewerHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayGSISaveHandler;

public class DisplayInfoReferenceHandler {
    public static Map<ILogicListenable, UpdateCause> updates = new HashMap<ILogicListenable, UpdateCause>();

    public static void queueUpdate(ILogicListenable logicTile, UpdateCause cause) {
        UpdateCause current = updates.get(logicTile);
        if (current == null || current.ordinal() > cause.ordinal()) {
            updates.put(logicTile, cause);
        }
    }

    public static Map<DisplayGSI, List<InfoUUID>> getConnectionsForTile(Map<DisplayGSI, List<InfoUUID>> connected, ILogicListenable logicTile) {
        if (logicTile instanceof IInfoProvider) {
            IInfoProvider provider = (IInfoProvider)logicTile;
            for (int i = 0; i < provider.getMaxInfo(); ++i) {
                InfoUUID uuid = new InfoUUID(provider.getIdentity(), i);
                DisplayInfoReferenceHandler.forEachGSIDisplayingUUID(uuid, gsi -> {
                    connected.computeIfAbsent((DisplayGSI)((Object)gsi), FunctionHelper.ARRAY);
                    ListHelper.addWithCheck((Collection)((Collection)connected.get(gsi)), (Object)uuid);
                });
            }
        }
        return connected;
    }

    public static void doInfoReferenceConnect(DisplayGSI gsi, List<InfoUUID> uuids) {
        if (uuids.isEmpty()) {
            return;
        }
        BlockCoords coords = gsi.getDisplay().getActualDisplay().getCoords();
        List<ILogicListenable> logicTiles = DisplayHelper.getLocalProviders(gsi.getDisplay(), (IBlockAccess)gsi.getWorld(), coords.getBlockPos());
        block0: for (InfoUUID uuid : uuids) {
            for (ILogicListenable tile : logicTiles) {
                if (tile.getIdentity() != uuid.getIdentity()) continue;
                ErrorHelper.removeError(gsi, new ErrorDisconnected(uuid, (INetworkTile)tile));
                DisplayInfoReferenceHandler.doLocalProviderConnect(gsi, tile, uuid);
                continue block0;
            }
            ILogicListenable listen = ServerInfoHandler.instance().getNetworkTileMap().get(uuid.identity);
            if (listen == null) continue;
            DisplayInfoReferenceHandler.doLocalProviderDisconnect(gsi, listen, uuid);
            ErrorHelper.addError(gsi, new ErrorDisconnected(uuid, (INetworkTile)listen));
        }
    }

    public static void doInfoReferenceDisconnect(DisplayGSI gsi, List<InfoUUID> uuids) {
        if (uuids.isEmpty()) {
            return;
        }
        for (InfoUUID uuid : uuids) {
            ILogicListenable listen = ServerInfoHandler.instance().getNetworkTileMap().get(uuid.identity);
            if (listen == null) continue;
            DisplayInfoReferenceHandler.doLocalProviderDisconnect(gsi, listen, uuid);
            ErrorHelper.removeError(gsi, new ErrorDisconnected(uuid, (INetworkTile)listen));
        }
    }

    private static void doLocalProviderConnect(DisplayGSI display, ILogicListenable logicTile, InfoUUID uuid) {
        logicTile.getListenerList().getDisplayListeners().addListener((ISonarListener)display, new int[]{0});
        ServerInfoHandler.instance().markChanged(logicTile, uuid);
        display.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.INFO_REFERENCES);
        display.forEachWatcher(watcher -> logicTile.getListenerList().addListener((EntityPlayer)watcher, new Enum[]{ListenerType.TEMPORARY_LISTENER}));
    }

    private static void doLocalProviderDisconnect(DisplayGSI display, ILogicListenable logicTile, InfoUUID uuid) {
        logicTile.getListenerList().getDisplayListeners().removeListener((ISonarListener)display, true, new int[]{0});
        ServerInfoHandler.instance().markChanged(logicTile, uuid);
        display.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.INFO_REFERENCES);
    }

    public static void updateLocalProviderConnections() {
        if (!updates.isEmpty()) {
            for (Map.Entry<ILogicListenable, UpdateCause> update : updates.entrySet()) {
                Map<DisplayGSI, List<InfoUUID>> affected = DisplayInfoReferenceHandler.getConnectionsForTile(new HashMap<DisplayGSI, List<InfoUUID>>(), update.getKey());
                switch (update.getValue()) {
                    case NETWORK_CHANGE: {
                        affected.forEach(DisplayInfoReferenceHandler::doInfoReferenceConnect);
                        break;
                    }
                    case TILE_DESTROYED: {
                        affected.forEach((GSI, UUIDS) -> {
                            ErrorHelper.removeError(GSI, new ErrorDisconnected((List<InfoUUID>)UUIDS, (INetworkTile)update.getKey()));
                            ErrorHelper.addError(GSI, new ErrorDestroyed((List<InfoUUID>)UUIDS, (INetworkTile)update.getKey()));
                        });
                        break;
                    }
                    case TILE_UNLOADED: {
                        affected.forEach((GSI, UUIDS) -> {
                            ErrorDisconnected error = new ErrorDisconnected((List<InfoUUID>)UUIDS, (INetworkTile)update.getKey());
                            error.chunkUnload = true;
                            ErrorHelper.addError(GSI, error);
                        });
                        break;
                    }
                }
            }
            updates.clear();
        }
    }

    public static List<EntityPlayerMP> getPlayersWatchingUUID(InfoUUID uuid) {
        ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
        ServerInfoHandler.instance().getGSIMap().values().forEach(gsi -> {
            if (gsi.isDisplayingUUID(uuid)) {
                ListHelper.addWithCheck((Collection)players, DisplayViewerHandler.instance().getWatchingPlayers((DisplayGSI)((Object)gsi)));
            }
        });
        return players;
    }

    public static void forEachGSIDisplayingUUID(InfoUUID uuid, Consumer<DisplayGSI> action) {
        ServerInfoHandler.instance().getGSIMap().values().forEach(gsi -> {
            if (gsi.isDisplayingUUID(uuid)) {
                action.accept((DisplayGSI)((Object)gsi));
            }
        });
    }

    public static enum UpdateCause {
        TILE_DESTROYED,
        TILE_UNLOADED,
        NETWORK_CHANGE;


        public static UpdateCause getCause(PL2AdditionType type) {
            return NETWORK_CHANGE;
        }

        public static UpdateCause getCause(PL2RemovalType type) {
            switch (type) {
                case CHUNK_UNLOADED: {
                    return TILE_UNLOADED;
                }
                case PLAYER_REMOVED: {
                    return TILE_DESTROYED;
                }
            }
            return NETWORK_CHANGE;
        }
    }
}

