/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.base;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.common.block.SonarMaterials;
import sonar.core.integration.multipart.BlockSonarMultipart;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.base.utils.LogisticsHelper;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.base.utils.PL2RemovalType;
import sonar.logistics.core.tiles.base.TileLogistics;

public abstract class BlockLogistics
extends BlockSonarMultipart {
    public PL2Multiparts multipart;

    public BlockLogistics(PL2Multiparts multipart) {
        super(SonarMaterials.machine);
        this.multipart = multipart;
    }

    public PL2Multiparts getMultipart() {
        return this.multipart;
    }

    public TileEntity func_149915_a(@Nonnull World var1, int var2) {
        return this.getMultipart().createTileEntity();
    }

    public AxisAlignedBB getCollisionBoundingBox(World world, BlockPos pos, IBlockState state) {
        return this.func_185496_a(state, (IBlockAccess)world, pos);
    }

    public boolean hasStandardGui() {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.hasStandardGui() && this.canOpenGui(player)) {
            TileEntity tile = world.func_175625_s(pos);
            if (!tile.func_145831_w().field_72995_K && tile instanceof TileSonarMultipart) {
                ((TileSonarMultipart)tile).openFlexibleGui(player, 0);
            }
            return true;
        }
        return false;
    }

    public boolean canOpenGui(EntityPlayer player) {
        return !LogisticsHelper.isPlayerUsingOperator(player);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileLogistics && !world.field_72995_K) {
            ((TileLogistics)tile).doAdditionEvent(PL2AdditionType.PLAYER_ADDED);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileLogistics && !world.field_72995_K) {
            ((TileLogistics)tile).doRemovalEvent(PL2RemovalType.PLAYER_REMOVED);
        }
        super.func_180663_b(world, pos, state);
    }
}

