/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.items.guide;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.TextFormatting;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.core.items.guide.GuidePageRegistry;
import sonar.logistics.core.items.guide.pages.elements.ElementInfo;
import sonar.logistics.core.items.guide.pages.elements.ElementLink;
import sonar.logistics.core.items.guide.pages.pages.IGuidePage;

public class GuidePageHelper {
    public static String OBJ = "&&";
    public static String FORMAT_START = "<";
    public static String FORMAT_END = ">";
    public static String PAGE_LINK = "#";
    public static String PAGE_LINK_PLACEHOLDER = "\u00a3";
    public static String PAGE_LINK_ERROR = TextFormatting.RED + "PAGE NOT FOUND";
    public static String CURRENT = "CURRENT";
    public static int maxLinesPerPage = 17;

    public static List<String> getLines(IGuidePage current, int ordinal, int lineTally, ElementInfo info, List<ElementLink> links) {
        String toTest;
        int n;
        String value = FontHelper.translate((String)info.key);
        for (String string : info.additionals) {
            value = value.replaceFirst(OBJ, string);
        }
        for (String string : TextFormatting.values()) {
            value = value.replaceAll(FORMAT_START + string.func_96297_d() + FORMAT_END, string.toString());
        }
        int index = 0;
        ArrayList<Integer> pageIDs = new ArrayList<Integer>();
        while ((index = value.indexOf(PAGE_LINK)) != -1 && (n = (toTest = value.substring(index + 1)).indexOf(PAGE_LINK)) > 0) {
            IGuidePage linkedPage = null;
            String pageString = toTest.substring(0, n);
            if (!pageString.equals(CURRENT)) {
                if (Character.isDigit(toTest.charAt(0))) {
                    int pgNum = Integer.parseInt(pageString);
                    linkedPage = GuidePageRegistry.getGuidePage(pgNum);
                } else {
                    linkedPage = GuidePageRegistry.getGuidePage(pageString);
                }
                pageString = PAGE_LINK + pageString + PAGE_LINK;
                value = value.replaceFirst(pageString, PAGE_LINK_PLACEHOLDER + (linkedPage == null ? PAGE_LINK_ERROR : TextFormatting.BLUE + "" + TextFormatting.UNDERLINE + linkedPage.getDisplayName()) + TextFormatting.RESET);
                pageIDs.add(linkedPage != null ? linkedPage.pageID() : -1);
                continue;
            }
            pageString = PAGE_LINK + pageString + PAGE_LINK;
            value = value.replaceAll(pageString, current.getDisplayName());
        }
        return GuidePageHelper.createLines(current, ordinal, lineTally, info, new ArrayList<String>(), Lists.newArrayList(pageIDs).iterator(), links, value);
    }

    public static List<String> createLines(IGuidePage current, int ordinal, int lineTally, ElementInfo info, List<String> lines, Iterator<Integer> pageNums, List<ElementLink> pageLinks, String str) throws StackOverflowError {
        String[] split;
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        for (String sp : split = str.split("-")) {
            int pg = ordinal + (lines.size() + lineTally) / maxLinesPerPage;
            int i = FontHelper.sizeStringToWidth((FontRenderer)render, (String)sp, (int)current.getLineWidth(lines.size() + lineTally - pg * maxLinesPerPage, pg));
            if (sp.length() <= i) {
                GuidePageHelper.addNewLine(sp, lines, pageNums, pageLinks);
                continue;
            }
            String s = sp.substring(0, i);
            char c0 = sp.charAt(i);
            boolean flag = c0 == ' ' || c0 == '\n';
            String s1 = FontRenderer.func_78282_e((String)s) + sp.substring(i + (flag ? 1 : 0));
            GuidePageHelper.addNewLine(s, lines, pageNums, pageLinks);
            GuidePageHelper.createLines(current, ordinal, lineTally, info, lines, pageNums, pageLinks, s1);
        }
        return lines;
    }

    public static void addNewLine(String line, List<String> lines, Iterator<Integer> iterator, List<ElementLink> pageLinks) {
        int index = 0;
        while ((index = line.indexOf(PAGE_LINK_PLACEHOLDER)) != -1 && iterator.hasNext()) {
            int link = iterator.next();
            IGuidePage linked = GuidePageRegistry.getGuidePage(link);
            String before = line.substring(0, index);
            pageLinks.add(new ElementLink(link, RenderHelper.fontRenderer.func_78256_a(linked != null ? linked.getDisplayName() : PAGE_LINK_ERROR), lines.size(), RenderHelper.fontRenderer.func_78256_a(before)));
            line = before + line.substring(index + 1);
        }
        lines.add(line);
    }

    public static Object getRecipeForItem(ItemStack stack) {
        IRecipe itemRecipe = null;
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            ItemStack output = recipe.func_77571_b();
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)output)) continue;
            itemRecipe = recipe;
        }
        return itemRecipe;
    }
}

